/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

class OracleTriggerBuilder
extends OracleDBObjectBuilder {
    private static final String TRIGGER_QUERY = "SELECT '" + Trigger.TRIGGER_TYPES[0] + "', A.TRIGGER_TYPE, A.TRIGGERING_EVENT, " + "A.TABLE_OWNER, A.TABLE_NAME, A.REFERENCING_NAMES, A.WHEN_CLAUSE, " + "A.TRIGGER_BODY, B.COLUMN_NAME, B.COLUMN_LIST " + "FROM SYS.ALL_TRIGGERS A, SYS.ALL_TRIGGER_COLS B " + "WHERE A.OWNER = B.TRIGGER_OWNER(+) AND A.TRIGGER_NAME = B.TRIGGER_NAME(+) AND " + "A.OWNER = ? AND A.TRIGGER_NAME = ?";

    OracleTriggerBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "TRIGGER");
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Trigger trigger = new Trigger(schema, string);
        trigger.setID(dBObjectID);
        return trigger;
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        Trigger trigger = (Trigger)schemaObject;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                String string = this.getQueryString();
                String string2 = AbstractDBObjectProvider.convertObject(trigger.getSchema());
                String string3 = trigger.getName();
                statement = this.getConnection().prepareStatement(string);
                statement.setString(1, string2);
                statement.setString(2, string3);
                this.sqlTrace(string, new Object[]{string2, string3});
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    String string4 = resultSet.getString(1);
                    OracleTriggerBuilder._parseBaseType(string4, trigger);
                    int n = trigger.getBaseType();
                    if (n != 1) {
                        string4 = resultSet.getString(2);
                        OracleTriggerBuilder._parseTriggerType(string4, trigger);
                    }
                    OracleTriggerBuilder._parseTriggeringEvent(resultSet.getString(3), trigger);
                    string4 = resultSet.getString(4);
                    Schema schema = string4 != null ? this.getDatabase().getSchema(string4) : null;
                    OracleTriggerBuilder._parseOwnerAndName(schema, resultSet.getString(5), trigger);
                    if (n == 1 || n == 0 && !trigger.isStatementLevel()) {
                        OracleTriggerBuilder._parseReferencingNames(resultSet.getString(6), trigger);
                    }
                    trigger.setWhenClause(resultSet.getString(7));
                    trigger.setCode(resultSet.getString(8));
                    ArrayList<String> arrayList = new ArrayList<String>();
                    string4 = resultSet.getString(9);
                    while (string4 != null) {
                        String string5 = resultSet.getString(10);
                        if ("Y".equals(string5) || "YES".equals(string5)) {
                            arrayList.add(string4);
                        }
                        String string6 = string4 = resultSet.next() ? resultSet.getString(9) : null;
                    }
                    trigger.setColumns(arrayList);
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String getQueryString() {
        return TRIGGER_QUERY;
    }

    private static void _parseBaseType(String string, Trigger trigger) {
        int n = -1;
        if (string != null) {
            string = string.trim();
            int n2 = 0;
            while (n2 < Trigger.TRIGGER_TYPES.length) {
                if (Trigger.TRIGGER_TYPES[n2].equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        trigger.setBaseType(n);
    }

    private static void _parseTriggerType(String string, Trigger trigger) {
        switch (trigger.getBaseType()) {
            case 0: {
                if ("BEFORE STATEMENT".equals(string)) {
                    trigger.setTiming(0);
                    trigger.setStatementLevel(true);
                    break;
                }
                if ("BEFORE EACH ROW".equals(string)) {
                    trigger.setTiming(0);
                    trigger.setStatementLevel(false);
                    break;
                }
                if ("AFTER STATEMENT".equals(string)) {
                    trigger.setTiming(1);
                    trigger.setStatementLevel(true);
                    break;
                }
                if (!"AFTER EACH ROW".equals(string)) break;
                trigger.setTiming(1);
                trigger.setStatementLevel(false);
                break;
            }
            case 2: 
            case 3: {
                if ("BEFORE EVENT".equals(string)) {
                    trigger.setTiming(0);
                    break;
                }
                if (!"AFTER EVENT".equals(string)) break;
                trigger.setTiming(1);
                break;
            }
        }
    }

    private static void _parseTriggeringEvent(String string, Trigger trigger) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if ("OR".equalsIgnoreCase(string2)) continue;
                arrayList.add(string2);
            }
        }
        trigger.setEvents(arrayList);
    }

    private static void _parseOwnerAndName(Schema schema, String string, Trigger trigger) {
        switch (trigger.getBaseType()) {
            case 3: {
                break;
            }
            case 2: {
                trigger.setTableOwner(schema);
                break;
            }
            case 0: 
            case 1: {
                trigger.setTableOwner(schema);
                trigger.setTableName(string);
            }
        }
    }

    private static void _parseReferencingNames(String string, Trigger trigger) {
        if (string != null) {
            String[] stringArray = new String[2];
            boolean bl = false;
            int n = -1;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (bl) {
                    stringArray[n] = string2;
                    n = -1;
                    bl = false;
                    continue;
                }
                if ("OLD".equals(string2)) {
                    n = 0;
                    continue;
                }
                if ("NEW".equals(string2)) {
                    n = 1;
                    continue;
                }
                if ("AS".equals(string2)) {
                    bl = true;
                    continue;
                }
                n = -1;
            }
            if (!"OLD".equals(stringArray[0]) || !"NEW".equals(stringArray[1])) {
                trigger.setReferenceNames(stringArray);
            }
        }
    }
}

