/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleRelationBuilder;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;

class OracleViewBuilder
extends OracleRelationBuilder {
    private static final String VIEW_TEXT_QUERY = "SELECT TEXT_LENGTH, TEXT FROM SYS.ALL_VIEWS WHERE OWNER = ? AND VIEW_NAME = ?";

    protected OracleViewBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "VIEW");
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        View view = new View(string, schema);
        view.setID(dBObjectID);
        return view;
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        super.fillInObject(schemaObject);
        View view = (View)schemaObject;
        if (this.needsBuilding(view, "SQLQuery")) {
            this.fillInQueryText(view);
        }
    }

    private void fillInQueryText(View view) throws DBException {
        OracleDBObjectBuilder.QueryWrapper queryWrapper = new OracleDBObjectBuilder.QueryWrapper(VIEW_TEXT_QUERY, view.getSchema(), view);
        try {
            try {
                ResultSet resultSet = queryWrapper.executeQuery();
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    String string = resultSet.getString(2);
                    if (string != null) {
                        if (string.toUpperCase().trim().endsWith("WITH CHECK OPTION")) {
                            view.setQueryRestriction("WITH CHECK OPTION");
                            string = string.substring(0, string.toUpperCase().lastIndexOf("WITH") - 1);
                        } else if (string.toUpperCase().trim().endsWith("WITH READ ONLY")) {
                            view.setQueryRestriction("WITH READ ONLY");
                            string = string.substring(0, string.toUpperCase().lastIndexOf("WITH") - 1);
                        }
                        SQLQuery sQLQuery = OracleViewBuilder.buildQuery(this.getDatabase(), view.getSchema(), string);
                        view.setSQLQuery(sQLQuery);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(sQLException);
            }
        }
        finally {
            queryWrapper.close();
        }
    }

    public static final SQLQuery buildQuery(BaseOracleDatabase baseOracleDatabase, Schema schema, String string) throws DBException {
        return new NonDeclarativeSQLQuery(string);
    }

    protected boolean canBuildComponents() {
        return true;
    }

    protected void fillInObjectComponent(SchemaObject schemaObject, String string) throws DBException {
        if (string.equals("SQLQuery")) {
            this.fillInQueryText((View)schemaObject);
        } else {
            super.fillInObjectComponent(schemaObject, string);
        }
    }
}

