/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Function;
import oracle.javatools.db.Package;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Procedure;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.datatypes.ObjectType;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.DBSourceBuilder;
import oracle.javatools.db.plsql.PlSqlDeclarator;

class PlSqlSourceBuilder
extends DBSourceBuilder {
    protected static final String PL_SQL_SOURCE_QUERY = "SELECT TEXT FROM SYS.ALL_SOURCE WHERE TYPE = ? AND OWNER = ? AND NAME = ? ORDER BY LINE";

    PlSqlSourceBuilder(BaseOracleDatabase baseOracleDatabase, String string) {
        super(baseOracleDatabase, string);
        if (!("FUNCTION".equals(string) || "PROCEDURE".equals(string) || "PACKAGE".equals(string) || "TYPE".equals(string))) {
            throw new IllegalArgumentException("Illegal object type: " + string);
        }
    }

    protected String getQuery() {
        return PL_SQL_SOURCE_QUERY;
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        PlSql plSql = null;
        String string2 = this.getObjectType();
        if ("FUNCTION".equals(string2)) {
            plSql = new Function(string, schema);
        } else if ("PROCEDURE".equals(string2)) {
            plSql = new Procedure(string, schema);
        } else if ("PACKAGE".equals(string2)) {
            plSql = new Package(string, schema);
        } else if ("TYPE".equals(string2)) {
            plSql = new ObjectType(string, schema);
        }
        if (plSql != null) {
            plSql.setID(dBObjectID);
        }
        return plSql;
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        PlSqlDeclarator plSqlDeclarator;
        PlSql plSql = (PlSql)schemaObject;
        String string = this.getSource(plSql);
        plSql.setSource(string);
        if (plSql instanceof SpecPlSql) {
            SpecPlSql specPlSql = (SpecPlSql)plSql;
            String string2 = this.getBodySource(specPlSql);
            specPlSql.setBodySource(string2);
        }
        if ((plSqlDeclarator = plSql.getDeclarator(this.getDatabase())) != null) {
            plSqlDeclarator.loadDeclarativeInfo(plSql);
        }
    }
}

