/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;

public class RecycledObject
extends AbstractSchemaObject {
    public static final String TYPE = "RECYCLEBIN";
    public static final String OPERATION_DROP = "DROP";
    public static final String OPERATION_TRUNCATE = "TRUNCATE";
    private String m_originalName;
    private String m_originalType;
    private String m_operation;
    private String m_tsName;
    private String m_createTime;
    private String m_dropTime;
    private String m_partitionName;
    private boolean m_canUndrop;
    private boolean m_canPurge;
    private Long m_dropSCN;
    private int m_space;
    private DBObjectID m_related;
    private DBObjectID m_base;
    private DBObjectID m_purge;

    void $init$() {
        this.m_dropSCN = null;
        this.m_space = -1;
    }

    public RecycledObject() {
        this.$init$();
    }

    public RecycledObject(String string, Schema schema, DBObjectID dBObjectID) {
        super(string, schema, dBObjectID);
        this.$init$();
    }

    public String getType() {
        return TYPE;
    }

    public String getOriginalName() {
        this.checkInit();
        return this.m_originalName;
    }

    public void setOriginalName(String string) {
        this.checkInit();
        this.m_originalName = string;
    }

    public String getOriginalType() {
        this.checkInit();
        return this.m_originalType;
    }

    public void setOriginalType(String string) {
        this.checkInit();
        this.m_originalType = string;
    }

    public String getOperation() {
        this.checkInit();
        return this.m_operation;
    }

    public void setOperation(String string) {
        this.checkInit();
        if (ModelUtil.hasLength((String)string) && !string.equals(OPERATION_DROP) && !string.equals(OPERATION_TRUNCATE)) {
            throw new IllegalArgumentException("operation must be DROP or TRUNCATE");
        }
        this.m_operation = string;
    }

    public String getTablespaceName() {
        this.checkInit();
        return this.m_tsName;
    }

    public void setTablespaceName(String string) {
        this.checkInit();
        this.m_tsName = string;
    }

    public String getCreateTime() {
        this.checkInit();
        return this.m_createTime;
    }

    public void setCreateTime(String string) {
        this.checkInit();
        this.m_createTime = string;
    }

    public String getPartitionName() {
        this.checkInit();
        return this.m_partitionName;
    }

    public void setPartitionName(String string) {
        this.checkInit();
        this.m_partitionName = string;
    }

    public String getDropTime() {
        this.checkInit();
        return this.m_dropTime;
    }

    public void setDropTime(String string) {
        this.checkInit();
        this.m_dropTime = string;
    }

    public boolean canUndrop() {
        this.checkInit();
        return this.m_canUndrop;
    }

    public void setCanUndrop(boolean bl) {
        this.checkInit();
        this.m_canUndrop = bl;
    }

    public boolean canPurge() {
        this.checkInit();
        return this.m_canPurge;
    }

    public void setCanPurge(boolean bl) {
        this.checkInit();
        this.m_canPurge = bl;
    }

    public int getSpace() {
        this.checkInit();
        return this.m_space;
    }

    public void setSpace(int n) {
        this.checkInit();
        this.m_space = n;
    }

    public Long getDropSCN() {
        this.checkInit();
        return this.m_dropSCN;
    }

    public void setDropSCN(Long l) {
        this.checkInit();
        this.m_dropSCN = l;
    }

    public DBObjectID getPurgeObjectID() {
        this.checkInit();
        return this.m_purge;
    }

    public void setPurgeObjectID(DBObjectID dBObjectID) {
        this.checkInit();
        this.m_purge = dBObjectID;
    }

    public DBObjectID getBaseObjectID() {
        this.checkInit();
        return this.m_base;
    }

    public void setBaseObjectID(DBObjectID dBObjectID) {
        this.checkInit();
        this.m_base = dBObjectID;
    }

    public DBObjectID getRelatedObjectID() {
        this.checkInit();
        return this.m_related;
    }

    public void setRelatedObjectID(DBObjectID dBObjectID) {
        this.checkInit();
        this.m_related = dBObjectID;
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        RecycledObject recycledObject = dBObject == null ? new RecycledObject() : (RecycledObject)dBObject;
        this.copyToImpl(recycledObject, bl);
        return recycledObject;
    }

    protected void copyToImpl(RecycledObject recycledObject, boolean bl) {
        super.copyToImpl(recycledObject, bl);
        recycledObject.m_originalName = this.m_originalName;
        recycledObject.m_originalType = this.m_originalType;
        recycledObject.m_operation = this.m_operation;
        recycledObject.m_tsName = this.m_tsName;
        recycledObject.m_createTime = this.m_createTime;
        recycledObject.m_dropTime = this.m_dropTime;
        recycledObject.m_dropSCN = this.m_dropSCN;
        recycledObject.m_partitionName = this.m_partitionName;
        recycledObject.m_canUndrop = this.m_canUndrop;
        recycledObject.m_canPurge = this.m_canPurge;
        recycledObject.m_related = this.m_related;
        recycledObject.m_base = this.m_base;
        recycledObject.m_purge = this.m_purge;
        recycledObject.m_space = this.m_space;
    }

    public boolean equals(Object object) {
        return object instanceof RecycledObject && this.equalsImpl((RecycledObject)object);
    }

    protected boolean equalsImpl(RecycledObject recycledObject) {
        return super.equalsImpl(recycledObject) && ModelUtil.areEqual((Object)this.m_originalName, (Object)recycledObject.m_originalName) && ModelUtil.areEqual((Object)this.m_originalType, (Object)recycledObject.m_originalType) && ModelUtil.areEqual((Object)this.m_operation, (Object)recycledObject.m_operation) && ModelUtil.areEqual((Object)this.m_tsName, (Object)recycledObject.m_tsName) && ModelUtil.areEqual((Object)this.m_createTime, (Object)recycledObject.m_createTime) && ModelUtil.areEqual((Object)this.m_dropTime, (Object)recycledObject.m_dropTime) && ModelUtil.areEqual((Object)this.m_partitionName, (Object)recycledObject.m_partitionName) && ModelUtil.areEqual((Object)this.m_related, (Object)recycledObject.m_related) && ModelUtil.areEqual((Object)this.m_base, (Object)recycledObject.m_base) && ModelUtil.areEqual((Object)this.m_purge, (Object)recycledObject.m_purge) && this.m_dropSCN == recycledObject.m_dropSCN && this.m_space == recycledObject.m_space && this.m_canUndrop == recycledObject.m_canUndrop && this.m_canPurge == recycledObject.m_canPurge;
    }
}

