/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.RecycledObject;
import oracle.javatools.db.ora.TopLevelObjectID;

public class RecycledObjectBuilder
extends OracleDBObjectBuilder {
    public static final String YES = "YES";

    public RecycledObjectBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "RECYCLEBIN");
    }

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        return new RecycledObject(string, schema, dBObjectID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        Connection connection;
        RecycledObject recycledObject = (RecycledObject)schemaObject;
        Connection connection2 = connection = this.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    String string = this.getQuery();
                    String string2 = AbstractDBObjectProvider.convertObject(schemaObject);
                    statement = connection.prepareStatement(string);
                    statement.setString(1, string2);
                    if (this.isSysdba()) {
                        String string3 = AbstractDBObjectProvider.convertObject(schemaObject.getSchema());
                        statement.setString(2, string3);
                    }
                    this.sqlTrace(string, new Object[]{string2});
                    resultSet = statement.executeQuery();
                    if (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        recycledObject.setOriginalName(string4);
                        String string5 = resultSet.getString(2);
                        recycledObject.setOperation(string5);
                        String string6 = resultSet.getString(3);
                        recycledObject.setOriginalType(string6);
                        String string7 = resultSet.getString(4);
                        recycledObject.setTablespaceName(string7);
                        String string8 = resultSet.getString(5);
                        recycledObject.setCreateTime(string8);
                        String string9 = resultSet.getString(6);
                        recycledObject.setDropTime(string9);
                        Long l = resultSet.getLong(7);
                        recycledObject.setDropSCN(l);
                        String string10 = resultSet.getString(8);
                        recycledObject.setPartitionName(string10);
                        String string11 = resultSet.getString(9);
                        recycledObject.setCanUndrop(YES.equals(string11));
                        String string12 = resultSet.getString(10);
                        recycledObject.setCanPurge(YES.equals(string12));
                        int n = resultSet.getInt(11);
                        recycledObject.setSpace(n);
                        int n2 = resultSet.getInt(12);
                        recycledObject.setRelatedObjectID(TopLevelObjectID.createObjectID(n2, string6, this.getDatabase()));
                        int n3 = resultSet.getInt(13);
                        recycledObject.setBaseObjectID(TopLevelObjectID.createObjectID(n3, string6, this.getDatabase()));
                        int n4 = resultSet.getInt(14);
                        recycledObject.setPurgeObjectID(TopLevelObjectID.createObjectID(n4, string6, this.getDatabase()));
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(sQLException);
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private String getQuery() {
        if (this.isSysdba()) {
            return "SELECT ORIGINAL_NAME, OPERATION, TYPE, TS_NAME, CREATETIME, DROPTIME,  DROPSCN, PARTITION_NAME, CAN_UNDROP, CAN_PURGE, SPACE, RELATED, BASE_OBJECT, PURGE_OBJECT FROM DBA_RECYCLEBIN WHERE OBJECT_NAME = ? AND OWNER = ? ";
        }
        return "SELECT ORIGINAL_NAME, OPERATION, TYPE, TS_NAME, CREATETIME, DROPTIME,  DROPSCN, PARTITION_NAME, CAN_UNDROP, CAN_PURGE, SPACE, RELATED, BASE_OBJECT, PURGE_OBJECT FROM RECYCLEBIN WHERE OBJECT_NAME = ? ";
    }

    private boolean isSysdba() {
        return ((OracleDatabaseImpl)this.getDatabase()).hasPrivilege("SYSDBA");
    }
}

