/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePartition
extends AbstractDBObject {
    public static final String TYPE = "PARTITION";
    public static final String COMPRESS = "COMPRESS";
    public static final String NOCOMPRESS = "NOCOMPRESS";
    private transient String _display;
    private String _name;
    private OracleTablePartitions.PartitionType _partitionType;
    private OracleTablePartitions.ObjectType _objectType;
    private OracleStorageProperties _segmentAttributes;
    private String _compression;
    private ArrayList<LOBDescriptor> _lobDescriptors;
    private ArrayList _values;
    private OracleTablePartitions _partition_level_subpartitions;
    private static final char COMMA = ',';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';

    public TablePartition() {
        this.$init$();
    }

    public TablePartition(String string) {
        this.$init$();
        this._name = string;
    }

    public TablePartition(OracleTablePartitions.PartitionType partitionType, OracleTablePartitions.ObjectType objectType) {
        this.$init$();
        this._partitionType = partitionType;
        this._objectType = objectType;
    }

    public TablePartition(String string, OracleTablePartitions.PartitionType partitionType, OracleTablePartitions.ObjectType objectType) {
        this.$init$();
        this._name = string;
        this._partitionType = partitionType;
        this._objectType = objectType;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public DBObject getParent() {
        return null;
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        TablePartition tablePartition = dBObject != null ? (TablePartition)dBObject : new TablePartition();
        this.copyToImpl(tablePartition, bl);
        return tablePartition;
    }

    public boolean equals(Object object) {
        return object instanceof TablePartition && this.equalsImpl((TablePartition)object);
    }

    public void setPartitionType(OracleTablePartitions.PartitionType partitionType) {
        this._display = null;
        this._partitionType = partitionType;
    }

    public OracleTablePartitions.PartitionType getPartitionType() {
        return this._partitionType;
    }

    public void setObjectType(OracleTablePartitions.ObjectType objectType) {
        this._objectType = objectType;
    }

    public OracleTablePartitions.ObjectType getObjectType() {
        return this._objectType;
    }

    @Override
    public void setName(String string) {
        this._display = null;
        this._name = string;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setSegmentAttributes(OracleStorageProperties oracleStorageProperties) {
        this._segmentAttributes = oracleStorageProperties;
    }

    public OracleStorageProperties getSegmentAttributes() {
        return this._segmentAttributes;
    }

    public void setCompression(String string) {
        this._compression = string;
    }

    public String getCompression() {
        return this._compression;
    }

    public void setLOBDescriptors(LOBDescriptor[] lOBDescriptorArray) {
        this.removeAllLOBDescriptors();
        int n = 0;
        while (n < lOBDescriptorArray.length) {
            this.addLOBDescriptor(lOBDescriptorArray[n]);
            ++n;
        }
    }

    public void addLOBDescriptor(LOBDescriptor lOBDescriptor) {
        if (lOBDescriptor != null) {
            this._lobDescriptors.add(lOBDescriptor);
        }
    }

    public void removeLOBDescriptor(LOBDescriptor lOBDescriptor) {
        this._lobDescriptors.remove(lOBDescriptor);
    }

    public void removeAllLOBDescriptors() {
        this._lobDescriptors.removeAll(this._lobDescriptors);
    }

    public LOBDescriptor[] getLOBDescriptors() {
        return this._lobDescriptors.toArray(new LOBDescriptor[this._lobDescriptors.size()]);
    }

    public void setValues(Object[] objectArray) {
        this._display = null;
        this._values.removeAll(this._values);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.addValue(objectArray[n]);
                ++n;
            }
        }
    }

    public void setValues(String string) {
        this._display = null;
        this._values.removeAll(this._values);
        if (ModelUtil.hasLength((String)string)) {
            this._values.addAll(this._splitValues(string));
        }
    }

    public Object[] getValues() {
        return this._values.toArray(new Object[this._values.size()]);
    }

    public void addValue(Object object) {
        this._display = null;
        if (object != null) {
            this._values.add(object);
        }
    }

    public void addValue(Object object, int n) {
        this._display = null;
        if (object != null) {
            this._values.add(n, object);
        }
    }

    public void removeValue(Object object) {
        this._display = null;
        this._values.remove(object);
    }

    public void removeValueAt(int n) {
        this._display = null;
        this._values.remove(n);
    }

    public void setPartitionLevelSubpartitions(OracleTablePartitions oracleTablePartitions) {
        this._partition_level_subpartitions = oracleTablePartitions;
    }

    public OracleTablePartitions getPartitionLevelSubpartitions() {
        return this._partition_level_subpartitions;
    }

    public void validate(Table table) throws ValidationException {
        if (this._name == null && this._objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            throw new ValidationException((DBObject)table, DBArb.getString(220));
        }
        this.validateCompression(table);
        this.validateSegmentAttributes(table);
        this.validateLOBDescriptors(table);
        this.validateValues(table);
        this.validatePartitionLevelSubpartitions(table);
    }

    public void validateValues(Table table) throws ValidationException {
        this._validateTypes(table);
        if (this._partitionType == OracleTablePartitions.PartitionType.RANGE) {
            this._validateRangeValues(table);
        } else if (this._partitionType == OracleTablePartitions.PartitionType.LIST) {
            this._validateListValues(table);
        } else if (this._partitionType == OracleTablePartitions.PartitionType.HASH && this._values.size() > 0) {
            throw new ValidationException((DBObject)table, DBArb.getString(200));
        }
    }

    public void validatePartitionLevelSubpartitions(Table table) throws ValidationException {
        this._validateTypes(table);
        if (this._partitionType != OracleTablePartitions.PartitionType.RANGE && this._partition_level_subpartitions != null) {
            throw new ValidationException((DBObject)table, DBArb.getString(203));
        }
    }

    public void validateCompression(Table table) throws ValidationException {
        if (this._compression != null && (this._objectType != OracleTablePartitions.ObjectType.PARTITION || this._partitionType == OracleTablePartitions.PartitionType.HASH && this._objectType == OracleTablePartitions.ObjectType.PARTITION)) {
            throw new ValidationException((DBObject)table, DBArb.format(205, COMPRESS));
        }
        if (this._compression != null && !this._compression.equalsIgnoreCase(COMPRESS) && !this._compression.equalsIgnoreCase(NOCOMPRESS)) {
            throw new ValidationException((DBObject)table, DBArb.format(206, this._compression));
        }
    }

    public void validateSegmentAttributes(Table table) throws ValidationException {
        if (this._segmentAttributes != null) {
            this._segmentAttributes.validate(table);
        }
    }

    public void validateLOBDescriptors(Table table) throws ValidationException {
        int n = 0;
        while (n < this._lobDescriptors.size()) {
            LOBDescriptor lOBDescriptor = this._lobDescriptors.get(n);
            lOBDescriptor.validate(table, this._partitionType, this._objectType);
            ++n;
        }
    }

    protected void copyToImpl(TablePartition tablePartition, boolean bl) {
        super.copyToImpl(tablePartition, bl);
        tablePartition._name = this._name;
        tablePartition._partitionType = this._partitionType;
        tablePartition._objectType = this._objectType;
        ModelUtil.deepCopy((List)this._values, (List)tablePartition._values);
        tablePartition._compression = this._compression;
        tablePartition._segmentAttributes = this._segmentAttributes == null ? null : (OracleStorageProperties)this._segmentAttributes.copyTo(null);
        ModelUtil.deepCopy(this._lobDescriptors, tablePartition._lobDescriptors);
        tablePartition._partition_level_subpartitions = this._partition_level_subpartitions == null ? null : (OracleTablePartitions)this._partition_level_subpartitions.copyTo(null, bl);
    }

    protected boolean equalsImpl(TablePartition tablePartition) {
        return ModelUtil.areEqual((Object)this._name, (Object)tablePartition._name) && ModelUtil.areEqual((Object)((Object)this._partitionType), (Object)((Object)tablePartition._partitionType)) && ModelUtil.areEqual((Object)((Object)this._objectType), (Object)((Object)tablePartition._objectType)) && ModelUtil.areEqual((Object)this._values, (Object)tablePartition._values) && ModelUtil.areEqual((Object)this._compression, (Object)tablePartition._compression) && ModelUtil.areEqual((Object)this._segmentAttributes, (Object)tablePartition._segmentAttributes) && ModelUtil.areEqual(this._lobDescriptors, tablePartition._lobDescriptors) && ModelUtil.areEqual((Object)this._partition_level_subpartitions, (Object)tablePartition._partition_level_subpartitions);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String[] stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this._partition_level_subpartitions != null && this.includesType("PARTITION MODEL", stringArray)) {
            collection.add(this._partition_level_subpartitions);
        }
    }

    private void _validateTypes(Table table) throws ValidationException {
        if (this._partitionType == null) {
            throw new ValidationException((DBObject)table, DBArb.getString(189));
        }
        if (this._objectType == null) {
            throw new ValidationException((DBObject)table, DBArb.getString(190));
        }
    }

    private void _validateRangeValues(Table table) throws ValidationException {
        int n = 0;
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        if (oracleTablePartitions != null) {
            DBObjectID[] dBObjectIDArray = oracleTablePartitions.getPartitionColumns();
            n = dBObjectIDArray.length;
        }
        int n2 = 0;
        for (Object e : this._values) {
            n2 += e instanceof String ? this._splitValues((String)e).size() : 1;
        }
        if (n2 == 0 || n != n2) {
            throw new ValidationException((DBObject)table, DBArb.getString(204));
        }
    }

    private void _validateListValues(Table table) throws ValidationException {
        if (this._values.size() < 1) {
            throw new ValidationException((DBObject)table, DBArb.getString(198));
        }
        int n = 0;
        while (n < this._values.size()) {
            if (this._values.get(n) != null && this._values.get(n) == ListValue.DEFAULT && this._values.size() > 1) {
                throw new ValidationException((DBObject)table, DBArb.getString(196));
            }
            ++n;
        }
    }

    @Override
    public String toString() {
        if (this._display == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (ModelUtil.hasLength((String)this._name)) {
                stringBuffer.append(this._name).append(" ");
            }
            if (this._partitionType == OracleTablePartitions.PartitionType.LIST) {
                stringBuffer.append("VALUES (");
            } else if (this._partitionType == OracleTablePartitions.PartitionType.RANGE) {
                stringBuffer.append("VALUES LESS THAN (");
            }
            Iterator iterator = this._values.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            if (this._partitionType == OracleTablePartitions.PartitionType.LIST || this._partitionType == OracleTablePartitions.PartitionType.RANGE) {
                stringBuffer.append(")");
            }
            this._display = stringBuffer.length() > 0 ? stringBuffer.toString() : "<partition>";
        }
        return this._display;
    }

    @Override
    public int hashCode() {
        return this._name != null ? this._name.hashCode() : (this._partitionType != null ? this._partitionType.hashCode() : 0);
    }

    private List _splitValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ModelUtil.hasLength((String)string)) {
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                if (bl) {
                    bl = c == '\'' ^ true;
                } else if (bl2) {
                    bl2 = c == '\"' ^ true;
                } else if (n > 0) {
                    n += c == '(' ? 1 : (c == ')' ? -1 : 0);
                } else if (c == ',') {
                    String string2 = string.substring(n2, n3).trim();
                    if (ModelUtil.hasLength((String)string2)) {
                        arrayList.add(string2);
                    }
                    n2 = n3 + 1;
                } else {
                    bl = c == '\'';
                    bl2 = c == '\"';
                    n = c == '(' ? 1 : 0;
                }
                ++n3;
            }
            if (n2 < string.length()) {
                arrayList.add(string.substring(n2).trim());
            }
        }
        return arrayList;
    }

    void $init$() {
        this._lobDescriptors = new ArrayList();
        this._values = new ArrayList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RangeValue {
        MAXVALUE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ListValue
    extends Enum {
        private static final /* synthetic */ ListValue[] $v;
        public static final /* enum */ ListValue NULL;
        public static final /* enum */ ListValue DEFAULT;

        public static ListValue valueOf(String string) {
            return Enum.valueOf(ListValue.class, string);
        }

        public static final ListValue[] values() {
            return (ListValue[])$v.clone();
        }

        static {
            ListValue[] listValueArray = new ListValue[2];
            listValueArray[1] = DEFAULT = new ListValue();
            listValueArray[0] = NULL = new ListValue();
            $v = listValueArray;
        }
    }
}

