/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.ArrayList;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PlSqlAttribute;
import oracle.javatools.db.PlSqlMethod;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlAdt;
import oracle.javatools.parser.plsql.data.PlsqlHasName;
import oracle.javatools.parser.plsql.data.PlsqlName;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlPkg;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.PlsqlSubprg;
import oracle.javatools.parser.plsql.data.PlsqlType;
import oracle.javatools.parser.plsql.data.PlsqlVariable;
import oracle.javatools.util.ModelUtil;

public abstract class PlSqlDeclarator {
    private SourceObject m_src;
    protected PlsqlRoot m_root;
    protected DBObjectProvider m_prv;
    public static final int NAME = 5;
    public static final int ATTRIBUTES = 21;
    public static final int METHODS = 20;

    public PlSqlDeclarator() {
    }

    public PlSqlDeclarator(DBObjectProvider dBObjectProvider) {
        this.m_prv = dBObjectProvider;
    }

    public void checkRoot() {
        if (this.m_root == null) {
            String string = this.m_src.getSource() == null ? "" : this.m_src.getSource();
            ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)string);
            PlsqlParser.ParsingOptions parsingOptions = new PlsqlParser.ParsingOptions();
            parsingOptions.inputType = 0;
            this.m_root = PlsqlParser.parsePlsql((ReadTextBuffer)readTextBuffer);
        }
    }

    public void loadDeclarativeInfo(SourceObject sourceObject) {
        this.m_src = sourceObject;
    }

    protected void checkState() {
        this.checkRoot();
        if (this.m_root == null && !(this.m_root instanceof PlsqlRoot)) {
            throw new IllegalStateException("PlSqlDeclarator class not properly initialized.");
        }
    }

    protected SourceObject getSourceObject() {
        return this.m_src;
    }

    protected PlsqlRoot getRoot() {
        this.checkRoot();
        return this.m_root;
    }

    public PlsqlNode getKid(int n, String string) {
        PlsqlNode[] plsqlNodeArray = this._getKids(n, string);
        return plsqlNodeArray != null && plsqlNodeArray.length == 1 ? plsqlNodeArray[0] : null;
    }

    public PlsqlNode[] getKids(int n) {
        return this._getKids(n, null);
    }

    private PlsqlNode[] _getKids(int n, String string) {
        this.checkState();
        ArrayList<PlsqlNode> arrayList = new ArrayList<PlsqlNode>();
        PlsqlNode[] plsqlNodeArray = null;
        if (this.getRoot().getUnits().length == 1 && this.getRoot().getUnits()[0] instanceof PlsqlAdt) {
            PlsqlAdt plsqlAdt = (PlsqlAdt)this.getRoot().getUnits()[0];
            plsqlNodeArray = plsqlAdt.getComponents();
        } else if (this.getRoot().getUnits().length == 1 && this.getRoot().getUnits()[0] instanceof PlsqlPkg) {
            PlsqlPkg plsqlPkg = (PlsqlPkg)this.getRoot().getUnits()[0];
            plsqlNodeArray = plsqlPkg.getDeclarations();
        }
        if (plsqlNodeArray != null) {
            int n2 = 0;
            while (plsqlNodeArray != null && n2 < plsqlNodeArray.length) {
                if (plsqlNodeArray[n2].getTreeKind() == n && (string == null || string.equals(this.getName(plsqlNodeArray[n2])))) {
                    arrayList.add(plsqlNodeArray[n2]);
                }
                ++n2;
            }
        }
        return arrayList.toArray(new PlsqlNode[arrayList.size()]);
    }

    public String getName(PlsqlNode plsqlNode) {
        PlsqlName plsqlName;
        if (plsqlNode instanceof PlsqlHasName && (plsqlName = ((PlsqlHasName)plsqlNode).getName()) != null) {
            String string = plsqlName.toString();
            return this.m_prv == null ? string : this.m_prv.getInternalName(string);
        }
        return null;
    }

    public static String getType(PlsqlNode plsqlNode) {
        PlsqlType plsqlType;
        if (plsqlNode instanceof PlsqlVariable && (plsqlType = ((PlsqlVariable)plsqlNode).getVariableType()) != null && plsqlType.getTypeName() != null) {
            return plsqlType.getTypeName().toString();
        }
        return null;
    }

    public static String getReturnType(PlsqlNode plsqlNode) {
        PlsqlType plsqlType;
        if (plsqlNode instanceof PlsqlSubprg && (plsqlType = ((PlsqlSubprg)plsqlNode).getReturnType()) != null && plsqlType.getTypeName() != null) {
            return plsqlType.getTypeName().toString();
        }
        return null;
    }

    protected void _loadAttributes() {
        ArrayList<PlSqlAttribute> arrayList = new ArrayList<PlSqlAttribute>();
        PlsqlNode[] plsqlNodeArray = this.getKids(this.getAttributesType());
        int n = 0;
        while (plsqlNodeArray != null && n < plsqlNodeArray.length) {
            String string = this.getName(plsqlNodeArray[n]);
            String string2 = PlSqlDeclarator.getType(plsqlNodeArray[n]);
            DataType dataType = this.m_prv.getDataType(string2);
            arrayList.add(new PlSqlAttribute(string, dataType));
            ++n;
        }
        PlSqlAttribute[] plSqlAttributeArray = arrayList.toArray(new PlSqlAttribute[arrayList.size()]);
        ((SpecPlSql)this.m_src).setAttributes(plSqlAttributeArray);
    }

    protected void _loadMethods() {
        ArrayList<PlSqlMethod> arrayList = new ArrayList<PlSqlMethod>();
        PlsqlNode[] plsqlNodeArray = this.getKids(this.getMethodsType());
        int n = 0;
        while (plsqlNodeArray != null && n < plsqlNodeArray.length) {
            DataType dataType;
            PlSqlMethod plSqlMethod = new PlSqlMethod(this.getName(plsqlNodeArray[n]));
            arrayList.add(plSqlMethod);
            String string = PlSqlDeclarator.getReturnType(plsqlNodeArray[n]);
            if (ModelUtil.hasLength((String)string) && (dataType = this.m_prv.getDataType(string)) != null) {
                plSqlMethod.setReturnType(dataType);
            }
            ArrayList<PlSqlParameter> arrayList2 = new ArrayList<PlSqlParameter>();
            if (plsqlNodeArray[n] instanceof PlsqlSubprg) {
                PlsqlVariable[] plsqlVariableArray = ((PlsqlSubprg)plsqlNodeArray[n]).getFormalParameters();
                int n2 = 0;
                while (plsqlVariableArray != null && n2 < plsqlVariableArray.length) {
                    String string2 = this.getName((PlsqlNode)plsqlVariableArray[n2]);
                    String string3 = PlSqlDeclarator.getType((PlsqlNode)plsqlVariableArray[n2]);
                    DataType dataType2 = this.m_prv.getDataType(string3);
                    arrayList2.add(new PlSqlParameter(string2, dataType2));
                    ++n2;
                }
                plSqlMethod.setParameters(arrayList2.toArray(new PlSqlParameter[arrayList2.size()]));
            }
            ++n;
        }
        PlSqlMethod[] plSqlMethodArray = arrayList.toArray(new PlSqlMethod[arrayList.size()]);
        ((SpecPlSql)this.m_src).setMethods(plSqlMethodArray);
    }

    protected int getMethodsType() {
        return 20;
    }

    protected int getAttributesType() {
        return 21;
    }
}

