/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAliasFragment
extends AbstractSQLFragment
implements AliasFragment {
    private String m_alias;
    private SQLFragment m_exp;

    protected AbstractAliasFragment() {
    }

    protected AbstractAliasFragment(SQLFragment sQLFragment, String string) {
        this.setExpression(sQLFragment);
        this.setAlias(string);
    }

    @Override
    public String getAlias() {
        return this.m_alias;
    }

    @Override
    public void setAlias(String string) {
        if (this.canHaveAlias()) {
            this.m_alias = string;
        } else if (ModelUtil.hasLength((String)string)) {
            DBUtil.logStackTrace(new SQLQueryException(DBArb.format(40, this.m_exp.getSQLText())));
        }
    }

    public boolean canHaveAlias() {
        return true;
    }

    @Override
    public SQLFragment getExpression() {
        return this.m_exp;
    }

    @Override
    public void setExpression(SQLFragment sQLFragment) {
        this.changeParent(this.m_exp, sQLFragment);
        this.m_exp = sQLFragment;
        if (!this.canHaveAlias()) {
            this.setAlias(null);
        }
    }

    @Override
    public String getSQLText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTextOrNull(this.m_exp));
        if (this.m_alias != null) {
            if (this.useAsBeforeAlias()) {
                stringBuffer.append(" AS");
            }
            stringBuffer.append(" ").append(this.m_alias);
        }
        return stringBuffer.toString();
    }

    protected boolean useAsBeforeAlias() {
        return false;
    }

    @Override
    public String getUsableAlias() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (ModelUtil.hasLength((String)this.m_alias)) {
            return this.m_alias;
        }
        return this.m_exp == null ? null : this.m_exp.getSQLText();
    }

    @Override
    public void setName(String string) {
    }

    protected boolean canUseAsAlias(String string) {
        return string.indexOf(" ") <= -1 && string.indexOf(".") <= -1;
    }

    protected void copyToImpl(AbstractAliasFragment abstractAliasFragment, boolean bl) {
        super.copyToImpl(abstractAliasFragment, bl);
        abstractAliasFragment.m_alias = this.m_alias;
        abstractAliasFragment.setExpression(this.m_exp == null ? null : (SQLFragment)this.m_exp.copyTo(null, bl));
    }

    protected boolean equalsImpl(AbstractAliasFragment abstractAliasFragment) {
        return super.equalsImpl(abstractAliasFragment) && ModelUtil.areEqual((Object)abstractAliasFragment.m_alias, (Object)this.m_alias) && ModelUtil.areEqual((Object)abstractAliasFragment.m_exp, (Object)this.m_exp);
    }

    @Override
    public String toString() {
        if (ModelUtil.hasLength((String)this.m_alias)) {
            return this.m_alias + " (" + (this.m_exp == null ? null : this.m_exp.toString()) + ")";
        }
        if (this.m_exp != null) {
            return this.m_exp.toString();
        }
        return null;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this.m_exp != null && (this.includesType("SQLFragment", stringArray) || this.includesType(this.m_exp.getType(), stringArray))) {
            collection.add(this.m_exp);
        }
    }
}

