/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.Copyable;

public abstract class AbstractSQLFragment
extends AbstractDBObject
implements SQLFragment {
    protected static final SQLFragment[] EMPTY_ARRAY = new SQLFragment[0];
    protected static final String SPACE = " ";
    protected static final String EMPTY = "";
    protected static final String NEWLINE = "\n";
    private transient DBObject m_parent;

    protected AbstractSQLFragment() {
    }

    public String getType() {
        return "SQLFragment";
    }

    public DBObject getParent() {
        return this.m_parent;
    }

    public void setParent(DBObject dBObject) {
        this.m_parent = dBObject;
    }

    protected void changeParent(SQLFragment sQLFragment, SQLFragment sQLFragment2) {
        if (sQLFragment != null) {
            this.removeParent(sQLFragment);
        }
        if (sQLFragment2 != null) {
            sQLFragment2.setParent(this);
        }
    }

    protected void removeParent(SQLFragment sQLFragment) {
        if (sQLFragment.getParent() == this) {
            sQLFragment.setParent(null);
        }
    }

    protected final void copyList(List list, List list2, DBObject dBObject, boolean bl) {
        for (Object e : list) {
            if (e instanceof SQLFragment) {
                SQLFragment sQLFragment = (SQLFragment)((SQLFragment)e).copyTo(null, bl);
                if (dBObject != null) {
                    sQLFragment.setParent(dBObject);
                }
                list2.add(sQLFragment);
                continue;
            }
            if (e instanceof Copyable) {
                list2.add(((Copyable)e).copyTo(null));
                continue;
            }
            list2.add(e);
        }
    }

    protected String getTextOrNull(SQLFragment sQLFragment) {
        if (sQLFragment == null) {
            return null;
        }
        if (sQLFragment instanceof SQLQuery) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(").append(sQLFragment.getSQLText().trim()).append(")");
            return stringBuffer.toString();
        }
        return sQLFragment.getSQLText();
    }

    protected void appendToBuffer(StringBuffer stringBuffer, List list, String string) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SQLFragment sQLFragment = (SQLFragment)iterator.next();
                String string2 = sQLFragment.getSQLText();
                if (string != null) {
                    stringBuffer.append(string);
                    string2 = string2.replaceAll(NEWLINE, NEWLINE + string);
                }
                stringBuffer.append(string2);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", \n");
            }
        }
    }

    protected void setParents(List list, DBObject dBObject) {
        if (list != null) {
            for (Object e : list) {
                if (!(e instanceof SQLFragment)) continue;
                ((SQLFragment)e).setParent(dBObject);
            }
        }
    }

    public String toString() {
        return this.getSQLText();
    }

    public int hashCode() {
        return 42;
    }

    public SQLFragment[] getChildren() {
        return null;
    }
}

