/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSQLQuery
extends AbstractSQLFragment
implements SQLQuery {
    static final String INDENT = "    ";
    protected List<SelectObject> m_selectObjs;
    protected List<FromObject> m_fromObjs;
    protected List<OrderByObject> m_orderByObjs;
    protected WhereObject m_where;
    protected GroupByObject m_groupby;

    protected AbstractSQLQuery() {
    }

    @Override
    public String getType() {
        return "SQLQuery";
    }

    @Override
    public String getSQLText() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendSelectSQL(stringBuffer);
        this.appendFromSQL(stringBuffer);
        if (this.m_where != null) {
            stringBuffer.append("WHERE").append(" ").append("\n");
            stringBuffer.append(INDENT).append(this.m_where.getSQLText());
            stringBuffer.append(" ").append("\n");
        }
        if (this.m_groupby != null) {
            stringBuffer.append(this.m_groupby.getSQLText());
            stringBuffer.append(" ").append("\n");
        }
        if (this.m_orderByObjs != null && this.m_orderByObjs.size() > 0) {
            stringBuffer.append("ORDER BY").append(" ").append("\n");
            this.appendToBuffer(stringBuffer, this.m_orderByObjs, INDENT);
            stringBuffer.append(" ").append("\n");
        }
        return stringBuffer.toString();
    }

    protected void appendSelectSQL(StringBuffer stringBuffer) {
        stringBuffer.append("SELECT").append(" ").append("\n");
        this.appendToBuffer(stringBuffer, this.m_selectObjs, INDENT);
        stringBuffer.append(" ").append("\n");
    }

    protected void appendFromSQL(StringBuffer stringBuffer) {
        stringBuffer.append("FROM").append(" ").append("\n");
        this.appendToBuffer(stringBuffer, this.m_fromObjs, INDENT);
        stringBuffer.append(" ").append("\n");
    }

    @Override
    public SelectObject[] getSelectObjects() {
        return this.m_selectObjs == null ? new SelectObject[]{} : this.m_selectObjs.toArray(new SelectObject[this.m_selectObjs.size()]);
    }

    public void setSelectObjects(SelectObject[] selectObjectArray) {
        if (this.m_selectObjs != null) {
            this.setParents(this.m_selectObjs, null);
            this.m_selectObjs.clear();
        }
        if (selectObjectArray != null) {
            if (this.m_selectObjs == null) {
                this.m_selectObjs = new ArrayList<SelectObject>();
            }
            int n = 0;
            while (n < selectObjectArray.length) {
                selectObjectArray[n].setParent(this);
                this.m_selectObjs.add(selectObjectArray[n]);
                ++n;
            }
        }
    }

    public void addSelectObject(SelectObject selectObject) {
        if (this.m_selectObjs == null) {
            this.m_selectObjs = new ArrayList<SelectObject>();
        }
        this.m_selectObjs.add(selectObject);
        selectObject.setParent(this);
    }

    public void addSelectObject(int n, SelectObject selectObject) {
        if (this.m_selectObjs == null) {
            this.m_selectObjs = new ArrayList<SelectObject>();
        }
        this.m_selectObjs.add(n, selectObject);
        selectObject.setParent(this);
    }

    public boolean removeSelectObject(SelectObject selectObject) {
        if (this.m_selectObjs != null && this.m_selectObjs.remove(selectObject)) {
            this.removeParent(selectObject);
            return true;
        }
        return false;
    }

    public void moveSelectObject(SelectObject selectObject, int n) {
        int n2;
        if (selectObject != null && this.m_selectObjs.contains(selectObject) && (n2 = this.m_selectObjs.indexOf(selectObject)) != n) {
            this.m_selectObjs.remove(selectObject);
            this.m_selectObjs.add(n, selectObject);
        }
    }

    public int indexOf(SelectObject selectObject) {
        return this.m_selectObjs.indexOf(selectObject);
    }

    @Override
    public FromObject[] getFromObjects() {
        return this.m_fromObjs == null ? new FromObject[]{} : this.m_fromObjs.toArray(new FromObject[this.m_fromObjs.size()]);
    }

    public void setFromObjects(FromObject[] fromObjectArray) {
        if (this.m_fromObjs != null) {
            this.setParents(this.m_fromObjs, null);
            this.m_fromObjs.clear();
        }
        if (fromObjectArray != null) {
            if (this.m_fromObjs == null) {
                this.m_fromObjs = new ArrayList<FromObject>();
            }
            int n = 0;
            while (n < fromObjectArray.length) {
                fromObjectArray[n].setParent(this);
                this.m_fromObjs.add(fromObjectArray[n]);
                ++n;
            }
        }
    }

    public void addFromObject(FromObject fromObject) {
        if (this.m_fromObjs == null) {
            this.m_fromObjs = new ArrayList<FromObject>();
        }
        this.m_fromObjs.add(fromObject);
        fromObject.setParent(this);
    }

    public void addFromObject(int n, FromObject fromObject) {
        if (this.m_fromObjs == null) {
            this.m_fromObjs = new ArrayList<FromObject>();
        }
        this.m_fromObjs.add(n, fromObject);
        fromObject.setParent(this);
    }

    public boolean removeFromObject(FromObject fromObject) {
        if (this.m_fromObjs != null && this.m_fromObjs.remove(fromObject)) {
            this.removeParent(fromObject);
            return true;
        }
        return false;
    }

    public void moveFromObject(FromObject fromObject, int n) {
        int n2;
        if (fromObject != null && this.m_fromObjs.contains(fromObject) && (n2 = this.m_fromObjs.indexOf(fromObject)) != n) {
            this.m_fromObjs.remove(fromObject);
            this.m_fromObjs.add(n, fromObject);
        }
    }

    public int indexOf(FromObject fromObject) {
        return this.m_fromObjs.indexOf(fromObject);
    }

    @Override
    public OrderByObject[] getOrderByObjects() {
        return this.m_orderByObjs == null ? new OrderByObject[]{} : this.m_orderByObjs.toArray(new OrderByObject[this.m_orderByObjs.size()]);
    }

    public void setOrderByObjects(OrderByObject[] orderByObjectArray) {
        if (this.m_orderByObjs != null) {
            this.setParents(this.m_orderByObjs, null);
            this.m_orderByObjs.clear();
        }
        if (orderByObjectArray != null) {
            if (this.m_orderByObjs == null) {
                this.m_orderByObjs = new ArrayList<OrderByObject>();
            }
            int n = 0;
            while (n < orderByObjectArray.length) {
                orderByObjectArray[n].setParent(this);
                this.m_orderByObjs.add(orderByObjectArray[n]);
                ++n;
            }
        }
    }

    public void addOrderByObject(OrderByObject orderByObject) {
        if (this.m_orderByObjs == null) {
            this.m_orderByObjs = new ArrayList<OrderByObject>();
        }
        this.m_orderByObjs.add(orderByObject);
        orderByObject.setParent(this);
    }

    public void addOrderByObject(int n, OrderByObject orderByObject) {
        if (this.m_orderByObjs == null) {
            this.m_orderByObjs = new ArrayList<OrderByObject>();
        }
        this.m_orderByObjs.add(n, orderByObject);
        orderByObject.setParent(this);
    }

    public boolean removeOrderByObject(OrderByObject orderByObject) {
        if (this.m_orderByObjs != null && this.m_orderByObjs.remove(orderByObject)) {
            this.removeParent(orderByObject);
            return true;
        }
        return false;
    }

    public void moveOrderByObject(OrderByObject orderByObject, int n) {
        int n2;
        if (orderByObject != null && this.m_orderByObjs.contains(orderByObject) && (n2 = this.m_orderByObjs.indexOf(orderByObject)) != n) {
            this.m_orderByObjs.remove(orderByObject);
            this.m_orderByObjs.add(n, orderByObject);
        }
    }

    public int indexOf(OrderByObject orderByObject) {
        return this.m_orderByObjs.indexOf(orderByObject);
    }

    public void setWhereObject(WhereObject whereObject) {
        if (this.m_where != null) {
            this.removeParent(this.m_where);
        }
        this.m_where = whereObject;
        if (this.m_where != null) {
            this.m_where.setParent(this);
        }
    }

    @Override
    public WhereObject getWhereObject() {
        return this.m_where;
    }

    public void setGroupByObject(GroupByObject groupByObject) {
        if (this.m_groupby != null) {
            this.removeParent(this.m_groupby);
        }
        this.m_groupby = groupByObject;
        if (this.m_groupby != null) {
            this.m_groupby.setParent(this);
        }
    }

    @Override
    public GroupByObject getGroupByObject() {
        return this.m_groupby;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        boolean bl = this.includesType("SQLFragment", stringArray);
        if ((bl || this.includesType("SELECT", stringArray)) && this.m_selectObjs != null) {
            collection.addAll(this.m_selectObjs);
        }
        if ((bl || this.includesType("FROM", stringArray)) && this.m_fromObjs != null) {
            collection.addAll(this.m_fromObjs);
        }
        if ((bl || this.includesType("WHERE", stringArray)) && this.m_where != null) {
            collection.add(this.m_where);
        }
        if ((bl || this.includesType("ORDER BY", stringArray)) && this.m_orderByObjs != null) {
            collection.addAll(this.m_orderByObjs);
        }
        if ((bl || this.includesType("GROUP BY", stringArray)) && this.m_groupby != null) {
            collection.add(this.m_groupby);
        }
    }

    protected void copyToImpl(AbstractSQLQuery abstractSQLQuery, boolean bl) {
        super.copyToImpl(abstractSQLQuery, bl);
        HashMap hashMap = new HashMap();
        if (this.m_fromObjs != null) {
            abstractSQLQuery.m_fromObjs = new ArrayList<FromObject>();
            for (FromObject fromObject : this.m_fromObjs) {
                FromObject fromObject2 = (FromObject)fromObject.copyTo(null, abstractSQLQuery, bl);
                abstractSQLQuery.addFromObject(fromObject2);
                this.addToFromMap(fromObject, fromObject2, hashMap);
            }
        }
        if (this.m_selectObjs != null) {
            abstractSQLQuery.m_selectObjs = new ArrayList<SelectObject>();
            for (SelectObject selectObject : this.m_selectObjs) {
                SelectObject selectObject2 = (SelectObject)selectObject.copyTo(null, abstractSQLQuery, bl);
                abstractSQLQuery.addSelectObject(selectObject2);
            }
        }
        abstractSQLQuery.setWhereObject(this.m_where == null ? null : (WhereObject)this.m_where.copyTo(null, abstractSQLQuery, bl));
        if (this.m_orderByObjs != null) {
            abstractSQLQuery.m_orderByObjs = new ArrayList<OrderByObject>();
            for (OrderByObject orderByObject : this.m_orderByObjs) {
                OrderByObject orderByObject2 = (OrderByObject)orderByObject.copyTo(null, abstractSQLQuery, bl);
                abstractSQLQuery.addOrderByObject(orderByObject2);
            }
        }
        abstractSQLQuery.setGroupByObject(this.m_groupby == null ? null : (GroupByObject)this.m_groupby.copyTo(null, abstractSQLQuery, bl));
        this.checkUsageChildren(this, abstractSQLQuery, abstractSQLQuery, hashMap);
    }

    private void addToFromMap(FromObject fromObject, FromObject fromObject2, Map map) {
        if (fromObject != null) {
            map.put(fromObject, fromObject2);
            SQLFragment sQLFragment = fromObject.getExpression();
            if (sQLFragment instanceof JoinObject) {
                SQLFragment sQLFragment2 = fromObject2.getExpression();
                this.addToFromMap(((JoinObject)sQLFragment).getLeftExpression(), ((JoinObject)sQLFragment2).getLeftExpression(), map);
                this.addToFromMap(((JoinObject)sQLFragment).getRightExpression(), ((JoinObject)sQLFragment2).getRightExpression(), map);
            }
        }
    }

    private void checkUsageChildren(SQLFragment sQLFragment, SQLFragment sQLFragment2, AbstractSQLQuery abstractSQLQuery, Map map) {
        if (sQLFragment instanceof FromObjectUsage) {
            FromObject fromObject = ((FromObjectUsage)sQLFragment).getFromObject();
            ((FromObjectUsage)sQLFragment2).setFromObject((FromObject)map.get(fromObject));
        }
        if (sQLFragment instanceof FKUsage) {
            FromObject fromObject = ((FKUsage)sQLFragment).getLeftFromObject();
            ((FKUsage)sQLFragment2).setLeftFromObject((FromObject)map.get(fromObject));
            FromObject fromObject2 = ((FKUsage)sQLFragment).getRightFromObject();
            ((FKUsage)sQLFragment2).setRightFromObject((FromObject)map.get(fromObject2));
        }
        if (sQLFragment != null) {
            DBObject[] dBObjectArray = sQLFragment.getOwnedObjects();
            DBObject[] dBObjectArray2 = sQLFragment2.getOwnedObjects();
            int n = 0;
            while (dBObjectArray != null && n < dBObjectArray.length) {
                this.checkUsageChildren((SQLFragment)dBObjectArray[n], (SQLFragment)dBObjectArray2[n], abstractSQLQuery, map);
                ++n;
            }
        }
    }

    protected boolean equalsImpl(AbstractSQLQuery abstractSQLQuery) {
        return super.equalsImpl(abstractSQLQuery) && ModelUtil.areEqual(abstractSQLQuery.m_selectObjs, this.m_selectObjs) && ModelUtil.areEqual(abstractSQLQuery.m_fromObjs, this.m_fromObjs) && ModelUtil.areEqual((Object)abstractSQLQuery.m_where, (Object)this.m_where) && ModelUtil.areEqual(abstractSQLQuery.m_orderByObjs, this.m_orderByObjs) && ModelUtil.areEqual((Object)abstractSQLQuery.m_groupby, (Object)this.m_groupby);
    }
}

