/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.View;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.AliasInUseException;
import oracle.javatools.db.sql.AmbiguousColumnException;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.IDException;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractSQLQueryBuilder
implements SQLQueryBuilder {
    protected static final SQLFragment[] EMPTY_ARRAY = AbstractSQLFragment.EMPTY_ARRAY;
    protected DeclarativeSQLQuery m_query;
    protected DBObjectProvider m_provider;
    protected Schema m_defaultSchema;
    private Map m_fromDeps;
    private Map m_rFromDeps;
    private Collection m_usings;

    void $init$() {
        this.m_fromDeps = new HashMap();
        this.m_rFromDeps = new HashMap();
        this.m_usings = new HashSet();
    }

    protected AbstractSQLQueryBuilder(DBObjectProvider dBObjectProvider, Schema schema) {
        this.$init$();
        this.m_provider = dBObjectProvider;
        this.m_defaultSchema = schema;
    }

    protected AbstractSQLQueryBuilder(DeclarativeSQLQuery declarativeSQLQuery, DBObjectProvider dBObjectProvider) throws SQLQueryException {
        this(declarativeSQLQuery, dBObjectProvider, null);
    }

    protected AbstractSQLQueryBuilder(DeclarativeSQLQuery declarativeSQLQuery, DBObjectProvider dBObjectProvider, Schema schema) throws SQLQueryException {
        this.$init$();
        this.m_query = declarativeSQLQuery;
        this.m_provider = dBObjectProvider;
        this.m_defaultSchema = schema;
        this.validateQuery();
        this.loadQuery();
    }

    public void validateQuery() throws SQLQueryException {
        AliasFragment[] aliasFragmentArray = this.listAllFromObjects();
        this.checkAliases(aliasFragmentArray);
        AliasFragment[] aliasFragmentArray2 = this.m_query.getSelectObjects();
        this.checkAliases(aliasFragmentArray2);
    }

    private void checkAliases(AliasFragment[] aliasFragmentArray) throws SQLQueryException {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (aliasFragmentArray != null && n < aliasFragmentArray.length) {
            String string = aliasFragmentArray[n].getAlias();
            if (ModelUtil.hasLength((String)string)) {
                if (this.containsAliasIC(string, hashSet)) {
                    throw new AliasInUseException(string);
                }
                if (!this.m_provider.isValidName("COLUMN", string)) {
                    throw new SQLQueryException(DBArb.format(23, string));
                }
                hashSet.add(string);
            }
            ++n;
        }
    }

    protected void loadQuery() throws SQLQueryException {
        this.loadObject(this.m_query);
    }

    private boolean containsAliasIC(String string, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!string.equalsIgnoreCase((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    private void addDependency(FromObject fromObject, DBObject dBObject) {
        if (this.m_fromDeps.containsKey(fromObject)) {
            Set set = (Set)this.m_fromDeps.get(fromObject);
            set.add(dBObject);
        } else {
            HashSet<DBObject> hashSet = new HashSet<DBObject>();
            hashSet.add(dBObject);
            this.m_fromDeps.put(fromObject, hashSet);
        }
        this.m_rFromDeps.put(dBObject, fromObject);
    }

    private void removeDependency(DBObject dBObject) {
        Set set;
        FromObject fromObject = (FromObject)this.m_rFromDeps.get(dBObject);
        if (fromObject != null && (set = (Set)this.m_fromDeps.get(fromObject)) != null) {
            set.remove(dBObject);
        }
    }

    protected void loadObjects(DBObject[] dBObjectArray) {
        int n = 0;
        while (n < dBObjectArray.length) {
            this.loadObject(dBObjectArray[n]);
            ++n;
        }
    }

    protected void loadObject(DBObject dBObject) {
        if (dBObject != null) {
            if (dBObject instanceof DBObjectUsage) {
                ((DBObjectUsage)dBObject).setProvider(this.m_provider);
            }
            if (dBObject instanceof UsingJoinCondition) {
                this.m_usings.add(dBObject);
            }
            if (dBObject instanceof FromObjectUsage) {
                FromObject fromObject = ((FromObjectUsage)dBObject).getFromObject();
                if (fromObject != null) {
                    this.addDependency(fromObject, dBObject);
                }
            } else if (dBObject instanceof FKUsage) {
                FromObject fromObject;
                FromObject fromObject2 = ((FKUsage)dBObject).getLeftFromObject();
                if (fromObject2 != null) {
                    this.addDependency(fromObject2, dBObject);
                }
                if ((fromObject = ((FKUsage)dBObject).getRightFromObject()) != null) {
                    this.addDependency(fromObject, dBObject);
                }
            }
            DBObject[] dBObjectArray = dBObject.getOwnedObjects();
            int n = 0;
            while (dBObjectArray != null && n < dBObjectArray.length) {
                this.loadObject(dBObjectArray[n]);
                ++n;
            }
        }
    }

    protected void unloadObject(DBObject dBObject) {
        if (dBObject != null) {
            DBObject[] dBObjectArray = dBObject.getOwnedObjects();
            int n = 0;
            while (dBObjectArray != null && n < dBObjectArray.length) {
                if (dBObjectArray[n] instanceof SQLFragment) {
                    this.unloadObject(dBObjectArray[n]);
                }
                ++n;
            }
            if (dBObject instanceof UsingJoinCondition) {
                this.m_usings.remove(dBObject);
            }
            this.removeDependency(dBObject);
        }
    }

    protected List getIDs(DBObject[] dBObjectArray) throws SQLQueryException {
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>(dBObjectArray.length);
        int n = 0;
        while (n < dBObjectArray.length) {
            DBObjectID dBObjectID = dBObjectArray[n].getID();
            if (dBObjectID == null) {
                throw new IDException(dBObjectArray[n]);
            }
            arrayList.add(dBObjectID);
            ++n;
        }
        return arrayList;
    }

    protected Map getRelIDs(FromObject[] fromObjectArray) {
        HashMap hashMap = new HashMap();
        int n = 0;
        while (fromObjectArray != null && n < fromObjectArray.length) {
            this.addRelIDs(hashMap, fromObjectArray[n]);
            ++n;
        }
        return hashMap;
    }

    private void addRelIDs(Map map, FromObject fromObject) {
        SQLFragment sQLFragment;
        SQLFragment sQLFragment2 = sQLFragment = fromObject == null ? null : fromObject.getExpression();
        if (sQLFragment != null && sQLFragment instanceof RelationUsage) {
            DBObjectID dBObjectID = ((RelationUsage)sQLFragment).getObjectID();
            if (dBObjectID != null) {
                map.put(dBObjectID, fromObject);
            }
        } else if (sQLFragment != null && sQLFragment instanceof JoinObject) {
            FromObject fromObject2 = ((JoinObject)sQLFragment).getLeftExpression();
            FromObject fromObject3 = ((JoinObject)sQLFragment).getRightExpression();
            this.addRelIDs(map, fromObject2);
            this.addRelIDs(map, fromObject3);
        }
    }

    protected void setNewFromObject(DBObject dBObject, FromObject fromObject, FromObject fromObject2) {
        if (dBObject instanceof FromObjectUsage) {
            if (fromObject.equals(((FromObjectUsage)dBObject).getFromObject())) {
                ((FromObjectUsage)dBObject).setFromObject(fromObject2);
            }
        } else if (dBObject instanceof FKUsage) {
            if (fromObject.equals(((FKUsage)dBObject).getLeftFromObject())) {
                ((FKUsage)dBObject).setLeftFromObject(fromObject2);
            }
            if (fromObject.equals(((FKUsage)dBObject).getRightFromObject())) {
                ((FKUsage)dBObject).setRightFromObject(fromObject2);
            }
        }
        DBObject[] dBObjectArray = dBObject.getOwnedObjects();
        int n = 0;
        while (dBObjectArray != null && n < dBObjectArray.length) {
            this.setNewFromObject((SQLFragment)dBObjectArray[n], fromObject, fromObject2);
            ++n;
        }
    }

    private List getAliases(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (Object e : list) {
                if (e instanceof AliasFragment) {
                    arrayList.add(((AliasFragment)e).getName());
                    continue;
                }
                if (!(e instanceof String)) continue;
                arrayList.add((String)e);
            }
        }
        return arrayList;
    }

    private List getAliases(SQLFragment[] sQLFragmentArray) {
        return sQLFragmentArray == null ? new ArrayList() : this.getAliases(Arrays.asList(sQLFragmentArray));
    }

    public DeclarativeSQLQuery getSQLQuery() {
        return this.m_query;
    }

    public void addSelectObject(SelectObject selectObject) throws SQLQueryException {
        String string = selectObject.getName();
        if (!this.isUniqueSelectAlias(string)) {
            throw new AliasInUseException(string);
        }
        string = selectObject.getAlias();
        if (ModelUtil.hasLength((String)string) && !this.m_provider.isValidName("COLUMN", string)) {
            throw new SQLQueryException(DBArb.format(23, string));
        }
        this.loadObject(selectObject);
        this.checkSelectObject(selectObject);
        this.m_query.addSelectObject(selectObject);
    }

    public void addSelectObject(int n, SelectObject selectObject) throws SQLQueryException {
        String string = selectObject.getName();
        if (!this.isUniqueSelectAlias(string)) {
            throw new AliasInUseException(string);
        }
        string = selectObject.getAlias();
        if (ModelUtil.hasLength((String)string) && !this.m_provider.isValidName("COLUMN", string)) {
            throw new SQLQueryException(DBArb.format(23, string));
        }
        this.loadObject(selectObject);
        this.checkSelectObject(selectObject);
        this.m_query.addSelectObject(n, selectObject);
    }

    public boolean isUniqueSelectAlias(String string) {
        return this.isUniqueSelectAlias(string, null);
    }

    protected boolean isUniqueSelectAlias(String string, List list) {
        List list2 = this.getAliases(this.m_query.getSelectObjects());
        if (list != null) {
            list2.addAll(list);
        }
        return this.containsAliasIC(string, list2) ^ true;
    }

    public String createUniqueSelectAlias(String string) {
        return this.createUniqueSelectAlias(string, null);
    }

    protected String createUniqueSelectAlias(String string, List list) {
        List list2 = this.getAliases(this.m_query.getSelectObjects());
        if (list != null) {
            list2.addAll(list);
        }
        return DBUtil.getUniqueName(list2, string, false);
    }

    public SelectObject getSelectObject(String string) {
        SelectObject[] selectObjectArray = this.m_query.getSelectObjects();
        int n = 0;
        while (selectObjectArray != null && n < selectObjectArray.length) {
            if (selectObjectArray[n].getName().equals(string)) {
                return selectObjectArray[n];
            }
            ++n;
        }
        return null;
    }

    public SelectObject constructSelectObject(String string, String string2) throws SQLQueryException {
        SQLFragment sQLFragment = this.parseSelectExpression(string);
        return new SelectObject(sQLFragment, string2);
    }

    public SQLQueryBuilder.SQLQueryObjectSet constructSelectObject(Column column, FromObject fromObject) throws SQLQueryException {
        ArrayList arrayList = new ArrayList();
        Map map = this.getRelIDs(new FromObject[]{fromObject});
        HashMap hashMap = new HashMap();
        SelectObject selectObject = this.doConstructSelectObject(column, map, hashMap, arrayList, null);
        FromObject[] fromObjectArray = hashMap.values().toArray(new FromObject[hashMap.size()]);
        this.addFromObjects(fromObjectArray);
        this.checkSelectObject(selectObject);
        this.m_query.addSelectObject(selectObject);
        return new SQLQueryObjectSetImpl(new SelectObject[]{selectObject}, fromObjectArray, selectObject);
    }

    public SQLQueryBuilder.SQLQueryObjectSet constructSelectObjects(Column[] columnArray, FromObject[] fromObjectArray) throws SQLQueryException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Map map = this.getRelIDs(fromObjectArray);
        HashMap hashMap = new HashMap();
        SelectObject[] selectObjectArray = new SelectObject[columnArray.length];
        int n = 0;
        while (n < columnArray.length) {
            selectObjectArray[n] = this.doConstructSelectObject(columnArray[n], map, hashMap, arrayList, arrayList2);
            ++n;
        }
        FromObject[] fromObjectArray2 = hashMap.values().toArray(new FromObject[hashMap.size()]);
        this.addFromObjects(fromObjectArray2);
        this.addSelectObjects(selectObjectArray);
        return new SQLQueryObjectSetImpl(selectObjectArray, fromObjectArray2, null);
    }

    protected SelectObject doConstructSelectObject(Column column, Map map, Map map2, List list, List list2) throws SQLQueryException {
        DBObjectID dBObjectID = column.getID();
        if (dBObjectID == null) {
            throw new IDException(column);
        }
        Relation relation = column.getRelation();
        if (relation == null) {
            throw new SQLQueryException(DBArb.format(6, column.getName()));
        }
        DBObjectID dBObjectID2 = relation.getID();
        if (dBObjectID2 == null) {
            throw new IDException(relation);
        }
        FromObject fromObject = (FromObject)map.get(dBObjectID2);
        if (fromObject == null) {
            fromObject = (FromObject)map2.get(dBObjectID2);
        }
        if (fromObject == null) {
            fromObject = this.createFromObject(relation, list);
            map2.put(dBObjectID2, fromObject);
            list.add(relation.getName());
        }
        String string = column.getName();
        string = this.createUniqueSelectAlias(string, list2);
        if (list2 != null) {
            list2.add(string);
        }
        return this.createSelectObject(dBObjectID, fromObject, string);
    }

    protected SelectObject createSelectObject(DBObjectID dBObjectID, FromObject fromObject, String string) {
        ColumnUsage columnUsage = new ColumnUsage(dBObjectID, fromObject);
        columnUsage.setProvider(this.m_provider);
        SelectObject selectObject = new SelectObject(columnUsage, string);
        this.addDependency(fromObject, selectObject);
        return selectObject;
    }

    protected void addSelectObjects(SelectObject[] selectObjectArray) {
        SelectObject[] selectObjectArray2 = this.m_query.getSelectObjects();
        int n = (selectObjectArray2 == null ? 0 : selectObjectArray2.length) + selectObjectArray.length;
        SelectObject[] selectObjectArray3 = new SelectObject[n];
        System.arraycopy(selectObjectArray2, 0, selectObjectArray3, 0, selectObjectArray2.length);
        System.arraycopy(selectObjectArray, 0, selectObjectArray3, selectObjectArray2.length, selectObjectArray.length);
        this.m_query.setSelectObjects(selectObjectArray3);
    }

    public boolean removeSelectObject(SelectObject selectObject) {
        SQLFragment[] sQLFragmentArray = this.getDependentObjects(selectObject);
        int n = 0;
        while (n < sQLFragmentArray.length) {
            if (sQLFragmentArray[n] instanceof WhereObject) {
                this.removeWhereObject((WhereObject)sQLFragmentArray[n]);
            } else if (sQLFragmentArray[n] instanceof GroupByObject) {
                this.m_query.setGroupByObject(null);
                this.unloadObject(sQLFragmentArray[n]);
            }
            ++n;
        }
        if (this.m_query.removeSelectObject(selectObject)) {
            this.removeDependency(selectObject);
            return true;
        }
        return false;
    }

    public void replaceSelectObject(SelectObject selectObject, SelectObject selectObject2) throws SQLQueryException {
        String string = selectObject.getAlias();
        String string2 = selectObject2.getAlias();
        if (ModelUtil.hasLength((String)string2)) {
            if (!string2.equals(string) && !this.isUniqueSelectAlias(string2)) {
                throw new AliasInUseException(string2);
            }
            if (!this.m_provider.isValidName("COLUMN", string2)) {
                throw new SQLQueryException(DBArb.format(23, string2));
            }
        }
        selectObject.setAlias(string2);
        SQLFragment sQLFragment = selectObject.getExpression();
        SQLFragment sQLFragment2 = selectObject2.getExpression();
        if (ModelUtil.areDifferent((Object)sQLFragment, (Object)sQLFragment2)) {
            this.removeDependency(selectObject);
            selectObject.setExpression(sQLFragment2);
            this.loadObject(sQLFragment2);
            this.checkSelectObject(selectObject);
        }
    }

    public boolean isUniqueFromAlias(String string) {
        return this.isUniqueFromAlias(string, null);
    }

    protected boolean isUniqueFromAlias(String string, List list) {
        List list2 = this.getAliases(this.listAllFromObjects());
        if (list != null) {
            list2.addAll(list);
        }
        return this.containsAliasIC(string, list2) ^ true;
    }

    public String createUniqueFromAlias(String string) {
        return this.createUniqueFromAlias(string, null);
    }

    protected String createUniqueFromAlias(String string, List list) {
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        List list2 = this.getAliases(this.listAllFromObjects());
        if (list != null) {
            list2.addAll(this.getAliases(list));
        }
        return DBUtil.getUniqueName(list2, string, false);
    }

    public FromObject[] listAllFromObjects() {
        ArrayList<FromObject> arrayList = new ArrayList<FromObject>();
        FromObject[] fromObjectArray = this.m_query.getFromObjects();
        int n = 0;
        while (n < fromObjectArray.length) {
            SQLFragment sQLFragment = fromObjectArray[n].getExpression();
            if (!(sQLFragment instanceof JoinObject)) {
                arrayList.add(fromObjectArray[n]);
            }
            if (!(sQLFragment instanceof SQLQuery)) {
                this.addChildFromObjects(fromObjectArray[n], arrayList);
            }
            ++n;
        }
        return arrayList.toArray(new FromObject[arrayList.size()]);
    }

    private void addChildFromObjects(DBObject dBObject, List list) {
        DBObject[] dBObjectArray = dBObject.getOwnedObjects();
        int n = 0;
        while (dBObjectArray != null && n < dBObjectArray.length) {
            if (dBObjectArray[n] instanceof FromObject && !(((FromObject)dBObjectArray[n]).getExpression() instanceof JoinObject)) {
                list.add(dBObjectArray[n]);
            }
            this.addChildFromObjects(dBObjectArray[n], list);
            ++n;
        }
    }

    public FromObject getFromObject(String string) {
        return this.getFromObject(string, null);
    }

    protected FromObject getFromObject(String string, FromObject fromObject) {
        FromObject[] fromObjectArray;
        ArrayList<FromObject> arrayList = new ArrayList<FromObject>();
        if (fromObject != null) {
            arrayList.add(fromObject);
            this.addChildFromObjects(fromObject, arrayList);
        }
        if ((fromObjectArray = this.listAllFromObjects()) != null) {
            arrayList.addAll(Arrays.asList(fromObjectArray));
        }
        for (FromObject fromObject2 : arrayList) {
            if (!fromObject2.getName().equalsIgnoreCase(string)) continue;
            return fromObject2;
        }
        return null;
    }

    public FromObject constructFromObject(String string, String string2) throws SQLQueryException {
        SQLFragment sQLFragment = this.parseFromExpression(string);
        return new FromObject(sQLFragment, string2);
    }

    protected FromObject createFromObject(Relation relation, List list) throws SQLQueryException {
        Schema schema;
        DBObjectID dBObjectID = relation.getID();
        if (dBObjectID == null) {
            throw new IDException(relation);
        }
        String string = relation.getName();
        boolean bl = true;
        if (this.m_defaultSchema != null && (schema = relation.getSchema()) != null && !schema.getName().equalsIgnoreCase(this.m_defaultSchema.getName())) {
            string = schema.getName() + "_" + string;
            bl = false;
        }
        string = bl && this.isUniqueFromAlias(string, this.getAliases(list)) ? null : this.createUniqueFromAlias(string, list);
        RelationUsage relationUsage = new RelationUsage(dBObjectID);
        relationUsage.setProvider(this.m_provider);
        return new FromObject(relationUsage, string);
    }

    public SQLQueryBuilder.SQLQueryObjectSet constructFromObject(Relation relation, boolean bl, boolean bl2, FromObject[] fromObjectArray) throws SQLQueryException {
        List list = this.getIDs(new Relation[]{relation});
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        ArrayList arrayList2 = bl ? new ArrayList() : null;
        ArrayList arrayList3 = bl2 ? new ArrayList() : null;
        FromObject fromObject = this.doConstructFromObject(relation, list, arrayList, hashMap, arrayList2, arrayList3);
        FromObject[] fromObjectArray2 = hashMap.values().toArray(new FromObject[hashMap.size()]);
        this.addFromObjects(fromObjectArray2);
        SelectObject[] selectObjectArray = null;
        if (bl) {
            selectObjectArray = this.constructSelectObjects(arrayList2.toArray(new Column[arrayList2.size()]), new FromObject[]{fromObject}).getSelectObjects();
        }
        Object var13_13 = null;
        FromObject[] fromObjectArray3 = new FromObject[]{fromObject};
        if (bl2 && fromObjectArray != null) {
            fromObjectArray3 = new FromObject[fromObjectArray.length + 1];
            fromObjectArray3[0] = fromObject;
            System.arraycopy(fromObjectArray, 0, fromObjectArray3, 1, fromObjectArray.length);
        }
        return new SQLQueryObjectSetImpl(selectObjectArray, fromObjectArray2, fromObject);
    }

    protected FromObject doConstructFromObject(Relation relation, List list, List list2, Map map, List list3, List list4) throws SQLQueryException {
        FromObject fromObject = this.createFromObject(relation, list2);
        map.put(relation.getID(), fromObject);
        list2.add(relation.getName());
        if (list3 != null) {
            Column[] columnArray = relation.getColumns();
            list3.addAll(Arrays.asList(columnArray));
        }
        if (list4 != null) {
            Constraint[] constraintArray = relation.getConstraints();
            int n = 0;
            while (constraintArray != null && n < constraintArray.length) {
                if (constraintArray[n] instanceof FKConstraint) {
                    DBObjectID dBObjectID = ((FKConstraint)constraintArray[n]).getReferenceID();
                    try {
                        UniqueConstraint uniqueConstraint = (UniqueConstraint)dBObjectID.resolveID();
                        Relation relation2 = uniqueConstraint.getRelation();
                        DBObjectID dBObjectID2 = relation2.getID();
                        if (dBObjectID2 == null) {
                            throw new IDException(relation2);
                        }
                        if (list.contains(dBObjectID2)) {
                            list4.add(constraintArray[n]);
                        }
                    }
                    catch (DBException dBException) {
                        throw new IDException(dBObjectID, dBException);
                    }
                }
                ++n;
            }
        }
        return fromObject;
    }

    public SQLQueryBuilder.SQLQueryObjectSet constructFromObjects(Relation[] relationArray, boolean bl, boolean bl2, FromObject[] fromObjectArray) throws SQLQueryException {
        List list = this.getIDs(relationArray);
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        FromObject[] fromObjectArray2 = new FromObject[relationArray.length];
        ArrayList arrayList2 = bl ? new ArrayList() : null;
        ArrayList arrayList3 = bl2 ? new ArrayList() : null;
        int n = 0;
        while (n < relationArray.length) {
            fromObjectArray2[n] = this.doConstructFromObject(relationArray[n], list, arrayList, hashMap, arrayList2, arrayList3);
            ++n;
        }
        FromObject[] fromObjectArray3 = hashMap.values().toArray(new FromObject[hashMap.size()]);
        this.addFromObjects(fromObjectArray3);
        SelectObject[] selectObjectArray = null;
        if (bl) {
            selectObjectArray = this.constructSelectObjects(arrayList2.toArray(new Column[arrayList2.size()]), fromObjectArray2).getSelectObjects();
        }
        Object var14_14 = null;
        if (bl2) {
            FromObject[] fromObjectArray4 = null;
            if (fromObjectArray == null) {
                fromObjectArray4 = fromObjectArray2;
            } else {
                fromObjectArray4 = new FromObject[fromObjectArray2.length + fromObjectArray.length];
                System.arraycopy(fromObjectArray2, 0, fromObjectArray4, 0, fromObjectArray2.length);
                System.arraycopy(fromObjectArray, 0, fromObjectArray4, fromObjectArray2.length, fromObjectArray.length);
            }
        }
        return new SQLQueryObjectSetImpl(selectObjectArray, fromObjectArray2);
    }

    public void addFromObject(FromObject fromObject) throws SQLQueryException {
        fromObject.setParent(this.m_query);
        String string = fromObject.getName();
        if (!this.isUniqueFromAlias(string)) {
            throw new AliasInUseException(string);
        }
        string = fromObject.getAlias();
        if (ModelUtil.hasLength((String)string) && !this.m_provider.isValidName("TABLE", string)) {
            throw new SQLQueryException(DBArb.format(23, string));
        }
        this.m_query.addFromObject(fromObject);
        this.loadObject(fromObject);
        this.checkUsageQualifications();
    }

    protected void addFromObjects(FromObject[] fromObjectArray) {
        if (fromObjectArray != null && fromObjectArray.length > 0) {
            FromObject[] fromObjectArray2 = this.m_query.getFromObjects();
            int n = (fromObjectArray2 == null ? 0 : fromObjectArray2.length) + fromObjectArray.length;
            FromObject[] fromObjectArray3 = new FromObject[n];
            System.arraycopy(fromObjectArray2, 0, fromObjectArray3, 0, fromObjectArray2.length);
            System.arraycopy(fromObjectArray, 0, fromObjectArray3, fromObjectArray2.length, fromObjectArray.length);
            this.m_query.setFromObjects(fromObjectArray3);
            this.loadObjects(fromObjectArray);
            this.checkUsageQualifications();
        }
    }

    protected void addJoinObject(FromObject fromObject) {
        FromObject fromObject2;
        JoinObject joinObject;
        FromObject fromObject3;
        List<FromObject> list = Arrays.asList(this.m_query.getFromObjects());
        if (list.contains(fromObject3 = (joinObject = (JoinObject)fromObject.getExpression()).getLeftExpression())) {
            this.m_query.removeFromObject(fromObject3);
        }
        if (list.contains(fromObject2 = joinObject.getRightExpression())) {
            this.m_query.removeFromObject(fromObject2);
        }
        this.m_query.addFromObject(fromObject);
        this.loadObject(fromObject);
        this.checkUsageQualifications();
    }

    public void replaceFromObject(FromObject fromObject, FromObject fromObject2) throws SQLQueryException {
        SQLFragment sQLFragment;
        SQLFragment sQLFragment2;
        boolean bl;
        String string = fromObject.getAlias();
        String string2 = fromObject2.getAlias();
        if (ModelUtil.hasLength((String)string2)) {
            if (!string2.equals(string) && !this.isUniqueFromAlias(string2)) {
                throw new AliasInUseException(string2);
            }
            if (!this.m_provider.isValidName("TABLE", string2)) {
                throw new SQLQueryException(DBArb.format(23, string2));
            }
        }
        if ((bl = ModelUtil.areDifferent((Object)(sQLFragment2 = fromObject.getExpression()), (Object)(sQLFragment = fromObject2.getExpression()))) && sQLFragment2 instanceof RelationUsage) {
            this.removeFromObject(fromObject);
            this.addFromObject(fromObject2);
        } else {
            if (bl) {
                this.unloadObject(sQLFragment2);
                this.loadObject(sQLFragment);
                fromObject.setExpression(sQLFragment);
            }
            fromObject.setAlias(fromObject2.getAlias());
        }
        this.checkUsageQualifications();
    }

    public boolean removeJoinObject(FromObject fromObject) {
        SQLFragment sQLFragment = fromObject.getExpression();
        if (sQLFragment instanceof JoinObject) {
            boolean bl = false;
            FromObject fromObject2 = ((JoinObject)sQLFragment).getLeftExpression();
            FromObject fromObject3 = ((JoinObject)sQLFragment).getRightExpression();
            DBObject dBObject = fromObject.getParent();
            JoinCondition joinCondition = ((JoinObject)sQLFragment).getCondition();
            if (joinCondition instanceof UsingJoinCondition) {
                this.m_usings.remove(joinCondition);
            }
            if (dBObject == this.m_query) {
                int n = this.m_query.indexOf(fromObject);
                if (n >= 0) {
                    this.m_query.addFromObject(n, fromObject3);
                    this.m_query.addFromObject(n, fromObject2);
                    this.m_query.removeFromObject(fromObject);
                    bl = true;
                }
            } else if (dBObject instanceof JoinObject) {
                FromObject fromObject4 = fromObject2;
                FromObject fromObject5 = fromObject3;
                JoinCondition joinCondition2 = ((JoinObject)dBObject).getCondition();
                if (joinCondition2 instanceof UsingJoinCondition) {
                    FromObjectUsage[] fromObjectUsageArray = ((UsingJoinCondition)joinCondition2).getColumns();
                    int n = 0;
                    while (n < fromObjectUsageArray.length) {
                        FromObject fromObject6 = fromObjectUsageArray[n].getFromObject();
                        if (fromObject6 == fromObject2) break;
                        if (fromObject6 == fromObject3) {
                            fromObject4 = fromObject3;
                            fromObject5 = fromObject2;
                            break;
                        }
                        ++n;
                    }
                } else if (this.usedInChildren(fromObject3, joinCondition2)) {
                    fromObject4 = fromObject3;
                    fromObject5 = fromObject2;
                }
                if (((JoinObject)dBObject).getLeftExpression() == fromObject) {
                    ((JoinObject)dBObject).setLeftExpression(fromObject4);
                    this.m_query.addFromObject(fromObject5);
                } else {
                    ((JoinObject)dBObject).setRightExpression(fromObject4);
                    this.m_query.addFromObject(fromObject5);
                }
                bl = true;
            }
            if (bl) {
                this.checkUsageQualifications();
                return true;
            }
        }
        return false;
    }

    private boolean usedInChildren(FromObject fromObject, DBObject dBObject) {
        if (dBObject instanceof FromObjectUsage) {
            return ((FromObjectUsage)dBObject).getFromObject() == fromObject;
        }
        if (dBObject instanceof FKUsage) {
            return ((FKUsage)dBObject).getLeftFromObject() == fromObject || ((FKUsage)dBObject).getRightFromObject() == fromObject;
        }
        DBObject[] dBObjectArray = dBObject.getOwnedObjects();
        int n = 0;
        while (n < dBObjectArray.length) {
            if (this.usedInChildren(fromObject, dBObjectArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean removeFromObject(FromObject fromObject) {
        SQLFragment[] sQLFragmentArray = this.getDependentObjects(fromObject);
        int n = 0;
        while (n < sQLFragmentArray.length) {
            if (sQLFragmentArray[n] instanceof FromObjectUsage) {
                boolean bl = false;
                DBObject dBObject = sQLFragmentArray[n].getParent();
                while (dBObject != null) {
                    if (dBObject instanceof SelectObject) {
                        this.removeSelectObject((SelectObject)dBObject);
                        break;
                    }
                    if (dBObject instanceof OrderByObject) {
                        this.removeOrderByObject((OrderByObject)dBObject);
                        break;
                    }
                    if (dBObject instanceof WhereObject) {
                        bl = true;
                        if (dBObject.getParent() instanceof SQLQuery) {
                            this.removeWhereObject((WhereObject)dBObject);
                            break;
                        }
                    } else if (dBObject instanceof GroupByObject) {
                        if (bl) {
                            this.setHavingObject(null);
                            break;
                        }
                        this.removeGroupByColumn((FromObjectUsage)sQLFragmentArray[n]);
                        break;
                    }
                    dBObject = dBObject.getParent();
                }
            }
            ++n;
        }
        DBObject dBObject = fromObject.getParent();
        if (dBObject instanceof JoinObject) {
            FromObject fromObject2 = null;
            fromObject2 = fromObject == ((JoinObject)dBObject).getLeftExpression() ? ((JoinObject)dBObject).getRightExpression() : ((JoinObject)dBObject).getLeftExpression();
            FromObject fromObject3 = (FromObject)dBObject.getParent();
            DBObject dBObject2 = fromObject3.getParent();
            if (dBObject2 instanceof JoinObject) {
                if (fromObject3 == ((JoinObject)dBObject2).getLeftExpression()) {
                    ((JoinObject)dBObject2).setLeftExpression(fromObject2);
                } else {
                    ((JoinObject)dBObject2).setRightExpression(fromObject2);
                }
            } else {
                FromObject[] fromObjectArray = this.m_query.getFromObjects();
                int n2 = 0;
                while (n2 < fromObjectArray.length) {
                    if (fromObjectArray[n2] == fromObject3) {
                        fromObjectArray[n2] = fromObject2;
                    }
                    ++n2;
                }
                this.m_query.setFromObjects(fromObjectArray);
            }
            this.unloadObject(fromObject);
            return true;
        }
        if (this.m_query.removeFromObject(fromObject)) {
            this.unloadObject(fromObject);
            return true;
        }
        return false;
    }

    public SQLQueryBuilder.SQLQueryObjectSet constructFKJoin(FKConstraint fKConstraint, FromObject fromObject, FromObject fromObject2) throws SQLQueryException {
        FromObject fromObject3 = this.doConstructJoin(fKConstraint, null, null, fromObject, fromObject2);
        if (fromObject3.getParent() == null) {
            this.addJoinObject(fromObject3);
        }
        return new SQLQueryObjectSetImpl(null, new FromObject[]{fromObject3}, fromObject3);
    }

    public SQLQueryBuilder.SQLQueryObjectSet constructFKJoins(FKConstraint[] fKConstraintArray, FromObject[] fromObjectArray) throws SQLQueryException {
        Map map = this.getRelIDs(fromObjectArray);
        FromObject[] fromObjectArray2 = new FromObject[fKConstraintArray.length];
        ArrayList arrayList = new ArrayList();
        int n = fKConstraintArray.length - 1;
        while (n >= 0) {
            fromObjectArray2[n] = this.doConstructJoin(fKConstraintArray[n], map, arrayList, null, n < fKConstraintArray.length - 1 ? fromObjectArray2[n + 1] : null);
            --n;
        }
        this.addJoinObject(fromObjectArray2[0]);
        return new SQLQueryObjectSetImpl(null, fromObjectArray2, null);
    }

    protected FromObject doConstructJoin(FKConstraint fKConstraint, Map map, List list, FromObject fromObject, FromObject fromObject2) throws SQLQueryException {
        DBObjectID dBObjectID = fKConstraint.getID();
        if (dBObjectID == null) {
            throw new IDException(fKConstraint);
        }
        if (fromObject == null) {
            Relation relation = fKConstraint.getRelation();
            DBObjectID dBObjectID2 = relation.getID();
            if (map.containsKey(dBObjectID2)) {
                fromObject = (FromObject)map.get(dBObjectID2);
            } else {
                fromObject = this.createFromObject(relation, list);
                list.add(fromObject);
            }
        }
        if (fromObject2 == null) {
            DBObjectID dBObjectID3 = fKConstraint.getReferenceID();
            try {
                UniqueConstraint uniqueConstraint = (UniqueConstraint)dBObjectID3.resolveID();
                Relation relation = uniqueConstraint.getRelation();
                DBObjectID dBObjectID4 = relation.getID();
                if (dBObjectID4 == null) {
                    throw new IDException(relation);
                }
                if (map.containsKey(dBObjectID4) && (fromObject2 = (FromObject)map.get(dBObjectID4)) == fromObject) {
                    fromObject2 = null;
                }
                if (fromObject2 == null) {
                    fromObject2 = this.createFromObject(relation, list);
                    list.add(fromObject2);
                }
            }
            catch (DBException dBException) {
                throw new IDException(dBObjectID3, dBException);
            }
        }
        return this.createJoinObject(fKConstraint, fromObject, fromObject2);
    }

    protected FromObject createJoinObject(FKConstraint fKConstraint, FromObject fromObject, FromObject fromObject2) throws SQLQueryException {
        if (fromObject.getParent() instanceof JoinObject && fromObject.getParent() == fromObject2.getParent()) {
            throw new SQLQueryException(DBArb.getString(26));
        }
        JoinObject joinObject = new JoinObject();
        FromObject fromObject3 = new FromObject(joinObject, null);
        DBObject dBObject = fromObject.getParent();
        if (dBObject == this.m_query) {
            this.m_query.removeFromObject(fromObject);
        } else if (dBObject instanceof JoinObject) {
            if (fromObject == ((JoinObject)dBObject).getLeftExpression()) {
                ((JoinObject)dBObject).setLeftExpression(fromObject3);
            } else {
                ((JoinObject)dBObject).setRightExpression(fromObject3);
            }
        }
        DBObject dBObject2 = fromObject2.getParent();
        if (dBObject2 == this.m_query) {
            this.m_query.removeFromObject(fromObject2);
        } else if (dBObject2 instanceof JoinObject) {
            if (fromObject2 == ((JoinObject)dBObject2).getLeftExpression()) {
                ((JoinObject)dBObject2).setLeftExpression(fromObject3);
            } else {
                ((JoinObject)dBObject2).setRightExpression(fromObject3);
            }
        }
        joinObject.setLeftExpression(fromObject);
        joinObject.setRightExpression(fromObject2);
        this.createJoinCondition(fKConstraint, joinObject);
        return fromObject3;
    }

    protected JoinCondition createJoinCondition(FKConstraint fKConstraint, JoinObject joinObject) {
        AbstractSQLFragment abstractSQLFragment = null;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Column[] columnArray = fKConstraint.getColumns();
        Column[] columnArray2 = null;
        DBObjectID dBObjectID = fKConstraint.getReferenceID();
        try {
            UniqueConstraint uniqueConstraint = (UniqueConstraint)dBObjectID.resolveID();
            columnArray2 = uniqueConstraint.getColumns();
        }
        catch (DBException dBException) {
            DBUtil.logStackTrace(dBException);
        }
        if (columnArray == null || columnArray2 == null || columnArray.length < 1 || columnArray.length != columnArray2.length) {
            arrayList = null;
        } else {
            int n = 0;
            while (n < columnArray.length) {
                if (!ModelUtil.areEqual((Object)columnArray[n].getName(), (Object)columnArray2[n].getName())) {
                    arrayList = null;
                    break;
                }
                arrayList.add(columnArray[n]);
                ++n;
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            FromObjectUsage[] fromObjectUsageArray = new FromObjectUsage[arrayList.size()];
            int n = 0;
            while (n < fromObjectUsageArray.length) {
                Column column = (Column)arrayList.get(n);
                fromObjectUsageArray[n] = new ColumnUsage(column.getID(), joinObject.getLeftExpression());
                ++n;
            }
            abstractSQLFragment = new UsingJoinCondition(fromObjectUsageArray);
            this.m_usings.add(abstractSQLFragment);
        } else {
            FKUsage fKUsage = this.createFKUsage(fKConstraint.getID(), joinObject.getLeftExpression(), joinObject.getRightExpression());
            abstractSQLFragment = new OnJoinCondition(fKUsage);
        }
        joinObject.setCondition((JoinCondition)((Object)abstractSQLFragment));
        return abstractSQLFragment;
    }

    protected FKUsage doConstructFKUsage(FKConstraint fKConstraint, Map map, List list) throws SQLQueryException {
        DBObjectID dBObjectID = fKConstraint.getID();
        if (dBObjectID == null) {
            throw new IDException(fKConstraint);
        }
        FromObject fromObject = null;
        DBObjectID dBObjectID2 = fKConstraint.getReferenceID();
        try {
            UniqueConstraint uniqueConstraint = (UniqueConstraint)dBObjectID2.resolveID();
            Relation relation = uniqueConstraint.getRelation();
            DBObjectID dBObjectID3 = relation.getID();
            if (dBObjectID3 == null) {
                throw new IDException(relation);
            }
            if (map.containsKey(dBObjectID3)) {
                fromObject = (FromObject)map.get(dBObjectID3);
            } else {
                fromObject = this.createFromObject(relation, list);
                list.add(fromObject);
            }
        }
        catch (DBException dBException) {
            throw new IDException(dBObjectID2, dBException);
        }
        FromObject fromObject2 = null;
        Relation relation = fKConstraint.getRelation();
        DBObjectID dBObjectID4 = relation.getID();
        if (map.containsKey(dBObjectID4)) {
            fromObject2 = (FromObject)map.get(dBObjectID4);
        } else {
            fromObject2 = this.createFromObject(relation, list);
            list.add(fromObject2);
        }
        return this.createFKUsage(dBObjectID, fromObject, fromObject2);
    }

    protected FKUsage createFKUsage(DBObjectID dBObjectID, FromObject fromObject, FromObject fromObject2) {
        FKUsage fKUsage = new FKUsage(dBObjectID, fromObject, fromObject2);
        fKUsage.setProvider(this.m_provider);
        return fKUsage;
    }

    public void setWhereObject(WhereObject whereObject) {
        WhereObject whereObject2 = this.m_query.getWhereObject();
        if (whereObject2 != null && !whereObject2.equals(whereObject)) {
            this.unloadObject(whereObject2);
        }
        this.m_query.setWhereObject(whereObject);
        if (whereObject != null) {
            this.loadObject(whereObject);
        }
    }

    protected boolean removeWhereObject(SQLFragment sQLFragment) {
        WhereObject whereObject = this.m_query.getWhereObject();
        if (whereObject != null) {
            if (whereObject.equals(sQLFragment)) {
                this.unloadObject(sQLFragment);
                this.m_query.setWhereObject(null);
                return true;
            }
            SQLFragment[] sQLFragmentArray = whereObject.getArguments();
            int n = 0;
            while (sQLFragmentArray != null && n < sQLFragmentArray.length) {
                if (sQLFragmentArray[n] == sQLFragment) {
                    SQLFragment sQLFragment2;
                    SQLFragment[] sQLFragmentArray2 = new SQLFragment[sQLFragmentArray.length - 1];
                    System.arraycopy(sQLFragmentArray, 0, sQLFragmentArray2, 0, n);
                    System.arraycopy(sQLFragmentArray, n + 1, sQLFragmentArray2, n, sQLFragmentArray.length - n - 1);
                    whereObject.setArguments(sQLFragmentArray2);
                    this.unloadObject(sQLFragment);
                    if (whereObject.getArgumentCount() < 1) {
                        this.m_query.setWhereObject(null);
                    } else if (whereObject.getArgumentCount() == 1 && (sQLFragment2 = whereObject.getArguments()[0]) instanceof WhereObject) {
                        this.m_query.setWhereObject((WhereObject)sQLFragment2);
                    }
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public RelationUsage[] getRelationUsages() {
        FromObject[] fromObjectArray = this.listAllFromObjects();
        ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
        int n = 0;
        while (n < fromObjectArray.length) {
            SQLFragment sQLFragment = fromObjectArray[n].getExpression();
            if (sQLFragment instanceof RelationUsage) {
                arrayList.add(sQLFragment);
            }
            ++n;
        }
        return arrayList.toArray(new RelationUsage[arrayList.size()]);
    }

    public SQLFragment[] getDependentObjects(FromObject fromObject) {
        Set set = (Set)this.m_fromDeps.get(fromObject);
        if (set != null) {
            return set.toArray(new SQLFragment[set.size()]);
        }
        return EMPTY_ARRAY;
    }

    public SQLFragment[] getDependentObjects(SelectObject selectObject) {
        SQLFragment sQLFragment;
        ArrayList<GroupByObject> arrayList = new ArrayList<GroupByObject>();
        if (this.supportsGroupBy() && (sQLFragment = selectObject.getExpression()) instanceof Function && ((Function)sQLFragment).isGrouping()) {
            boolean bl = true;
            SelectObject[] selectObjectArray = this.m_query.getSelectObjects();
            int n = 0;
            while (n < selectObjectArray.length) {
                SQLFragment sQLFragment2;
                if (!selectObjectArray[n].equals(selectObject) && (sQLFragment2 = selectObjectArray[n].getExpression()) instanceof Function && ((Function)sQLFragment2).isGrouping()) {
                    bl = false;
                    break;
                }
                ++n;
            }
            GroupByObject groupByObject = this.m_query.getGroupByObject();
            if (bl && groupByObject != null) {
                arrayList.add(groupByObject);
            }
        }
        return arrayList.toArray(new SQLFragment[arrayList.size()]);
    }

    public boolean canMergeRelationUsages(RelationUsage relationUsage, RelationUsage relationUsage2) {
        DBObjectID dBObjectID = relationUsage.getObjectID();
        DBObjectID dBObjectID2 = relationUsage2.getObjectID();
        return dBObjectID != null && ModelUtil.areEqual((Object)dBObjectID, (Object)dBObjectID2);
    }

    public void mergeRelationUsages(RelationUsage relationUsage, RelationUsage relationUsage2) throws SQLQueryException {
        DBObjectID dBObjectID = relationUsage.getObjectID();
        DBObjectID dBObjectID2 = relationUsage.getObjectID();
        if (dBObjectID == null || ModelUtil.areDifferent((Object)dBObjectID, (Object)dBObjectID2)) {
            throw new SQLQueryException(DBArb.getString(18));
        }
        FromObject fromObject = (FromObject)relationUsage.getParent();
        FromObject fromObject2 = (FromObject)relationUsage2.getParent();
        if (!(fromObject2.getParent() instanceof SQLQuery)) {
            throw new SQLQueryException(DBArb.getString(27));
        }
        SQLFragment[] sQLFragmentArray = this.getDependentObjects(fromObject2);
        int n = 0;
        while (n < sQLFragmentArray.length) {
            this.setNewFromObject(sQLFragmentArray[n], fromObject2, fromObject);
            ++n;
        }
    }

    public FKUsage[] listAvailableFKs() {
        ArrayList<FKUsage> arrayList = new ArrayList<FKUsage>();
        RelationUsage[] relationUsageArray = this.getRelationUsages();
        HashMap<DBObjectID, ArrayList<DBObject>> hashMap = new HashMap<DBObjectID, ArrayList<DBObject>>();
        int n = 0;
        while (n < relationUsageArray.length) {
            DBObjectID dBObjectID = relationUsageArray[n].getObjectID();
            if (dBObjectID != null) {
                ArrayList<DBObject> arrayList2 = (ArrayList<DBObject>)hashMap.get(dBObjectID);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<DBObject>();
                    hashMap.put(dBObjectID, arrayList2);
                }
                arrayList2.add(relationUsageArray[n].getParent());
            }
            ++n;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                DBObjectID dBObjectID = (DBObjectID)iterator.next();
                List list = (List)hashMap.get(dBObjectID);
                int n2 = 0;
                while (n2 < list.size()) {
                    FromObject fromObject = (FromObject)list.get(n2);
                    if (dBObjectID != null) {
                        Relation relation = (Relation)dBObjectID.resolveID();
                        Constraint[] constraintArray = relation.getConstraints();
                        int n3 = 0;
                        while (n3 < constraintArray.length) {
                            if (constraintArray[n3] instanceof FKConstraint) {
                                try {
                                    Constraint constraint;
                                    DBObjectID dBObjectID2 = ((FKConstraint)constraintArray[n3]).getReferenceID();
                                    if (dBObjectID2 != null && (constraint = (Constraint)dBObjectID2.resolveID()) != null) {
                                        Relation relation2 = constraint.getRelation();
                                        List list2 = (List)hashMap.get(relation2.getID());
                                        int n4 = 0;
                                        while (list2 != null && n4 < list2.size()) {
                                            FKUsage fKUsage;
                                            FromObject fromObject2 = (FromObject)list2.get(n4);
                                            if (fromObject2 != null && !arrayList.contains(fKUsage = new FKUsage(constraintArray[n3].getID(), fromObject, fromObject2))) {
                                                arrayList.add(fKUsage);
                                            }
                                            ++n4;
                                        }
                                    }
                                }
                                catch (DBException dBException) {
                                    dBException.printStackTrace();
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
        }
        return arrayList.toArray(new FKUsage[arrayList.size()]);
    }

    public ColumnUsage[] getColumnUsages() {
        ArrayList arrayList = new ArrayList();
        SelectObject[] selectObjectArray = this.m_query.getSelectObjects();
        int n = 0;
        while (selectObjectArray != null && n < selectObjectArray.length) {
            this.findColumnUsages(selectObjectArray[n], arrayList);
            ++n;
        }
        WhereObject whereObject = this.m_query.getWhereObject();
        this.findColumnUsages(whereObject, arrayList);
        return arrayList.toArray(new ColumnUsage[arrayList.size()]);
    }

    private void findColumnUsages(DBObject dBObject, List list) {
        if (dBObject != null) {
            if (dBObject instanceof ColumnUsage) {
                list.add(dBObject);
            }
            DBObject[] dBObjectArray = dBObject.getOwnedObjects();
            int n = 0;
            while (dBObjectArray != null && n < dBObjectArray.length) {
                this.findColumnUsages(dBObjectArray[n], list);
                ++n;
            }
        }
    }

    protected FromObjectUsage findColumnInFromObjects(String string) throws SQLQueryException {
        FromObject[] fromObjectArray = this.m_query.getFromObjects();
        FromObjectUsage fromObjectUsage = this.findColumnInFromObjects(string, fromObjectArray, false, false);
        if (fromObjectUsage != null) {
            fromObjectUsage.setQualified(false);
        }
        return fromObjectUsage;
    }

    protected FromObjectUsage findColumnInFromObjects(String string, FromObject[] fromObjectArray, boolean bl, boolean bl2) throws SQLQueryException {
        if (!ModelUtil.hasLength((String)string)) {
            return null;
        }
        FromObjectUsage fromObjectUsage = null;
        int n = 0;
        while (n < fromObjectArray.length) {
            FromObjectUsage fromObjectUsage2 = null;
            FromObject fromObject = fromObjectArray[n];
            SQLFragment sQLFragment = fromObject.getExpression();
            if (sQLFragment instanceof RelationUsage) {
                fromObjectUsage2 = this.findColumnInRelation(string, (RelationUsage)sQLFragment);
            } else if (sQLFragment instanceof SynonymUsage) {
                SchemaObject schemaObject = ((SynonymUsage)sQLFragment).getReferencedObject();
                if (schemaObject instanceof Relation && (fromObjectUsage2 = this.findColumnInRelation(string, (Relation)schemaObject)) != null) {
                    fromObjectUsage2.setFromObject(fromObject);
                }
            } else if (sQLFragment instanceof SQLQuery) {
                fromObjectUsage2 = this.findColumnInSubQuery(string, (SQLQuery)sQLFragment);
            } else if (sQLFragment instanceof JoinObject) {
                fromObjectUsage2 = this.findColumnInJoin(string, (JoinObject)sQLFragment);
            }
            if (fromObjectUsage2 != null) {
                if (fromObjectUsage != null && !bl) {
                    throw new AmbiguousColumnException(string);
                }
                fromObjectUsage = fromObjectUsage2;
            } else if (bl2) {
                throw new SQLQueryException(DBArb.format(25, string, fromObjectArray[n].getName()));
            }
            ++n;
        }
        return fromObjectUsage;
    }

    protected FromObjectUsage findColumnInJoin(String string, JoinObject joinObject) throws SQLQueryException {
        return this.findColumnInFromObjects(string, new FromObject[]{joinObject.getLeftExpression(), joinObject.getRightExpression()}, true, false);
    }

    protected FromObjectUsage findColumnInRelation(String string, RelationUsage relationUsage) throws SQLQueryException {
        DBObjectID dBObjectID = relationUsage.getObjectID();
        try {
            Relation relation = (Relation)dBObjectID.resolveID();
            FromObjectUsage fromObjectUsage = this.findColumnInRelation(string, relation);
            if (fromObjectUsage != null) {
                fromObjectUsage.setFromObject((FromObject)relationUsage.getParent());
            }
            FromObjectUsage fromObjectUsage2 = fromObjectUsage;
            return fromObjectUsage2;
        }
        catch (DBException dBException) {
            DBUtil.logStackTrace(dBException);
            return null;
        }
    }

    protected FromObjectUsage findColumnInRelation(String string, Relation relation) throws SQLQueryException {
        Column column = relation.getColumn(string = this.m_provider.getInternalName(string));
        if (column != null) {
            DBObjectID dBObjectID = column.getID();
            if (dBObjectID == null) {
                throw new IDException(column);
            }
            ColumnUsage columnUsage = new ColumnUsage(dBObjectID);
            columnUsage.setProvider(this.m_provider);
            return columnUsage;
        }
        return null;
    }

    protected SelectObjectUsage findColumnInSubQuery(String string, SQLQuery sQLQuery) throws SQLQueryException {
        SelectObject[] selectObjectArray = sQLQuery.getSelectObjects();
        int n = 0;
        while (n < selectObjectArray.length) {
            String string2 = selectObjectArray[n].getName();
            int n2 = string2.lastIndexOf(".");
            if (n2 > -1) {
                string2 = string2.substring(n2 + 1);
            }
            if (string.equalsIgnoreCase(string2)) {
                return new SelectObjectUsage(selectObjectArray[n], (FromObject)sQLQuery.getParent());
            }
            ++n;
        }
        return null;
    }

    public void setGroupByObject(GroupByObject groupByObject) {
        GroupByObject groupByObject2 = this.m_query.getGroupByObject();
        this.unloadObject(groupByObject2);
        this.m_query.setGroupByObject(groupByObject);
        if (groupByObject != null) {
            FromObjectUsage[] fromObjectUsageArray = groupByObject.getExpressions();
            int n = 0;
            while (fromObjectUsageArray != null && n < fromObjectUsageArray.length) {
                this.loadObject(fromObjectUsageArray[n]);
                ++n;
            }
            WhereObject whereObject = groupByObject.getHaving();
            if (whereObject != null) {
                this.loadObject(whereObject);
            }
        }
    }

    public boolean canSetGroupBy() {
        if (this.supportsGroupBy()) {
            SelectObject[] selectObjectArray = this.m_query.getSelectObjects();
            int n = 0;
            while (selectObjectArray != null && n < selectObjectArray.length) {
                SQLFragment sQLFragment = selectObjectArray[n].getExpression();
                if (sQLFragment instanceof Function && ((Function)sQLFragment).isGrouping()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void addGroupByColumn(FromObjectUsage fromObjectUsage) {
        GroupByObject groupByObject = this.m_query.getGroupByObject();
        if (groupByObject == null) {
            groupByObject = new GroupByObject();
            this.m_query.setGroupByObject(groupByObject);
        }
        groupByObject.addExpression(fromObjectUsage);
        this.loadObject(fromObjectUsage);
    }

    public void addGroupByColumn(int n, FromObjectUsage fromObjectUsage) {
        GroupByObject groupByObject = this.m_query.getGroupByObject();
        if (groupByObject == null) {
            groupByObject = new GroupByObject();
            this.m_query.setGroupByObject(groupByObject);
        }
        groupByObject.addExpression(n, fromObjectUsage);
        this.loadObject(fromObjectUsage);
    }

    public boolean removeGroupByColumn(FromObjectUsage fromObjectUsage) {
        GroupByObject groupByObject = this.m_query.getGroupByObject();
        if (groupByObject != null && groupByObject.removeExpression(fromObjectUsage)) {
            this.unloadObject(fromObjectUsage);
            return true;
        }
        return false;
    }

    public SQLFragment parseHavingExpression(String string) throws SQLQueryException {
        return this.parseWhereExpression(string);
    }

    public SQLFragment parseOrderByExpression(String string) throws SQLQueryException {
        return this.parseSelectExpression(string);
    }

    public void setHavingObject(WhereObject whereObject) {
        GroupByObject groupByObject = this.m_query.getGroupByObject();
        groupByObject.getHaving();
        this.unloadObject(groupByObject);
        groupByObject.setHaving(whereObject);
        if (whereObject != null) {
            this.loadObject(whereObject);
        }
    }

    public void addOrderByObject(OrderByObject orderByObject) {
        this.m_query.addOrderByObject(orderByObject);
        this.loadObject(orderByObject);
    }

    public void addOrderByObject(int n, OrderByObject orderByObject) {
        this.m_query.addOrderByObject(n, orderByObject);
        this.loadObject(orderByObject);
    }

    public boolean removeOrderByObject(OrderByObject orderByObject) {
        if (this.m_query.removeOrderByObject(orderByObject)) {
            this.unloadObject(orderByObject);
            return true;
        }
        return false;
    }

    public void replaceOrderByObject(OrderByObject orderByObject, OrderByObject orderByObject2) {
        SQLFragment sQLFragment;
        SQLFragment sQLFragment2 = orderByObject.getExpression();
        if (ModelUtil.areDifferent((Object)sQLFragment2, (Object)(sQLFragment = orderByObject2.getExpression()))) {
            this.unloadObject(orderByObject);
            this.loadObject(sQLFragment);
        }
        orderByObject2.copyTo(orderByObject);
    }

    public void setOrderByObjects(OrderByObject[] orderByObjectArray) {
        OrderByObject[] orderByObjectArray2 = this.m_query.getOrderByObjects();
        int n = 0;
        while (orderByObjectArray2 != null && n < orderByObjectArray2.length) {
            this.unloadObject(orderByObjectArray2[n]);
            ++n;
        }
        this.m_query.setOrderByObjects(orderByObjectArray);
        this.loadObjects(orderByObjectArray);
    }

    public void syncViewColumns() {
        if (this.m_query.getParent() instanceof View) {
            View view = (View)this.m_query.getParent();
            Column[] columnArray = view.getColumns();
            HashMap<DBObjectID, Column> hashMap = new HashMap<DBObjectID, Column>();
            if (columnArray != null) {
                int n = 0;
                while (n < columnArray.length) {
                    if (columnArray[n] instanceof ViewColumn) {
                        hashMap.put(((ViewColumn)columnArray[n]).getSelectObjectID(), columnArray[n]);
                    }
                    ++n;
                }
            }
            SelectObject[] selectObjectArray = this.m_query.getSelectObjects();
            Column[] columnArray2 = new ViewColumn[selectObjectArray.length];
            int n = 0;
            while (n < selectObjectArray.length) {
                DBObjectID dBObjectID = selectObjectArray[n].getID();
                if (dBObjectID == null) {
                    dBObjectID = TemporaryObjectID.createID(selectObjectArray[n]);
                    selectObjectArray[n].setID(dBObjectID);
                }
                columnArray2[n] = hashMap.containsKey(dBObjectID) ? (ViewColumn)hashMap.get(dBObjectID) : new ViewColumn(dBObjectID);
                ++n;
            }
            view.setColumns(columnArray2);
        }
    }

    public void checkUsageQualifications() {
        if (this.m_fromDeps.size() > 0) {
            for (FromObject fromObject : this.m_fromDeps.keySet()) {
                this.checkUsageQualifications(fromObject);
            }
        }
    }

    private void checkUsageQualifications(FromObject fromObject) {
        if (this.m_fromDeps.containsKey(fromObject)) {
            Set set = (Set)this.m_fromDeps.get(fromObject);
            for (Object e : set) {
                if (!(e instanceof FromObjectUsage)) continue;
                FromObjectUsage fromObjectUsage = (FromObjectUsage)e;
                boolean bl = this.isUsedInUsing(fromObjectUsage);
                if (fromObjectUsage.isQualified() && bl) {
                    fromObjectUsage.setQualified(false);
                    continue;
                }
                if (fromObjectUsage.isQualified() || bl) continue;
                String string = fromObjectUsage.getColumnName();
                try {
                    this.findColumnInFromObjects(string);
                }
                catch (AmbiguousColumnException ambiguousColumnException) {
                    fromObjectUsage.setQualified(true);
                }
                catch (SQLQueryException sQLQueryException) {
                    DBUtil.logStackTrace(sQLQueryException);
                }
            }
        }
    }

    private boolean isUsedInUsing(FromObjectUsage fromObjectUsage) {
        DBObjectID dBObjectID;
        if (this.m_usings.size() > 0 && fromObjectUsage instanceof DBObjectUsage && (dBObjectID = ((DBObjectUsage)((Object)fromObjectUsage)).getObjectID()) != null) {
            for (UsingJoinCondition usingJoinCondition : this.m_usings) {
                FromObjectUsage[] fromObjectUsageArray = usingJoinCondition.getColumns();
                int n = 0;
                while (n < fromObjectUsageArray.length) {
                    if (fromObjectUsageArray[n] instanceof DBObjectUsage) {
                        DBObjectID dBObjectID2 = ((DBObjectUsage)((Object)fromObjectUsageArray[n])).getObjectID();
                        if (dBObjectID.equals(dBObjectID2, false)) {
                            return true;
                        }
                        JoinObject joinObject = (JoinObject)usingJoinCondition.getParent();
                        FromObject fromObject = joinObject.getLeftExpression();
                        if (fromObjectUsageArray[n].getFromObject() == fromObject) {
                            fromObject = joinObject.getRightExpression();
                        }
                        try {
                            DBObjectID dBObjectID3;
                            FromObjectUsage fromObjectUsage2 = this.findColumnInFromObjects(fromObjectUsageArray[n].getColumnName(), new FromObject[]{fromObject}, false, false);
                            if (fromObjectUsage2 != null && fromObjectUsage2 instanceof DBObjectUsage && dBObjectID.equals(dBObjectID3 = ((DBObjectUsage)((Object)fromObjectUsage2)).getObjectID(), false)) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                        catch (SQLQueryException sQLQueryException) {
                            // empty catch block
                        }
                    }
                    ++n;
                }
            }
        }
        return false;
    }

    private void checkSelectObject(SelectObject selectObject) {
        FromObjectUsage fromObjectUsage;
        SQLFragment sQLFragment = selectObject.getExpression();
        if (sQLFragment instanceof FromObjectUsage && (fromObjectUsage = (FromObjectUsage)sQLFragment).isQualified() && this.isUsedInUsing(fromObjectUsage)) {
            fromObjectUsage.setQualified(false);
        }
    }

    public class SQLQueryObjectSetImpl
    implements SQLQueryBuilder.SQLQueryObjectSet {
        private AbstractSQLFragment m_object;
        private SelectObject[] m_selectObjs;
        private FromObject[] m_fromObjs;

        public SQLQueryObjectSetImpl(SelectObject[] selectObjectArray, FromObject[] fromObjectArray) {
            this.m_selectObjs = selectObjectArray == null ? new SelectObject[]{} : selectObjectArray;
            this.m_fromObjs = fromObjectArray == null ? new FromObject[]{} : fromObjectArray;
        }

        public SQLQueryObjectSetImpl(SelectObject[] selectObjectArray, FromObject[] fromObjectArray, SQLFragment sQLFragment) {
            this(selectObjectArray, fromObjectArray);
            this.m_object = (AbstractSQLFragment)sQLFragment;
        }

        public SQLFragment getObject() {
            return this.m_object;
        }

        public SelectObject[] getSelectObjects() {
            return this.m_selectObjs;
        }

        public FromObject[] getFromObjects() {
            return this.m_fromObjs;
        }
    }
}

