/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaObjectUsage
extends AbstractSQLFragment
implements DBObjectUsage {
    private DBObjectID m_id;
    protected transient DBObjectProvider m_pro;

    public AbstractSchemaObjectUsage() {
    }

    public AbstractSchemaObjectUsage(DBObjectID dBObjectID) {
        this.setObjectID(dBObjectID);
    }

    @Override
    public void setProvider(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    @Override
    public void setObjectID(DBObjectID dBObjectID) {
        this.m_id = dBObjectID;
    }

    @Override
    public DBObjectID getObjectID() {
        return this.m_id;
    }

    @Override
    public String getSQLText() {
        if (this.m_id != null) {
            try {
                SchemaObject schemaObject = (SchemaObject)this.m_id.resolveID();
                if (schemaObject != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (this.isInDifferentSchema(schemaObject)) {
                        stringBuffer.append(schemaObject.getSchema().getName());
                        stringBuffer.append(".");
                    }
                    String string = schemaObject.getName();
                    if (this.m_pro != null) {
                        stringBuffer.append(this.m_pro.getExternalName(string));
                    } else {
                        stringBuffer.append(string);
                    }
                    String string2 = stringBuffer.toString();
                    return string2;
                }
            }
            catch (DBException dBException) {
                DBUtil.logStackTrace(dBException);
            }
        }
        return null;
    }

    protected boolean equalsImpl(AbstractSchemaObjectUsage abstractSchemaObjectUsage) {
        return super.equalsImpl(abstractSchemaObjectUsage) && ModelUtil.areEqual((Object)abstractSchemaObjectUsage.m_id, (Object)this.m_id);
    }

    protected void copyToImpl(AbstractSchemaObjectUsage abstractSchemaObjectUsage, boolean bl) {
        super.copyToImpl(abstractSchemaObjectUsage, bl);
        abstractSchemaObjectUsage.m_id = this.m_id;
        abstractSchemaObjectUsage.m_pro = this.m_pro;
    }

    protected boolean isInDifferentSchema(SchemaObject schemaObject) {
        Schema schema;
        Schema schema2 = schemaObject.getSchema();
        if (schema2 != null && (schema = DBUtil.getSchema(this)) != null) {
            return schema.getName().equals(schema2.getName()) ^ true;
        }
        return false;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        super.getReferenceIDsImpl(collection);
        if (this.m_id != null) {
            collection.add(this.m_id);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> map) {
        if (this.m_id != null && map.containsKey(this.m_id)) {
            this.m_id = map.get(this.m_id);
            return true;
        }
        return super.replaceReferenceIDs(map);
    }
}

