/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class ArithmeticOperation
extends Operation {
    private int m_op;
    public static final int ADD = 10;
    public static final int SUBTRACT = 11;
    public static final int MULTIPLY = 12;
    public static final int DIVIDE = 13;
    public static final int NEGATE = 14;
    private static Map s_arithmetic = new HashMap();

    public ArithmeticOperation() {
        this.setFunctionFormat(false);
    }

    public ArithmeticOperation(int n, SQLFragment[] sQLFragmentArray) {
        this();
        this.setArguments(sQLFragmentArray);
        this.setOperator(n);
    }

    public int getOperation() {
        return this.m_op;
    }

    public void setOperator(int n) {
        if (!ArithmeticOperation.isArithmeticOperation(n)) {
            throw new IllegalArgumentException(DBArb.format(9, String.valueOf(n)));
        }
        this.m_op = n;
        this.setCommutative(n == 10 || n == 12);
    }

    public String getOperatorText() {
        return ArithmeticOperation.getArithmeticOperation(this.m_op);
    }

    public boolean equals(Object object) {
        return object instanceof ArithmeticOperation && this.equalsImpl((ArithmeticOperation)object);
    }

    protected boolean equalsImpl(ArithmeticOperation arithmeticOperation) {
        return super.equalsImpl(arithmeticOperation) && arithmeticOperation.m_op == this.m_op;
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        ArithmeticOperation arithmeticOperation = dBObject == null ? new ArithmeticOperation() : (ArithmeticOperation)dBObject;
        this.copyToImpl(arithmeticOperation, bl);
        return arithmeticOperation;
    }

    protected void copyToImpl(ArithmeticOperation arithmeticOperation, boolean bl) {
        super.copyToImpl(arithmeticOperation, bl);
        arithmeticOperation.m_op = this.m_op;
    }

    static {
        s_arithmetic.put(new Integer(10), "+");
        s_arithmetic.put(new Integer(11), "-");
        s_arithmetic.put(new Integer(12), "*");
        s_arithmetic.put(new Integer(13), "/");
        s_arithmetic.put(new Integer(14), "-");
    }

    public static boolean isArithmeticOperation(int n) {
        return s_arithmetic.containsKey(new Integer(n));
    }

    public static String getArithmeticOperation(int n) {
        return (String)s_arithmetic.get(new Integer(n));
    }
}

