/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseStatement
extends AbstractSQLFragment {
    public static final String CASE = "CASE";
    public static final String WHEN = "WHEN";
    public static final String THEN = "THEN";
    public static final String ELSE = "ELSE";
    public static final String END = "END";
    private SQLFragment m_exp;
    private WhenThen[] m_whenThens;
    private SQLFragment m_else;

    public CaseStatement() {
    }

    public CaseStatement(SQLFragment sQLFragment, WhenThen[] whenThenArray, SQLFragment sQLFragment2) {
        this.setExpression(sQLFragment);
        this.setWhenThens(whenThenArray);
        this.setElseExpression(sQLFragment2);
    }

    public CaseStatement(SQLFragment sQLFragment, WhenThen[] whenThenArray) {
        this.setExpression(sQLFragment);
        this.setWhenThens(whenThenArray);
    }

    public CaseStatement(WhenThen[] whenThenArray, SQLFragment sQLFragment) {
        this.setWhenThens(whenThenArray);
        this.setElseExpression(sQLFragment);
    }

    public CaseStatement(WhenThen[] whenThenArray) {
        this.setWhenThens(whenThenArray);
    }

    public SQLFragment getExpression() {
        return this.m_exp;
    }

    public void setExpression(SQLFragment sQLFragment) {
        this.changeParent(this.m_exp, sQLFragment);
        this.m_exp = sQLFragment;
    }

    public WhenThen[] getWhenThens() {
        return this.m_whenThens;
    }

    public void setWhenThens(WhenThen[] whenThenArray) {
        if (this.m_whenThens != null) {
            int n = 0;
            while (n < this.m_whenThens.length) {
                this.removeParent(this.m_whenThens[n]);
                ++n;
            }
        }
        this.m_whenThens = whenThenArray;
        if (this.m_whenThens != null) {
            int n = 0;
            while (n < this.m_whenThens.length) {
                this.m_whenThens[n].setParent(this);
                ++n;
            }
        }
    }

    public SQLFragment getElseExpression() {
        return this.m_else;
    }

    public void setElseExpression(SQLFragment sQLFragment) {
        this.changeParent(this.m_else, sQLFragment);
        this.m_else = sQLFragment;
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        CaseStatement caseStatement = dBObject == null ? new CaseStatement() : (CaseStatement)dBObject;
        this.copyToImpl(caseStatement, bl);
        return caseStatement;
    }

    protected void copyToImpl(CaseStatement caseStatement, boolean bl) {
        WhenThen[] whenThenArray;
        super.copyToImpl(caseStatement, bl);
        caseStatement.setExpression(this.m_exp == null ? null : (SQLFragment)this.m_exp.copyTo(null, bl));
        caseStatement.setElseExpression(this.m_else == null ? null : (SQLFragment)this.m_else.copyTo(null, bl));
        WhenThen[] whenThenArray2 = whenThenArray = this.m_whenThens == null ? null : new WhenThen[this.m_whenThens.length];
        if (whenThenArray != null) {
            int n = 0;
            while (n < this.m_whenThens.length) {
                whenThenArray[n] = (WhenThen)this.m_whenThens[n].copyTo(null, bl);
                ++n;
            }
        }
        caseStatement.setWhenThens(whenThenArray);
    }

    public boolean equals(Object object) {
        return object instanceof CaseStatement && this.equalsImpl((CaseStatement)object);
    }

    protected boolean equalsImpl(CaseStatement caseStatement) {
        return super.equalsImpl(caseStatement) && ModelUtil.areEqual((Object)this.m_exp, (Object)caseStatement.m_exp) && ModelUtil.areEqual((Object)this.m_whenThens, (Object)caseStatement.m_whenThens) && ModelUtil.areEqual((Object)this.m_else, (Object)caseStatement.m_else);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this.includesType("SQLFragment", stringArray)) {
            if (this.m_exp != null) {
                collection.add(this.m_exp);
            }
            if (this.m_whenThens != null) {
                int n = 0;
                while (n < this.m_whenThens.length) {
                    if (this.m_whenThens[n] != null) {
                        collection.add(this.m_whenThens[n]);
                    }
                    ++n;
                }
            }
            if (this.m_else != null) {
                collection.add(this.m_else);
            }
        }
    }

    @Override
    public String getSQLText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CASE).append(" ");
        if (this.m_exp != null) {
            stringBuffer.append(this.m_exp.getSQLText()).append(" ");
        }
        stringBuffer.append("\n");
        if (this.m_whenThens != null) {
            int n = 0;
            while (n < this.m_whenThens.length) {
                stringBuffer.append(" ").append(" ");
                stringBuffer.append(this.m_whenThens[n].getSQLText());
                stringBuffer.append("\n");
                ++n;
            }
        }
        if (this.m_else != null) {
            stringBuffer.append(" ").append(" ");
            stringBuffer.append(ELSE).append(" ").append(this.m_else.getSQLText()).append(" ");
            stringBuffer.append("\n");
        }
        stringBuffer.append(END);
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WhenThen
    extends AbstractSQLFragment {
        private SQLFragment m_when;
        private SQLFragment m_then;

        public WhenThen() {
        }

        public WhenThen(SQLFragment sQLFragment, SQLFragment sQLFragment2) {
            this.setWhenExpression(sQLFragment);
            this.setThenExpression(sQLFragment2);
        }

        public void setWhenExpression(SQLFragment sQLFragment) {
            this.changeParent(this.m_when, sQLFragment);
            this.m_when = sQLFragment;
        }

        public SQLFragment getWhenExpression() {
            return this.m_when;
        }

        public void setThenExpression(SQLFragment sQLFragment) {
            this.changeParent(this.m_then, sQLFragment);
            this.m_then = sQLFragment;
        }

        public SQLFragment getThenExpression() {
            return this.m_then;
        }

        @Override
        public String getSQLText() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(CaseStatement.WHEN).append(" ");
            stringBuffer.append(this.getTextOrNull(this.m_when)).append(" ");
            stringBuffer.append(CaseStatement.THEN).append(" ");
            stringBuffer.append(this.getTextOrNull(this.m_then)).append(" ");
            return stringBuffer.toString();
        }

        @Override
        public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
            WhenThen whenThen = dBObject == null ? new WhenThen() : (WhenThen)dBObject;
            this.copyToImpl(whenThen, bl);
            return whenThen;
        }

        protected void copyToImpl(WhenThen whenThen, boolean bl) {
            super.copyToImpl(whenThen, bl);
            whenThen.setWhenExpression(this.m_when == null ? null : (SQLFragment)this.m_when.copyTo(null, bl));
            whenThen.setThenExpression(this.m_then == null ? null : (SQLFragment)this.m_then.copyTo(null, bl));
        }

        public boolean equals(Object object) {
            return object instanceof WhenThen && this.equalsImpl((WhenThen)object);
        }

        protected boolean equalsImpl(WhenThen whenThen) {
            return super.equalsImpl(whenThen) && ModelUtil.areEqual((Object)this.m_when, (Object)whenThen.m_when) && ModelUtil.areEqual((Object)this.m_then, (Object)whenThen.m_then);
        }

        protected void getOwnedObjectsImpl(Collection<DBObject> collection, String string) {
            super.getOwnedObjectsImpl(collection, string);
            if (string == null || string.equals("SQLFragment")) {
                if (this.m_then != null) {
                    collection.add(this.m_then);
                }
                if (this.m_when != null) {
                    collection.add(this.m_when);
                }
            }
        }
    }
}

