/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnUsage
extends AbstractFromObjectUsage
implements DBObjectUsage {
    private DBObjectID m_id;
    private String[] m_attrs;
    private boolean m_outerJoin;
    private transient DBObjectProvider m_pro;

    public ColumnUsage() {
    }

    public ColumnUsage(DBObjectID dBObjectID) {
        this.m_id = dBObjectID;
    }

    public ColumnUsage(DBObjectID dBObjectID, FromObject fromObject) {
        super(fromObject);
        this.m_id = dBObjectID;
    }

    @Override
    public void setObjectID(DBObjectID dBObjectID) {
        this.m_id = dBObjectID;
    }

    @Override
    public DBObjectID getObjectID() {
        return this.m_id;
    }

    public void setColumnID(DBObjectID dBObjectID) {
        if (dBObjectID != null) {
            this.setObjectID(dBObjectID);
        }
    }

    public DBObjectID getColumnID() {
        return null;
    }

    public String[] getAttributes() {
        return this.m_attrs;
    }

    public void setAttributes(String[] stringArray) {
        this.m_attrs = stringArray;
    }

    public void setOuterJoin(boolean bl) {
        this.m_outerJoin = bl;
    }

    public boolean isOuterJoin() {
        return this.m_outerJoin;
    }

    @Override
    public String getSQLText() {
        StringBuffer stringBuffer = this.getSQLTextImpl();
        if (this.m_attrs != null) {
            int n = 0;
            while (n < this.m_attrs.length) {
                stringBuffer.append(".").append(this.m_attrs[n]);
                ++n;
            }
        }
        if (this.m_outerJoin) {
            stringBuffer.append("(+)");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getColumnName() {
        if (this.m_id != null) {
            try {
                Column column = (Column)this.m_id.resolveID();
                if (column != null) {
                    String string = column.getName();
                    if (this.m_pro != null) {
                        string = this.m_pro.getExternalName(string);
                    }
                    String string2 = string;
                    return string2;
                }
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        ColumnUsage columnUsage = dBObject != null ? (ColumnUsage)dBObject : new ColumnUsage();
        this.copyToImpl(columnUsage, bl);
        return columnUsage;
    }

    public boolean equals(Object object) {
        return object instanceof ColumnUsage && this.equalsImpl((ColumnUsage)object);
    }

    protected boolean equalsImpl(ColumnUsage columnUsage) {
        return super.equalsImpl(columnUsage) && ModelUtil.areEqual((Object)this.m_id, (Object)columnUsage.m_id) && ModelUtil.areEqual((Object)this.m_attrs, (Object)columnUsage.m_attrs) && this.m_outerJoin == columnUsage.m_outerJoin;
    }

    protected void copyToImpl(ColumnUsage columnUsage, boolean bl) {
        super.copyToImpl(columnUsage, bl);
        columnUsage.m_id = this.m_id;
        columnUsage.m_outerJoin = this.m_outerJoin;
        if (this.m_attrs == null) {
            columnUsage.m_attrs = null;
        } else {
            columnUsage.m_attrs = new String[this.m_attrs.length];
            System.arraycopy(this.m_attrs, 0, columnUsage.m_attrs, 0, this.m_attrs.length);
        }
        columnUsage.m_pro = this.m_pro;
    }

    @Override
    public void setProvider(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        super.getReferenceIDsImpl(collection);
        if (this.m_id != null) {
            collection.add(this.m_id);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> map) {
        if (this.m_id != null && map.containsKey(this.m_id)) {
            this.m_id = map.get(this.m_id);
            return true;
        }
        return super.replaceReferenceIDs(map);
    }
}

