/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class Comparison
extends Operation {
    private static final SQLFragment[] EMPTY_ARG = new SQLFragment[2];
    private int m_comp;
    public static final int GREATER = 1;
    public static final int LESS = 2;
    public static final int GREATER_EQUAL = 3;
    public static final int LESS_EQUAL = 4;
    public static final int EQUAL = 5;
    public static final int NOT_EQUAL = 6;
    public static final int NULL = 43;
    public static final int NOT_NULL = 44;
    public static final int LIKE = 26;
    public static final int NOT_LIKE = 27;
    private static Map s_operators = new HashMap();

    static {
        s_operators.put(new Integer(1), ">");
        s_operators.put(new Integer(2), "<");
        s_operators.put(new Integer(3), ">=");
        s_operators.put(new Integer(4), "<=");
        s_operators.put(new Integer(5), "=");
        s_operators.put(new Integer(6), "!=");
        s_operators.put(new Integer(43), "IS NULL");
        s_operators.put(new Integer(44), "IS NOT NULL");
        s_operators.put(new Integer(26), "LIKE");
        s_operators.put(new Integer(27), "NOT LIKE");
    }

    void $init$() {
        this.m_comp = 5;
    }

    public Comparison() {
        super(EMPTY_ARG);
        this.$init$();
        this.setFunctionFormat(false);
    }

    public Comparison(SQLFragment sQLFragment, int n) {
        this();
        this.setLeftExpression(sQLFragment);
        this.setComparator(n);
    }

    public Comparison(SQLFragment sQLFragment, int n, SQLFragment sQLFragment2) {
        this();
        this.setLeftExpression(sQLFragment);
        this.setRightExpression(sQLFragment2);
        this.setComparator(n);
    }

    public int getComparator() {
        return this.m_comp;
    }

    public String getOperatorText() {
        return Comparison.getComparatorText(this.m_comp);
    }

    public void setComparator(int n) {
        if (Comparison.getComparatorText(n) == null) {
            throw new IllegalArgumentException(DBArb.format(11, String.valueOf(n)));
        }
        this.m_comp = n;
    }

    public SQLFragment getLeftExpression() {
        return this.getArguments()[0];
    }

    public void setLeftExpression(SQLFragment sQLFragment) {
        this.setArgument(0, sQLFragment);
    }

    public SQLFragment getRightExpression() {
        return this.getArguments()[1];
    }

    public void setRightExpression(SQLFragment sQLFragment) {
        this.setArgument(1, sQLFragment);
    }

    protected void checkNewSize(int n) {
        if (n != 2) {
            throw new IllegalArgumentException(DBArb.getString(10));
        }
    }

    public String getSQLText() {
        if (this.m_comp == 43 || this.m_comp == 44) {
            return this.getTextOrNull(this.getArguments()[0]) + " " + Comparison.getComparatorText(this.m_comp);
        }
        return super.getSQLText();
    }

    public boolean equals(Object object) {
        return object instanceof Comparison && this.equalsImpl((Comparison)object);
    }

    protected boolean equalsImpl(Comparison comparison) {
        return super.equalsImpl(comparison) && comparison.m_comp == this.m_comp;
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        Comparison comparison = dBObject == null ? new Comparison() : (Comparison)dBObject;
        this.copyToImpl(comparison, bl);
        return comparison;
    }

    protected void copyToImpl(Comparison comparison, boolean bl) {
        super.copyToImpl(comparison, bl);
        comparison.m_comp = this.m_comp;
    }

    public static boolean isComparator(int n) {
        return s_operators.containsKey(new Integer(n));
    }

    public static String getComparatorText(int n) {
        return (String)s_operators.get(new Integer(n));
    }
}

