/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FKUsage
extends AbstractSQLFragment
implements DBObjectUsage {
    private DBObjectID m_fkID;
    private FromObject m_left;
    private FromObject m_right;
    private transient DBObjectProvider m_pro;

    public FKUsage() {
    }

    public FKUsage(DBObjectID dBObjectID, FromObject fromObject, FromObject fromObject2) {
        this.m_fkID = dBObjectID;
        this.m_left = fromObject;
        this.m_right = fromObject2;
    }

    @Override
    public DBObjectID getObjectID() {
        return this.m_fkID;
    }

    @Override
    public void setObjectID(DBObjectID dBObjectID) {
        this.m_fkID = dBObjectID;
    }

    public DBObjectID getFKID() {
        return null;
    }

    public void setFKID(DBObjectID dBObjectID) {
        if (dBObjectID != null) {
            this.setObjectID(dBObjectID);
        }
    }

    public FromObject getLeftFromObject() {
        return this.m_left;
    }

    public void setLeftFromObject(FromObject fromObject) {
        this.m_left = fromObject;
    }

    public FromObject getRightFromObject() {
        return this.m_right;
    }

    public void setRightFromObject(FromObject fromObject) {
        this.m_right = fromObject;
    }

    @Override
    public String getSQLText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_fkID != null) {
            try {
                FKConstraint fKConstraint = (FKConstraint)this.m_fkID.resolveID();
                if (fKConstraint == null) {
                    DBUtil.getLog().trace("FKUsage: Cannot resolve id " + this.m_fkID);
                } else {
                    DBObjectID dBObjectID = fKConstraint.getReferenceID();
                    UniqueConstraint uniqueConstraint = (UniqueConstraint)dBObjectID.resolveID();
                    if (uniqueConstraint == null) {
                        DBUtil.getLog().trace("FKUsage: Cannot resolve referenced id " + this.m_fkID + " on fk " + fKConstraint.getName());
                    } else {
                        DBObjectID dBObjectID2 = uniqueConstraint.getRelation().getID();
                        DBObjectID dBObjectID3 = this.m_left.getExpression() instanceof RelationUsage ? ((RelationUsage)this.m_left.getExpression()).getObjectID() : null;
                        Column[] columnArray = fKConstraint.getColumns();
                        Column[] columnArray2 = uniqueConstraint.getColumns();
                        if (dBObjectID3 != null && dBObjectID2 != null && dBObjectID3.equals(dBObjectID2)) {
                            columnArray = uniqueConstraint.getColumns();
                            columnArray2 = fKConstraint.getColumns();
                        }
                        int n = 0;
                        while (n < columnArray.length) {
                            stringBuffer.append(this.m_left.getName());
                            stringBuffer.append(".");
                            String string = columnArray[n].getName();
                            if (this.m_pro != null) {
                                string = this.m_pro.getExternalName(string);
                            }
                            stringBuffer.append(string);
                            stringBuffer.append(" ");
                            stringBuffer.append(Comparison.getComparatorText(5));
                            stringBuffer.append(" ");
                            stringBuffer.append(this.m_right.getName());
                            stringBuffer.append(".");
                            String string2 = columnArray2[n].getName();
                            if (this.m_pro != null) {
                                string2 = this.m_pro.getExternalName(string2);
                            }
                            stringBuffer.append(string2);
                            if (n < columnArray.length - 1) {
                                stringBuffer.append(" ");
                                stringBuffer.append(WhereObject.getOperatorText(372));
                                stringBuffer.append(" ");
                            }
                            ++n;
                        }
                    }
                }
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
        } else {
            stringBuffer.append(this.m_fkID);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return object instanceof FKUsage && this.equalsImpl((FKUsage)object);
    }

    protected boolean equalsImpl(FKUsage fKUsage) {
        return super.equalsImpl(fKUsage) && ModelUtil.areEqual((Object)this.m_fkID, (Object)fKUsage.m_fkID) && ModelUtil.areEqual((Object)this.m_left, (Object)fKUsage.m_left) && ModelUtil.areEqual((Object)this.m_right, (Object)fKUsage.m_right);
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        FKUsage fKUsage = dBObject == null ? new FKUsage() : (FKUsage)dBObject;
        this.copyToImpl(fKUsage, bl);
        return fKUsage;
    }

    protected void copyToImpl(FKUsage fKUsage, boolean bl) {
        super.copyToImpl(fKUsage, bl);
        fKUsage.m_fkID = this.m_fkID;
        fKUsage.m_left = this.m_left;
        fKUsage.m_right = this.m_right;
        fKUsage.m_pro = this.m_pro;
    }

    @Override
    public void setProvider(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        super.getReferenceIDsImpl(collection);
        if (this.m_fkID != null) {
            collection.add(this.m_fkID);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> map) {
        if (this.m_fkID != null && map.containsKey(this.m_fkID)) {
            this.m_fkID = map.get(this.m_fkID);
            return true;
        }
        return super.replaceReferenceIDs(map);
    }
}

