/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class Function
extends Operation {
    private String m_func;
    private boolean m_grouping;

    public Function() {
        this.setFunctionFormat(true);
    }

    public Function(String string, SQLFragment[] sQLFragmentArray) {
        super(sQLFragmentArray);
        this.setFunction(string);
    }

    public Function(String string, SQLFragment[] sQLFragmentArray, String string2) {
        super(sQLFragmentArray);
        this.setFunction(string);
        this.setSeparator(string2);
    }

    public Function(String string, SQLFragment[] sQLFragmentArray, boolean bl) {
        super(sQLFragmentArray);
        this.setFunction(string);
        this.setGrouping(bl);
    }

    public Function(String string, SQLFragment[] sQLFragmentArray, String string2, boolean bl) {
        super(sQLFragmentArray);
        this.setFunction(string);
        this.setSeparator(string2);
        this.setGrouping(bl);
    }

    public String getFunction() {
        return this.m_func;
    }

    public void setFunction(String string) {
        if (this.isSymbolFunction(string)) {
            this.setFunctionFormat(false);
            this.setSeparator(null);
            this.setCommutative(true);
        } else {
            this.setFunctionFormat(true);
        }
        this.m_func = string;
    }

    public boolean isGrouping() {
        return this.m_grouping;
    }

    public void setGrouping(boolean bl) {
        this.m_grouping = bl;
    }

    protected String getOperatorText() {
        return this.getFunction();
    }

    public boolean equals(Object object) {
        return object instanceof Function && this.equalsImpl((Function)object);
    }

    protected boolean equalsImpl(Function function) {
        return super.equalsImpl(function) && ModelUtil.areEqual((Object)function.m_func, (Object)this.m_func);
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        Function function = dBObject == null ? new Function() : (Function)dBObject;
        this.copyToImpl(function, bl);
        return function;
    }

    protected void copyToImpl(Function function, boolean bl) {
        super.copyToImpl(function, bl);
        function.m_func = this.m_func;
        function.m_grouping = this.m_grouping;
    }

    private boolean isSymbolFunction(String string) {
        int n = 0;
        while (n < string.length()) {
            if (Character.isLetterOrDigit(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getSeparator() {
        return super.getSeparator();
    }

    public void setSeparator(String string) {
        super.setSeparator(string);
    }
}

