/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

public class FunctionDefinition
implements Comparable {
    private String m_name;
    private int m_minargs;
    private int m_maxargs;
    private String m_desc;
    private String m_sql;
    private boolean m_group;

    public FunctionDefinition(String string, int n, String string2) {
        this(string, n, n, string2, false);
    }

    public FunctionDefinition(String string, int n, String string2, boolean bl) {
        this(string, n, n, string2, bl);
    }

    public FunctionDefinition(String string, int n, int n2, String string2) {
        this(string, n, n2, string2, false);
    }

    public FunctionDefinition(String string, int n, int n2, String string2, boolean bl) {
        this.m_name = string;
        this.m_minargs = n;
        this.m_maxargs = n2;
        this.m_desc = string2;
        this.m_group = bl;
    }

    public String getName() {
        return this.m_name;
    }

    public int getMaxArgs() {
        return this.m_maxargs;
    }

    public int getMinArgs() {
        return this.m_minargs;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public boolean isGrouping() {
        return this.m_group;
    }

    public String getSQLText() {
        if (this.m_sql == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_name);
            if (this.m_minargs > 0) {
                stringBuffer.append("(");
                int n = 1;
                while (n < this.m_minargs) {
                    stringBuffer.append(",");
                    ++n;
                }
                stringBuffer.append(")");
            }
            this.m_sql = stringBuffer.toString();
        }
        return this.m_sql;
    }

    public String toString() {
        return this.getSQLText();
    }

    public int compareTo(Object object) {
        return this.m_name.compareTo(((FunctionDefinition)object).getName());
    }
}

