/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByObject
extends AbstractSQLFragment {
    public static final String TYPE = "GROUP BY";
    private List m_exps;
    private WhereObject m_having;

    public GroupByObject() {
    }

    public GroupByObject(FromObjectUsage[] fromObjectUsageArray) {
        this.setExpressions(fromObjectUsageArray);
    }

    public GroupByObject(FromObjectUsage[] fromObjectUsageArray, WhereObject whereObject) {
        this.setExpressions(fromObjectUsageArray);
        this.m_having = whereObject;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setHaving(WhereObject whereObject) {
        this.changeParent(this.m_having, whereObject);
        this.m_having = whereObject;
    }

    public WhereObject getHaving() {
        return this.m_having;
    }

    public FromObjectUsage[] getExpressions() {
        return this.m_exps == null ? new FromObjectUsage[]{} : this.m_exps.toArray(new FromObjectUsage[this.m_exps.size()]);
    }

    public void setExpressions(FromObjectUsage[] fromObjectUsageArray) {
        if (this.m_exps != null) {
            this.setParents(this.m_exps, null);
            this.m_exps.clear();
        }
        if (fromObjectUsageArray != null) {
            if (this.m_exps == null) {
                this.m_exps = new ArrayList();
            }
            int n = 0;
            while (n < fromObjectUsageArray.length) {
                fromObjectUsageArray[n].setParent(this);
                this.m_exps.add(fromObjectUsageArray[n]);
                ++n;
            }
        }
    }

    public void addExpression(FromObjectUsage fromObjectUsage) {
        if (this.m_exps == null) {
            this.m_exps = new ArrayList();
        }
        this.m_exps.add(fromObjectUsage);
        fromObjectUsage.setParent(this);
    }

    public void addExpression(int n, FromObjectUsage fromObjectUsage) {
        if (this.m_exps == null) {
            this.m_exps = new ArrayList();
        }
        this.m_exps.add(n, fromObjectUsage);
        fromObjectUsage.setParent(this);
    }

    public boolean removeExpression(FromObjectUsage fromObjectUsage) {
        if (this.m_exps != null && this.m_exps.remove(fromObjectUsage)) {
            this.removeParent(fromObjectUsage);
            return true;
        }
        return false;
    }

    public void moveExpression(FromObjectUsage fromObjectUsage, int n) {
        int n2;
        if (fromObjectUsage != null && this.m_exps.contains(fromObjectUsage) && (n2 = this.m_exps.indexOf(fromObjectUsage)) != n) {
            this.m_exps.remove(fromObjectUsage);
            this.m_exps.add(n, fromObjectUsage);
        }
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this.includesType(TYPE, stringArray)) {
            if (this.m_exps != null) {
                collection.addAll(this.m_exps);
            }
            if (this.m_having != null) {
                collection.add(this.m_having);
            }
        }
    }

    @Override
    public String getSQLText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TYPE).append(" ").append("\n");
        this.appendToBuffer(stringBuffer, this.m_exps, "    ");
        if (this.m_having != null) {
            stringBuffer.append(" ").append("\n");
            stringBuffer.append("HAVING").append(" ").append("\n");
            stringBuffer.append("    ").append(this.m_having.getSQLText());
        }
        return stringBuffer.toString();
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        GroupByObject groupByObject = dBObject != null ? (GroupByObject)dBObject : new GroupByObject();
        this.copyToImpl(groupByObject, bl);
        return groupByObject;
    }

    protected void copyToImpl(GroupByObject groupByObject, boolean bl) {
        super.copyToImpl(groupByObject, bl);
        groupByObject.setHaving(this.m_having == null ? null : (WhereObject)this.m_having.copyTo(null, groupByObject, bl));
        if (this.m_exps == null) {
            groupByObject.setExpressions(null);
        } else {
            groupByObject.m_exps = new ArrayList();
            this.copyList(this.m_exps, groupByObject.m_exps, groupByObject, bl);
        }
    }

    public boolean equals(Object object) {
        return object instanceof GroupByObject && this.equalsImpl((GroupByObject)object);
    }

    protected boolean equalsImpl(GroupByObject groupByObject) {
        return super.equalsImpl(groupByObject) && ModelUtil.areEqual((Object)groupByObject.m_having, (Object)this.m_having) && ModelUtil.areEqual((Object)groupByObject.m_exps, (Object)this.m_exps);
    }
}

