/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexObject
extends AbstractSQLFragment {
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    private String m_order;
    private SQLFragment m_exp;

    public IndexObject() {
    }

    public IndexObject(SQLFragment sQLFragment) {
        this.setExpression(sQLFragment);
    }

    public IndexObject(SQLFragment sQLFragment, String string) {
        this.setExpression(sQLFragment);
        this.setOrder(string);
    }

    public String getOrder() {
        return this.m_order;
    }

    public void setOrder(String string) {
        if (string != null && !string.equals(ASC) && !string.equals(DESC)) {
            throw new IllegalArgumentException(DBArb.format(12, string));
        }
        this.m_order = string;
    }

    public SQLFragment getExpression() {
        return this.m_exp;
    }

    public void setExpression(SQLFragment sQLFragment) {
        this.changeParent(this.m_exp, sQLFragment);
        this.m_exp = sQLFragment;
    }

    @Override
    public String getSQLText() {
        return this.getTextOrNull(this.m_exp) + (this.m_order == null ? "" : " " + this.m_order);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this.includesType("SQLFragment", stringArray) && this.m_exp != null) {
            collection.add(this.m_exp);
        }
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        IndexObject indexObject = dBObject != null ? (IndexObject)dBObject : new IndexObject();
        this.copyToImpl(indexObject, bl);
        return indexObject;
    }

    protected void copyToImpl(IndexObject indexObject, boolean bl) {
        super.copyToImpl(indexObject, bl);
        indexObject.m_exp = (SQLFragment)this.m_exp.copyTo(null, bl);
        indexObject.m_order = this.m_order;
    }

    protected boolean equalsImpl(IndexObject indexObject) {
        return super.equalsImpl(indexObject) && ModelUtil.areEqual((Object)this.m_exp, (Object)indexObject.m_exp) && ModelUtil.areEqual((Object)this.m_order, (Object)indexObject.m_order);
    }

    public boolean equals(Object object) {
        return object instanceof IndexObject && this.equalsImpl((IndexObject)object);
    }
}

