/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinObject
extends AbstractSQLFragment {
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String FULL = "FULL";
    public static final String INNER = "INNER";
    public static final String CROSS = "CROSS";
    private FromObject m_left;
    private FromObject m_right;
    private JoinCondition m_condition;
    private String m_type;
    private boolean m_incKeyword;
    private boolean m_natural;

    void $init$() {
        this.m_type = INNER;
        this.m_incKeyword = true;
    }

    public JoinObject() {
        this.$init$();
    }

    public JoinObject(FromObject fromObject, FromObject fromObject2, JoinCondition joinCondition) {
        this.$init$();
        this.setLeftExpression(fromObject);
        this.setRightExpression(fromObject2);
        this.setCondition(joinCondition);
    }

    public JoinObject(FromObject fromObject, FromObject fromObject2, String string, boolean bl, JoinCondition joinCondition) {
        this.$init$();
        this.setLeftExpression(fromObject);
        this.setRightExpression(fromObject2);
        this.setJoinType(string);
        this.setNatural(bl);
        this.setCondition(joinCondition);
    }

    public FromObject getLeftExpression() {
        return this.m_left;
    }

    public void setLeftExpression(FromObject fromObject) {
        this.changeParent(this.m_left, fromObject);
        this.m_left = fromObject;
    }

    public FromObject getRightExpression() {
        return this.m_right;
    }

    public void setRightExpression(FromObject fromObject) {
        this.changeParent(this.m_right, fromObject);
        this.m_right = fromObject;
    }

    public boolean getIncludeJoinKeyword() {
        return this.m_incKeyword;
    }

    public void setIncludeJoinKeyword(boolean bl) {
        this.m_incKeyword = bl;
    }

    public String getJoinType() {
        return this.m_type;
    }

    public void setJoinType(String string) {
        this.m_type = string;
    }

    public boolean isNatural() {
        return this.m_natural;
    }

    public void setNatural(boolean bl) {
        if (CROSS.equals(this.m_type) && bl) {
            DBUtil.logStackTrace(new SQLQueryException(DBArb.getString(41)));
        }
        this.m_natural = bl;
    }

    public JoinCondition getCondition() {
        return this.m_condition;
    }

    public void setCondition(JoinCondition joinCondition) {
        if ((this.m_natural || CROSS.equals(this.m_type)) && joinCondition != null) {
            DBUtil.logStackTrace(new SQLQueryException(DBArb.getString(42)));
        } else {
            this.changeParent(this.m_condition, joinCondition);
            this.m_condition = joinCondition;
        }
    }

    public boolean isOuterJoin() {
        return this.m_type != null && !this.m_type.equals(INNER) && !this.m_type.equals(CROSS);
    }

    @Override
    public String getSQLText() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = this.m_left != null && this.m_left.getExpression() instanceof JoinObject;
        if (bl) {
            stringBuffer.append("(");
        }
        stringBuffer.append(this.getTextOrNull(this.m_left));
        if (bl) {
            stringBuffer.append(")");
        }
        if (this.m_natural) {
            stringBuffer.append(" ").append("NATURAL");
        }
        if (INNER.equals(this.m_type)) {
            if (this.m_incKeyword) {
                stringBuffer.append(" ").append(this.m_type);
            }
        } else if (CROSS.equals(this.m_type)) {
            stringBuffer.append(" ").append(CROSS);
            if (this.m_incKeyword) {
                stringBuffer.append(" ").append(INNER);
            }
        } else if (this.isOuterJoin()) {
            stringBuffer.append(" ").append(this.m_type);
            if (this.m_incKeyword) {
                stringBuffer.append(" ").append("OUTER");
            }
        }
        stringBuffer.append(" ").append("JOIN");
        stringBuffer.append(" ");
        boolean bl3 = bl = this.m_right != null && this.m_right.getExpression() instanceof JoinObject;
        if (bl) {
            stringBuffer.append("(");
        }
        stringBuffer.append(this.getTextOrNull(this.m_right));
        if (bl) {
            stringBuffer.append(")");
        }
        if (this.m_condition != null && !this.m_natural) {
            stringBuffer.append(" ").append(this.m_condition.getSQLText());
        }
        return stringBuffer.toString();
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        boolean bl = this.includesType("SQLFragment", stringArray);
        if (bl || this.includesType("FROM", stringArray)) {
            if (this.m_left != null) {
                collection.add(this.m_left);
            }
            if (this.m_right != null) {
                collection.add(this.m_right);
            }
        }
        if (this.m_condition != null && (bl || this.includesType(this.m_condition.getType(), stringArray))) {
            collection.add(this.m_condition);
        }
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        JoinObject joinObject = dBObject == null ? new JoinObject() : (JoinObject)dBObject;
        this.copyToImpl(joinObject, bl);
        return joinObject;
    }

    protected void copyToImpl(JoinObject joinObject, boolean bl) {
        super.copyToImpl(joinObject, bl);
        joinObject.m_incKeyword = this.m_incKeyword;
        joinObject.m_natural = this.m_natural;
        joinObject.m_type = this.m_type;
        joinObject.setLeftExpression(this.m_left == null ? null : (FromObject)this.m_left.copyTo(null, joinObject, bl));
        joinObject.setRightExpression(this.m_right == null ? null : (FromObject)this.m_right.copyTo(null, joinObject, bl));
        joinObject.setCondition(this.m_condition == null ? null : (JoinCondition)this.m_condition.copyTo(null, bl));
    }

    protected boolean equalsImpl(JoinObject joinObject) {
        return super.equalsImpl(joinObject) && this.m_incKeyword == joinObject.m_incKeyword && this.m_natural == joinObject.m_natural && ModelUtil.areEqual((Object)this.m_type, (Object)joinObject.m_type) && ModelUtil.areEqual((Object)this.m_left, (Object)joinObject.m_left) && ModelUtil.areEqual((Object)this.m_right, (Object)joinObject.m_right) && ModelUtil.areEqual((Object)this.m_condition, (Object)joinObject.m_condition);
    }

    public boolean equals(Object object) {
        return object instanceof JoinObject && this.equalsImpl((JoinObject)object);
    }
}

