/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operation
extends AbstractSQLFragment {
    protected static final String DEFAULT_SEPARATOR = ", ";
    private List m_args;
    private String m_separator;
    private boolean m_funcFormat;
    private boolean m_commutative;

    void $init$() {
        this.m_separator = DEFAULT_SEPARATOR;
    }

    public Operation() {
        this.$init$();
    }

    public Operation(SQLFragment[] sQLFragmentArray) {
        this.$init$();
        this.setArguments(sQLFragmentArray);
    }

    protected void setFunctionFormat(boolean bl) {
        this.m_funcFormat = bl;
    }

    protected void setCommutative(boolean bl) {
        this.m_commutative = bl;
    }

    public SQLFragment[] getArguments() {
        if (this.m_args == null) {
            return AbstractSQLFragment.EMPTY_ARRAY;
        }
        return this.m_args.toArray(new SQLFragment[this.m_args.size()]);
    }

    public void setArguments(SQLFragment[] sQLFragmentArray) {
        this.checkNewSize(sQLFragmentArray.length);
        if (this.m_args != null) {
            this.setParents(this.m_args, null);
            this.m_args.clear();
        }
        if (sQLFragmentArray != null) {
            if (this.m_args == null) {
                this.m_args = new ArrayList();
            }
            int n = 0;
            while (n < sQLFragmentArray.length) {
                if (sQLFragmentArray[n] != null) {
                    sQLFragmentArray[n].setParent(this);
                }
                this.m_args.add(sQLFragmentArray[n]);
                ++n;
            }
        }
    }

    public void addArgument(SQLFragment sQLFragment) {
        if (this.m_args == null) {
            this.m_args = new ArrayList();
        }
        this.checkNewSize(this.m_args.size() + 1);
        this.m_args.add(sQLFragment);
        if (sQLFragment != null) {
            sQLFragment.setParent(this);
        }
    }

    public void addArgument(int n, SQLFragment sQLFragment) {
        if (this.m_args == null) {
            this.m_args = new ArrayList();
        }
        this.checkNewSize(this.m_args.size() + 1);
        this.m_args.add(n, sQLFragment);
        if (sQLFragment != null) {
            sQLFragment.setParent(this);
        }
    }

    public void addArguments(SQLFragment[] sQLFragmentArray) {
        if (this.m_args == null) {
            this.m_args = new ArrayList();
        }
        this.checkNewSize(this.m_args.size() + sQLFragmentArray.length);
        int n = 0;
        while (sQLFragmentArray != null && n < sQLFragmentArray.length) {
            sQLFragmentArray[n].setParent(this);
            this.m_args.add(sQLFragmentArray[n]);
            ++n;
        }
    }

    public void setArgument(int n, SQLFragment sQLFragment) {
        if (this.m_args == null || this.m_args.size() <= n) {
            throw new IndexOutOfBoundsException(n + " too big");
        }
        SQLFragment sQLFragment2 = (SQLFragment)this.m_args.get(n);
        this.changeParent(sQLFragment2, sQLFragment);
        this.m_args.set(n, sQLFragment);
    }

    public boolean removeArgument(SQLFragment sQLFragment) {
        if (this.m_args.contains(sQLFragment)) {
            this.checkNewSize(this.m_args.size() - 1);
            this.removeParent(sQLFragment);
            this.m_args.remove(sQLFragment);
            return true;
        }
        return false;
    }

    protected void checkNewSize(int n) {
    }

    public int getArgumentCount() {
        return this.m_args.size();
    }

    protected abstract String getOperatorText();

    protected void setSeparator(String string) {
        this.m_separator = !ModelUtil.hasLength((String)string) ? null : string;
    }

    protected String getSeparator() {
        return this.m_separator;
    }

    @Override
    public String getSQLText() {
        String string = this.getSeparator();
        if (this.m_funcFormat) {
            return this.getOperatorText() + "(" + this.argsToString(string, 0) + ")";
        }
        if (string == null) {
            return this.argsToString(" " + this.getOperatorText() + " ", 0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_args.size() > 0) {
            boolean bl = ModelUtil.areEqual((Object)string, (Object)DEFAULT_SEPARATOR) && this.m_args.size() > 2;
            stringBuffer.append(this.m_args.get(0));
            stringBuffer.append(" ").append(this.getOperatorText()).append(" ");
            if (bl) {
                stringBuffer.append("(");
            }
            stringBuffer.append(this.argsToString(string, 1));
            if (bl) {
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        boolean bl = this.includesType("SQLFragment", stringArray);
        int n = 0;
        while (this.m_args != null && n < this.m_args.size()) {
            DBObject dBObject = (DBObject)this.m_args.get(n);
            if (dBObject != null && (bl || this.includesType(dBObject.getType(), stringArray))) {
                collection.add(dBObject);
            }
            ++n;
        }
    }

    private String argsToString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_args != null) {
            int n2 = 0;
            Iterator iterator = this.m_args.iterator();
            while (iterator.hasNext()) {
                SQLFragment sQLFragment = (SQLFragment)iterator.next();
                if (n2++ < n) continue;
                if (!this.m_commutative && (sQLFragment == null || sQLFragment.getClass().equals(this.getClass()))) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.getTextOrNull(sQLFragment));
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(this.getTextOrNull(sQLFragment));
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    protected boolean equalsImpl(Operation operation) {
        return super.equalsImpl(operation) && ModelUtil.areEqual((Object)operation.m_args, (Object)this.m_args);
    }

    protected void copyToImpl(Operation operation, boolean bl) {
        super.copyToImpl(operation, bl);
        operation.m_funcFormat = this.m_funcFormat;
        operation.m_commutative = this.m_commutative;
        operation.m_separator = this.m_separator;
        if (this.m_args != null) {
            operation.m_args = new ArrayList();
            this.copyList(this.m_args, operation.m_args, operation, bl);
        }
    }
}

