/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByObject
extends AbstractSQLFragment {
    public static final String TYPE = "ORDER BY";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final String NULLS_FIRST = "NULLS FIRST";
    public static final String NULLS_LAST = "NULLS LAST";
    private String m_order;
    private SQLFragment m_exp;
    private String m_null;

    public OrderByObject() {
    }

    public OrderByObject(SQLFragment sQLFragment) {
        this.setExpression(sQLFragment);
    }

    public OrderByObject(SQLFragment sQLFragment, String string) {
        this.setExpression(sQLFragment);
        this.setOrder(string);
    }

    public OrderByObject(SQLFragment sQLFragment, String string, String string2) {
        this.setExpression(sQLFragment);
        this.setOrder(string);
        this.setNullOrdering(string2);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getOrder() {
        return this.m_order;
    }

    public void setOrder(String string) {
        if (ModelUtil.hasLength((String)string) && !string.equalsIgnoreCase(ASC) && !string.equalsIgnoreCase(DESC)) {
            throw new IllegalArgumentException(DBArb.format(12, string));
        }
        this.m_order = string;
    }

    public String getNullOrdering() {
        return this.m_null;
    }

    public void setNullOrdering(String string) {
        if (ModelUtil.hasLength((String)string)) {
            string = string.replaceAll("\\s+", " ");
        }
        if (ModelUtil.hasLength((String)string) && !string.equalsIgnoreCase(NULLS_FIRST) && !string.equalsIgnoreCase(NULLS_LAST)) {
            throw new IllegalArgumentException(DBArb.format(13, string));
        }
        this.m_null = string;
    }

    public SQLFragment getExpression() {
        return this.m_exp;
    }

    public void setExpression(SQLFragment sQLFragment) {
        this.changeParent(this.m_exp, sQLFragment);
        this.m_exp = sQLFragment;
    }

    @Override
    public String getSQLText() {
        return this.getTextOrNull(this.m_exp) + (this.m_order == null ? "" : " " + this.m_order) + (this.m_null == null ? "" : " " + this.m_null);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this.m_exp != null && (this.includesType(TYPE, stringArray) || this.includesType(this.m_exp.getType(), stringArray))) {
            collection.add(this.m_exp);
        }
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        OrderByObject orderByObject = dBObject != null ? (OrderByObject)dBObject : new OrderByObject();
        this.copyToImpl(orderByObject, bl);
        return orderByObject;
    }

    protected void copyToImpl(OrderByObject orderByObject, boolean bl) {
        super.copyToImpl(orderByObject, bl);
        orderByObject.setExpression((SQLFragment)this.m_exp.copyTo(null, bl));
        orderByObject.m_order = this.m_order;
        orderByObject.m_null = this.m_null;
    }

    protected boolean equalsImpl(OrderByObject orderByObject) {
        return super.equalsImpl(orderByObject) && ModelUtil.areEqual((Object)this.m_exp, (Object)orderByObject.m_exp) && ModelUtil.areEqual((Object)this.m_order, (Object)orderByObject.m_order) && ModelUtil.areEqual((Object)this.m_null, (Object)orderByObject.m_null);
    }

    public boolean equals(Object object) {
        return object instanceof OrderByObject && this.equalsImpl((OrderByObject)object);
    }
}

