/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.SqlExpression;
import oracle.javatools.parser.plsql.symtab.SqlOpndef;
import oracle.javatools.parser.plsql.symtab.SqlStrdef;
import oracle.javatools.parser.plsql.syntax.SqlDriver;

public class ParserUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    private ParserUtils() {
    }

    public static boolean isAllowedExpression(PlsqlNode plsqlNode, List list) {
        return plsqlNode instanceof SqlExpression && list.contains(new Integer(((SqlExpression)plsqlNode).getOperatorType()));
    }

    public static boolean isAllowedStringType(PlsqlNode plsqlNode, List list) {
        return plsqlNode instanceof SqlStrdef && list.contains(new Integer(((SqlStrdef)plsqlNode).getStringType()));
    }

    public static boolean isConstant(PlsqlNode plsqlNode) {
        return plsqlNode instanceof SqlStrdef && ((SqlStrdef)plsqlNode).getStringType() == 0;
    }

    public static boolean isNull(PlsqlNode plsqlNode) {
        return plsqlNode instanceof SqlOpndef && ((SqlOpndef)plsqlNode).getOperandType() == 3 && ((SqlOpndef)plsqlNode).getStringType() == 8;
    }

    public static boolean isDbObjectName(PlsqlNode plsqlNode) {
        return plsqlNode instanceof SqlOpndef && (((SqlOpndef)plsqlNode).getOperandType() == 1 || ((SqlOpndef)plsqlNode).getOperandType() == 7);
    }

    public static String getConstant(PlsqlNode plsqlNode) {
        return ParserUtils.isConstant(plsqlNode) ? ((SqlStrdef)plsqlNode).getStringText() : null;
    }

    static {
        $assertionsDisabled = ParserUtils.class.desiredAssertionStatus() ^ true;
    }

    public static Collection getColumnNames(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            PlsqlRoot plsqlRoot = ParserUtils.parseQueryString(string, 2);
            PlsqlNode[] plsqlNodeArray = plsqlRoot.getUnits();
            if (!$assertionsDisabled && plsqlNodeArray.length != 1) {
                throw new AssertionError((Object)"Invalid expression parse");
            }
            for (String string2 : ParserUtils.getColumnNames((SqlExpression)plsqlNodeArray[0])) {
                if ('\"' == string2.charAt(0)) {
                    hashSet.add(string2);
                    continue;
                }
                hashSet.add(string2.toUpperCase());
            }
        }
        catch (SQLQueryException sQLQueryException) {
            DBUtil.getLog().trace("Unexpected parse error: " + sQLQueryException.getMessage());
        }
        return hashSet;
    }

    public static void checkErrors(PlsqlRoot plsqlRoot, String string) throws SQLQueryException {
        PlsqlError[] plsqlErrorArray = plsqlRoot.getErrors();
        if (plsqlErrorArray != null && plsqlErrorArray.length > 0) {
            throw new SQLParseException(plsqlErrorArray, string);
        }
    }

    public static Collection getColumnNames(SqlExpression sqlExpression) {
        HashSet<String> hashSet = new HashSet<String>();
        SqlExpression[] sqlExpressionArray = sqlExpression.getOperands();
        int n = 0;
        while (n < sqlExpressionArray.length) {
            if (sqlExpressionArray[n] != null) {
                hashSet.addAll(ParserUtils.getColumnNames(sqlExpressionArray[n]));
            }
            ++n;
        }
        if (sqlExpression.getColumnBaseName() != null) {
            hashSet.add(sqlExpression.getColumnBaseName());
        }
        return hashSet;
    }

    public static PlsqlRoot parseQueryString(String string, int n) throws SQLQueryException {
        try {
            ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)string);
            PlsqlParser.ParsingOptions parsingOptions = new PlsqlParser.ParsingOptions();
            parsingOptions.inputType = 16;
            SqlDriver sqlDriver = new SqlDriver();
            sqlDriver.setTextBuffer(readTextBuffer);
            PlsqlRoot plsqlRoot = sqlDriver.qcpidrv(n);
            return plsqlRoot;
        }
        catch (Exception exception) {
            throw new SQLQueryException(DBArb.format(21, exception.getMessage()));
        }
    }
}

