/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleSQLQueryBuilder;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;

public class SQLQueryBuilderFactory {
    private SQLQueryBuilderFactory() {
    }

    public static SQLQuery createQuery(DBObjectProvider dBObjectProvider, Schema schema, String string) throws SQLParseException {
        try {
            SQLQueryBuilder sQLQueryBuilder = SQLQueryBuilderFactory.createBuilder(dBObjectProvider, schema, string);
            DeclarativeSQLQuery declarativeSQLQuery = sQLQueryBuilder.getSQLQuery();
            return declarativeSQLQuery;
        }
        catch (SQLQueryException sQLQueryException) {
            if (sQLQueryException instanceof SQLParseException) {
                throw (SQLParseException)sQLQueryException;
            }
            DBUtil.getLog().trace("SQLQueryBuilderFactory cannot build SQL: " + sQLQueryException.getMessage());
            NonDeclarativeSQLQuery nonDeclarativeSQLQuery = new NonDeclarativeSQLQuery(string);
            return nonDeclarativeSQLQuery;
        }
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider dBObjectProvider) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromText(dBObjectProvider, null, null);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider dBObjectProvider, Schema schema) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromText(dBObjectProvider, schema, null);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider dBObjectProvider, SQLQuery sQLQuery) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromQuery(dBObjectProvider, null, sQLQuery);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider dBObjectProvider, Schema schema, SQLQuery sQLQuery) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromQuery(dBObjectProvider, schema, sQLQuery);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider dBObjectProvider, String string) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromText(dBObjectProvider, null, string);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider dBObjectProvider, Schema schema, String string) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromText(dBObjectProvider, schema, string);
    }

    private static SQLQueryBuilder createBuilderFromText(DBObjectProvider dBObjectProvider, Schema schema, String string) throws SQLQueryException {
        return new OracleSQLQueryBuilder(dBObjectProvider, schema, string);
    }

    private static SQLQueryBuilder createBuilderFromQuery(DBObjectProvider dBObjectProvider, Schema schema, SQLQuery sQLQuery) throws SQLQueryException {
        return new OracleSQLQueryBuilder(dBObjectProvider, schema, sQLQuery);
    }
}

