/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class SetOperation
extends Operation {
    private int m_operator;
    public static final int BETWEEN = 704;
    public static final int NOT_BETWEEN = 706;
    public static final int IN = 705;
    public static final int NOT_IN = 707;
    private static Map s_setOps = new HashMap();

    public SetOperation() {
        this.setFunctionFormat(false);
    }

    public SetOperation(int n, SQLFragment[] sQLFragmentArray) {
        this();
        this.setArguments(sQLFragmentArray);
        this.setOperator(n);
    }

    public void setOperator(int n) {
        if (n == 704 || n == 706) {
            this.setSeparator(" AND ");
        } else if (n == 705 || n == 707) {
            this.setSeparator(", ");
        } else {
            throw new IllegalArgumentException(DBArb.format(43, "" + n));
        }
        this.m_operator = n;
    }

    public int getOperator() {
        return this.m_operator;
    }

    protected String getOperatorText() {
        return SetOperation.getSetOperator(this.m_operator);
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        SetOperation setOperation = dBObject == null ? new SetOperation() : (SetOperation)dBObject;
        this.copyToImpl(setOperation, bl);
        return setOperation;
    }

    protected void copyToImpl(SetOperation setOperation, boolean bl) {
        super.copyToImpl(setOperation, bl);
        setOperation.setOperator(this.m_operator);
    }

    protected boolean equalsImpl(SetOperation setOperation) {
        return super.equalsImpl(setOperation) && setOperation.m_operator == this.m_operator;
    }

    public boolean equals(Object object) {
        return object instanceof SetOperation && this.equalsImpl((SetOperation)object);
    }

    public static boolean isSetOperator(int n) {
        return n == 704 || n == 706 || n == 705 || n == 707;
    }

    public static String getSetOperator(int n) {
        return (String)s_setOps.get(new Integer(n));
    }

    static {
        s_setOps.put(new Integer(704), "BETWEEN");
        s_setOps.put(new Integer(706), "NOT BETWEEN");
        s_setOps.put(new Integer(705), "IN");
        s_setOps.put(new Integer(707), "NOT IN");
    }
}

