/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsingJoinCondition
extends AbstractSQLFragment
implements JoinCondition {
    public static final String USING = "USING";
    private List<FromObjectUsage> m_cols;

    void $init$() {
        this.m_cols = new ArrayList<FromObjectUsage>();
    }

    public UsingJoinCondition() {
        this.$init$();
    }

    public UsingJoinCondition(FromObjectUsage[] fromObjectUsageArray) {
        this.$init$();
        this.setColumns(fromObjectUsageArray);
    }

    public FromObjectUsage[] getColumns() {
        return this.m_cols.toArray(new FromObjectUsage[this.m_cols.size()]);
    }

    public void setColumns(FromObjectUsage[] fromObjectUsageArray) {
        this.setParents(this.m_cols, null);
        this.m_cols.clear();
        int n = 0;
        while (fromObjectUsageArray != null && n < fromObjectUsageArray.length) {
            this.m_cols.add(fromObjectUsageArray[n]);
            fromObjectUsageArray[n].setParent(this);
            ++n;
        }
    }

    public void addColumn(FromObjectUsage fromObjectUsage) {
        this.m_cols.add(fromObjectUsage);
        fromObjectUsage.setParent(this);
    }

    public void addColumn(int n, FromObjectUsage fromObjectUsage) {
        this.m_cols.add(n, fromObjectUsage);
        fromObjectUsage.setParent(this);
    }

    public boolean removeColumn(FromObjectUsage fromObjectUsage) {
        if (this.m_cols.remove(fromObjectUsage)) {
            this.removeParent(fromObjectUsage);
            return true;
        }
        return false;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        boolean bl = this.includesType("SQLFragment", stringArray);
        for (FromObjectUsage fromObjectUsage : this.m_cols) {
            if (fromObjectUsage == null || !bl && !this.includesType(fromObjectUsage.getType(), stringArray)) continue;
            collection.add(fromObjectUsage);
        }
    }

    @Override
    public String getSQLText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(USING);
        stringBuffer.append(" ");
        stringBuffer.append("(");
        this.getConditionTextImpl(stringBuffer);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String getConditionText() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getConditionTextImpl(stringBuffer);
        return stringBuffer.toString();
    }

    private void getConditionTextImpl(StringBuffer stringBuffer) {
        if (this.m_cols != null) {
            Iterator<FromObjectUsage> iterator = this.m_cols.iterator();
            while (iterator.hasNext()) {
                FromObjectUsage fromObjectUsage = iterator.next();
                stringBuffer.append(fromObjectUsage.getColumnName());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
        }
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        UsingJoinCondition usingJoinCondition = dBObject == null ? new UsingJoinCondition() : (UsingJoinCondition)dBObject;
        this.copyToImpl(usingJoinCondition, bl);
        return usingJoinCondition;
    }

    protected void copyToImpl(UsingJoinCondition usingJoinCondition, boolean bl) {
        super.copyToImpl(usingJoinCondition, bl);
        usingJoinCondition.setColumns(null);
        this.copyList(this.m_cols, usingJoinCondition.m_cols, usingJoinCondition, bl);
    }

    public boolean equals(Object object) {
        return object instanceof UsingJoinCondition && this.equalsImpl((UsingJoinCondition)object);
    }

    protected boolean equalsImpl(UsingJoinCondition usingJoinCondition) {
        return super.equalsImpl(usingJoinCondition) && ModelUtil.areEqual(this.m_cols, usingJoinCondition.m_cols);
    }
}

