/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;

public class AdaptiveServerAnywhereDescriptor
extends DatabaseDescriptor {
    private static final int MAX_NAME_LENGTH = 128;
    private static final char OPEN_QUOTE_IDENTIFIER = '[';
    private static final char CLOSE_QUOTE_IDENTIFIER = ']';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "BACKUP", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOTTOM", "BREAK", "BY", "CALL", "CAPABILITY", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_CONVERT", "CHARACTER", "CHECK", "CHECKPOINT", "CLOSE", "COMMENT", "COMMIT", "CONNECT", "CONSTRAINT", "CONTAINS", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DBSPACE", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DELETING", "DESC", "DISTINCT", "DO", "DOUBLE", "DROP", "DYNAMIC", "ELSE", "ELSEIF", "ENCRYPTED", "END", "ENDIF", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTING", "EXISTS", "EXTERNLOGIN", "FETCH", "FIRST", "FLOAT", "FOR", "FORCE", "FOREIGN", "FORWARD", "FROM", "FULL", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTIFIED", "IF", "IN", "INDEX", "INDEX_LPAREN", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INSERTING", "INSTALL", "INSTEAD", "INT", "INTEGER", "INTEGRATED", "INTERSECT", "INTO", "IQ", "IS", "ISOLATION", "JOIN", "KEY", "LATERAL", "LEFT", "LIKE", "LOCK", "LOGIN", "LONG", "MATCH", "MEMBERSHIP", "MESSAGE", "MODE", "MODIFY", "NATURAL", "NEW", "NO", "NOHOLDLOCK", "NOT", "NOTIFY", "NULL", "NUMERIC", "OF", "OFF", "ON", "OPEN", "OPTION", "OPTIONS", "OR", "ORDER", "OTHERS", "OUT", "OUTER", "OVER", "PASSTHROUGH", "PRECISION", "PREPEARE", "PRIMARY", "PRINT", "PRIVILEGES", "PROC", "PROCEDURE", "PUBLICATION", "RAISERROR", "READTEXT", "REAL", "REFERENCE", "REFERENCES", "RELEASE", "REMOTE", "REMOVE", "RENAME", "REORGANIZE", "RESOURCE", "RESTORE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "SAVE", "SAVEPOINT", "SCROLL", "SELECT", "SENSITIVE", "SESSION", "SET", "SETUSER", "SHARE", "SMALLINT", "SOME", "SQLCODE", "SQLSTATE", "START", "STOP", "SUBTRANS", "SUBTRANSACTION", "SYNCHRONIZE", "SYNTAX_ERROR", "TABLE", "TEMPORARY", "TEXTSIZE", "THEN", "TIME", "TIMESTAMP", "TINYINT", "TO", "TOP", "TRAN", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNBOUNDED", "UNION", "UNIQUE", "UNKNOWN", "UNSIGNED", "UPDATE", "UPDATING", "USER", "USING", "VALIDATE", "VALUES", "VARBINARY", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WAIT", "WAITFOR", "WHEN", "WHERE", "WHILE", "WINDOW", "WITH", "WITH_CUBE", "WITH_LPAREN", "WITH_ROLLUP", "WITHIN", "WORK", "WRITETEXT"));

    public int getCasePolicy() {
        return 0;
    }

    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    public void validateName(String string, String string2) throws InvalidNameException {
        boolean bl = true;
        String string3 = "";
        try {
            AdaptiveServerAnywhereDescriptor.validateIdentifier(string2, '\"', 128, "_$#@", false, RESERVED_WORDS, this.getCasePolicy());
        }
        catch (InvalidNameException invalidNameException) {
            bl = false;
            string3 = invalidNameException.getMessage();
        }
        char c = string2.charAt(0);
        if (bl && c != '\"' && !Character.isLetter(c) && c != '_' && c != '$' && c != '#' && c != '@') {
            throw new InvalidNameException(null, DBArb.getString(4));
        }
        if (!bl && c == '[' && string2.indexOf(91, 1) == -1 && string2.indexOf(93, 1) == string2.length() - 1 && string2.length() > 2 && string2.length() < 131) {
            bl = true;
        }
        if (!bl) {
            throw new InvalidNameException(null, string3);
        }
        String string4 = c == '\"' ? string2.substring(1, string2.length() - 1) : string2;
        int n = 0;
        int n2 = 0;
        while (n2 < string4.length()) {
            char c2 = string4.charAt(n2);
            if (Character.isISOControl(c2) || c2 == '\"' || n == 92 && c2 == '\\') {
                throw new InvalidNameException(null, DBArb.getString(4));
            }
            n = string4.charAt(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < string4.length()) {
            if (string2.charAt(n3) == '\'' && (++n3 == string4.length() - 1 || string2.charAt(n3) != '\'')) {
                throw new InvalidNameException(null, DBArb.getString(4));
            }
            ++n3;
        }
    }
}

