/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.sybase.AdaptiveServerAnywhereDatabase;
import oracle.javatools.db.sybase.AdaptiveServerAnywhereDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerAnywhereDescriptor;
import oracle.javatools.db.sybase.AdaptiveServerDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabase;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDescriptor;

public class AdaptiveServerDatabaseFactory
extends DatabaseFactory {
    private DatabaseDescriptor m_anywhereDesc;
    private DatabaseDescriptor m_enterpriseDesc;

    public AdaptiveServerDatabaseFactory() {
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        dataTypeRegistry.registerProvider(new AdaptiveServerDatabaseImpl.Registerer(), AdaptiveServerDatabaseImpl.class);
        dataTypeRegistry.registerProvider(new AdaptiveServerAnywhereDatabaseImpl.Registerer(), AdaptiveServerAnywhereDatabaseImpl.class);
        dataTypeRegistry.registerProvider(new AdaptiveServerEnterpriseDatabaseImpl.Registerer(), AdaptiveServerEnterpriseDatabaseImpl.class);
    }

    protected Database createDatabaseImpl(String string, Connection connection) {
        if (this.isAnywhere(connection)) {
            return new AdaptiveServerAnywhereDatabaseImpl(string, connection);
        }
        if (this.isEnterprise(connection)) {
            return new AdaptiveServerEnterpriseDatabaseImpl(string, connection);
        }
        return null;
    }

    private boolean isAnywhere(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDriverName();
                String string2 = databaseMetaData.getDatabaseProductName();
                if (string.indexOf("Sybase") > -1 && string2.indexOf("Anywhere") > -1) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isEnterprise(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDriverName();
                String string2 = databaseMetaData.getDatabaseProductName();
                if (string.indexOf("Sybase") > -1 || string2.indexOf("Adaptive Server Enterprise") > -1) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        if (AdaptiveServerAnywhereDatabase.class.isAssignableFrom(clazz)) {
            if (this.m_anywhereDesc == null) {
                this.m_anywhereDesc = new AdaptiveServerAnywhereDescriptor();
            }
            return this.m_anywhereDesc;
        }
        if (AdaptiveServerEnterpriseDatabase.class.isAssignableFrom(clazz)) {
            if (this.m_enterpriseDesc == null) {
                this.m_enterpriseDesc = new AdaptiveServerEnterpriseDescriptor();
            }
            return this.m_enterpriseDesc;
        }
        return null;
    }
}

