/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public final class JdbcDriverTester {
    private static final String USER_KEY = "user";
    private static final String PASSWORD_KEY = "password";
    private static final String URL_KEY = "url";
    private static final String DRIVER_KEY = "driver";
    private static final String SCHEMA_KEY = "owner_schema";
    private String _url;
    private Driver _driver;
    private Properties _props;
    private String _schema;
    private Connection _conn;
    private DatabaseMetaData _dmd;

    private static void printUsage() {
        System.err.println("JdbcDriverTester will attempt to connect to a database");
        System.err.println("and execute a number of JDBC calls. The output of these");
        System.err.println("calls will provide details about the JDBC implementation");
        System.err.println("of the specified driver.");
        System.err.println();
        System.err.println("To invoke JdbcDriverTester, specify the path to a properties");
        System.err.println("file containing the connection information. The following");
        System.err.println("properties are supported:");
        System.err.println("  user - indicates the username used for the connection");
        System.err.println("  password - indicates the password used for the connection");
        System.err.println("  driver - indicates the JDBC driver class used for the connection.");
        System.err.println("           This class must be available on the classpath.");
        System.err.println("  url - the URL used for the connection");
        System.err.println("  owner_schema - indicates the schema to use when querying for");
        System.err.println("                 tables and views");
        System.err.println();
        System.err.println("JdbcDriverTester requires that the driver and url be specified; the");
        System.err.println("driver class determines whether the user and password are required.");
        System.err.println("Any additional properties specified in the file will be passed to");
        System.err.println("the driver when the connection is created.");
    }

    private static void handleUsageError(String string) {
        System.err.println("Usage error: " + string);
        System.err.println();
        JdbcDriverTester.printUsage();
        System.exit(-1);
    }

    private static void printError(String string, SQLException sQLException) {
        System.err.println("SQLException encountered when calling " + string + ":");
        System.err.println("  " + sQLException.getLocalizedMessage());
    }

    private static Properties loadPropertiesFromFile(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        return properties;
    }

    private static String quoteValue(String string) {
        return string != null ? "\"" + string + "\"" : "null";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            JdbcDriverTester.handleUsageError("Properties file not specified");
        }
        try {
            Properties properties = JdbcDriverTester.loadPropertiesFromFile(stringArray[0]);
            Properties properties2 = new Properties();
            String string = null;
            Driver driver = null;
            String string2 = null;
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = properties.getProperty(string3);
                if (DRIVER_KEY.equals(string3)) {
                    Class<?> clazz = Class.forName(string4);
                    driver = (Driver)clazz.newInstance();
                    continue;
                }
                if (URL_KEY.equals(string3)) {
                    string = string4;
                    continue;
                }
                if (SCHEMA_KEY.equals(string3)) {
                    string2 = string4;
                    continue;
                }
                properties2.setProperty(string3, string4);
            }
            JdbcDriverTester jdbcDriverTester = new JdbcDriverTester(string, driver, properties2, string2);
            jdbcDriverTester.test();
            jdbcDriverTester.close();
        }
        catch (Exception exception) {
            JdbcDriverTester.handleUsageError(exception.getLocalizedMessage());
        }
    }

    private JdbcDriverTester(String string, Driver driver, Properties properties, String string2) throws SQLException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("URL must be specified");
        }
        if (driver == null) {
            throw new IllegalArgumentException("JDBC driver class must be specified");
        }
        this._url = string;
        this._driver = driver;
        this._props = properties;
        this._schema = string2;
        this.resetConnection();
    }

    private void test() throws SQLException {
        boolean bl;
        String string = this.fetchCatalog();
        this.fetchDriverInfo();
        Set set = this.fetchSchemas();
        boolean bl2 = bl = set != null;
        if (bl && this._schema == null) {
            try {
                this._schema = this._dmd.getUserName();
            }
            catch (SQLException sQLException) {
                JdbcDriverTester.printError("getUserName()", sQLException);
                this.resetConnection();
            }
        }
        Set set2 = this.fetchTableTypes();
        for (String string2 : set2) {
            this.fetchTables(string, string2, this._schema);
            if (string2.trim().equals(string2)) continue;
            this.fetchTables(string, string2.trim(), this._schema);
        }
    }

    private void close() {
        if (this._conn != null) {
            try {
                this._conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._conn = null;
        }
    }

    private void resetConnection() throws SQLException {
        this.close();
        this._conn = this._driver.connect(this._url, this._props);
        this._dmd = this._conn.getMetaData();
    }

    private String fetchCatalog() throws SQLException {
        String string = null;
        try {
            System.out.println("Fetching catalog...");
            string = this._conn.getCatalog();
            System.out.print("  Connection.getCatalog() returned ");
            System.out.println(JdbcDriverTester.quoteValue(string));
        }
        catch (SQLException sQLException) {
            JdbcDriverTester.printError("getCatalog()", sQLException);
            this.resetConnection();
        }
        return string;
    }

    private void fetchDriverInfo() throws SQLException {
        String string = null;
        try {
            string = "getDriverName()";
            System.out.println("Fetching driver name...");
            String string2 = this._dmd.getDriverName();
            System.out.println("  " + string + " returned " + string2);
            string = "getDriverVersion()";
            System.out.println("Fetching driver version...");
            string2 = this._dmd.getDriverVersion();
            System.out.println("  " + string + " returned " + string2);
        }
        catch (SQLException sQLException) {
            JdbcDriverTester.printError(string, sQLException);
            this.resetConnection();
        }
    }

    private Set fetchSchemas() throws SQLException {
        ResultSet resultSet = null;
        HashSet<String> hashSet = null;
        try {
            try {
                System.out.println("Fetching schema list...");
                resultSet = this._dmd.getSchemas();
                hashSet = new HashSet<String>();
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    System.out.println("  Found schema " + JdbcDriverTester.quoteValue(string));
                    hashSet.add(string);
                }
            }
            catch (SQLException sQLException) {
                JdbcDriverTester.printError("getSchemas()", sQLException);
                this.resetConnection();
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return hashSet;
    }

    private Set fetchTableTypes() throws SQLException {
        ResultSet resultSet = null;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            try {
                System.out.println("Fetching Table Types...");
                resultSet = this._dmd.getTableTypes();
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    System.out.println("  Found table type " + JdbcDriverTester.quoteValue(string));
                    hashSet.add(string);
                }
            }
            catch (SQLException sQLException) {
                JdbcDriverTester.printError("getTableTypes()", sQLException);
                this.resetConnection();
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return hashSet;
    }

    private void fetchTables(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet = null;
        String string4 = null;
        try {
            try {
                HashSet<Table> hashSet = new HashSet<Table>();
                string4 = "getTables()";
                System.out.println("Fetching tables of type " + JdbcDriverTester.quoteValue(string2) + "for schema " + JdbcDriverTester.quoteValue(string3) + " using catalog " + JdbcDriverTester.quoteValue(string));
                resultSet = this._dmd.getTables(string, string3, "%", new String[]{string2});
                while (resultSet.next()) {
                    hashSet.add(new Table(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3)));
                }
                resultSet.close();
                string4 = "getColumns";
                for (Table table : hashSet) {
                    System.out.println("Fetching table data for " + table);
                    resultSet = this._dmd.getColumns(table._cat, table._schema, table._name, "%");
                    while (resultSet.next()) {
                        System.out.println("  Found column " + resultSet.getString(4));
                    }
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                JdbcDriverTester.printError(string4, sQLException);
                this.resetConnection();
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static String maS$quoteValue(String string) {
        return JdbcDriverTester.quoteValue(string);
    }

    private static final class Table {
        String _cat;
        String _schema;
        String _name;

        Table(String string, String string2, String string3) {
            this._cat = string;
            this._schema = string2;
            this._name = string3;
        }

        public String toString() {
            return JdbcDriverTester.maS$quoteValue(this._cat) + ":" + JdbcDriverTester.maS$quoteValue(this._schema) + ":" + JdbcDriverTester.maS$quoteValue(this._name);
        }
    }
}

