/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.timesten;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.timesten.TimesTenDatabase;
import oracle.javatools.db.timesten.TimesTenDatabaseDescriptor;
import oracle.javatools.db.timesten.TimesTenDatabaseImpl;

public class TimesTenDatabaseFactory
extends DatabaseFactory {
    private DatabaseDescriptor m_descriptor;

    public TimesTenDatabaseFactory() {
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        dataTypeRegistry.registerProvider(new TimesTenDatabaseImpl.Registerer(), TimesTenDatabaseImpl.class);
    }

    protected Database createDatabaseImpl(String string, Connection connection) {
        return this.isTimesTenConnection(connection) ? new TimesTenDatabaseImpl(string, connection) : null;
    }

    protected boolean isTimesTenConnection(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                boolean bl = string.startsWith("TimesTen");
                return bl;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        if (TimesTenDatabase.class.isAssignableFrom(clazz)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new TimesTenDatabaseDescriptor();
            }
            return this.m_descriptor;
        }
        return null;
    }
}

