/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.text.MessageFormat;
import java.util.HashSet;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.MissingValidatorException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractValidator
implements DBObjectValidator {
    private DBObjectProvider m_provider;

    protected AbstractValidator(DBObjectProvider dBObjectProvider) {
        this.m_provider = dBObjectProvider;
    }

    protected void validateName(DBObject dBObject) throws InvalidNameException {
        String string = dBObject.getName();
        if (!ModelUtil.hasLength((String)string) && !this.canHaveEmptyName()) {
            throw new InvalidNameException(dBObject, DBArb.getString(50));
        }
        if (this.m_provider != null) {
            try {
                String string2 = this.m_provider.getExternalName(string);
                this.m_provider.validateName(dBObject.getType(), string2);
            }
            catch (InvalidNameException invalidNameException) {
                String string3 = invalidNameException.getMessage();
                throw new InvalidNameException(dBObject, DBArb.format(51, string, string3));
            }
        }
    }

    protected boolean canHaveEmptyName() {
        return false;
    }

    protected boolean canRename() {
        return true;
    }

    protected boolean canChangeSchema() {
        return true;
    }

    protected DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public final void validateObject(DBObject dBObject) throws ValidationException {
        if (dBObject instanceof SchemaObject && !(dBObject instanceof Index) && this.findExistingObject(dBObject) != null) {
            throw new NameInUseException(dBObject);
        }
        this.validateObject(null, dBObject);
    }

    public final void validateObject(DBObject dBObject, String string) throws ValidationException {
        this.validateObject(this.findExistingObject(dBObject), dBObject, string);
    }

    protected void validateSchema(SchemaObject schemaObject) throws ValidationException {
        Schema schema = schemaObject.getSchema();
        if (schema == null) {
            throw new ValidationException((DBObject)schemaObject, DBArb.getString(54));
        }
        String string = schema.getName();
        if (!ModelUtil.hasLength((String)string)) {
            throw new InvalidNameException((DBObject)schema, DBArb.getString(53));
        }
        if (!this.m_provider.isValidName("SCHEMA", this.m_provider.getExternalName(string))) {
            throw new InvalidNameException((DBObject)schema, DBArb.getString(52));
        }
    }

    protected void validateNameInUse(DBObject dBObject) throws NameInUseException {
        if (this.m_provider != null) {
            Schema schema = DBUtil.getSchema(dBObject);
            String string = dBObject.getType();
            String string2 = dBObject.getName();
            this.m_provider.validateUniqueName(string, schema, string2);
        }
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2) throws ValidationException {
        this.validateName(dBObject2);
        if (dBObject == null) {
            this.validateNameInUse(dBObject2);
        } else if (ModelUtil.areDifferent((Object)dBObject.getName(), (Object)dBObject2.getName())) {
            if (this.canRename()) {
                this.validateNameInUse(dBObject2);
            } else {
                throw new ValidationException(dBObject2, DBArb.getString(48));
            }
        }
        if (dBObject != null && ModelUtil.areDifferent((Object)dBObject.getType(), (Object)dBObject2.getType())) {
            throw new ValidationException(dBObject2, DBArb.getString(49));
        }
        if (dBObject2 instanceof SchemaObject) {
            Schema schema = dBObject == null ? null : ((SchemaObject)dBObject).getSchema();
            Schema schema2 = ((SchemaObject)dBObject2).getSchema();
            if (schema == null) {
                this.validateSchema((SchemaObject)dBObject2);
            } else if (ModelUtil.areDifferent((Object)schema, (Object)schema2)) {
                if (this.canChangeSchema()) {
                    this.validateSchema((SchemaObject)dBObject2);
                } else {
                    throw new ValidationException(dBObject2, DBArb.getString(55));
                }
            }
        }
    }

    public static void validateUniqueNames(DBObject[] dBObjectArray) throws ValidationException {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < dBObjectArray.length) {
            String string = dBObjectArray[n].getName();
            if (hashSet.contains(string)) {
                throw new InvalidNameException(dBObjectArray[n], DBArb.format(56, string, dBObjectArray[n].getType()));
            }
            hashSet.add(string);
            ++n;
        }
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2, String string) throws ValidationException {
        throw new MissingValidatorException(dBObject2, string);
    }

    protected DBObject findExistingObject(DBObject dBObject) throws ValidationException {
        DBObjectID dBObjectID = dBObject.getID();
        DBObject dBObject2 = null;
        if (dBObjectID != null) {
            try {
                if (dBObjectID instanceof TemporaryObjectID) {
                    dBObject2 = ((TemporaryObjectID)dBObjectID).resolveOriginalID();
                    if (ModelUtil.areEqual((Object)dBObject, (Object)dBObject2)) {
                        dBObject2 = null;
                    }
                } else {
                    dBObject2 = dBObjectID.resolveID();
                }
            }
            catch (DBException dBException) {
                throw new ValidationException(dBObject, dBException.getMessage());
            }
            if (dBObject2 != null && !dBObject2.getType().equals(dBObject.getType())) {
                throw new ValidationException(dBObject, MessageFormat.format(DBArb.getString(57), dBObject.getName()));
            }
        }
        if (dBObject2 == null && dBObject instanceof SchemaObject && (dBObjectID == null || dBObjectID instanceof TemporaryObjectID)) {
            try {
                dBObject2 = DBUtil.getProviderDefinition((SchemaObject)dBObject, this.getProvider());
            }
            catch (DBException dBException) {
                DBUtil.logStackTrace(dBException);
            }
        }
        return dBObject2;
    }
}

