/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

public class ColumnValidator
extends AbstractValidator {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColumnValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2) throws ValidationException {
        if (dBObject == null || ModelUtil.areDifferent((Object)dBObject, (Object)dBObject2)) {
            super.validateObject(dBObject, dBObject2);
            this.validateColumnDefinition((Column)dBObject2);
        }
    }

    protected void validateColumnDefinition(Column column) throws ValidationException {
        DataType dataType = null;
        try {
            dataType = DataTypeHelper.getDataType(column.getDataTypeUsage());
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (dataType == null) {
            throw new ValidationException((DBObject)column, DBArb.format(147, ColumnValidator.formatRelationColumn(column, null)), DBArb.getString(148));
        }
        dataType.validateUsage(column.getDataTypeUsage(), column);
        this.validateDefaultValue(column, dataType);
    }

    protected void validateDefaultValue(Column column, DataType dataType) throws ValidationException {
        String string = (String)column.getDefault();
        if (string != null) {
            dataType.validateDefaultValue(string, column.getDataTypeUsage(), column);
        }
    }

    public static String formatRelationColumn(Column column, Relation relation) {
        StringBuffer stringBuffer = new StringBuffer();
        if (column != null) {
            String string;
            Relation relation2 = column.getRelation();
            Relation relation3 = relation2 = relation2 == null ? relation : relation2;
            if (relation2 != null && ModelUtil.hasLength((String)(string = relation2.getName()))) {
                stringBuffer.append(string);
                stringBuffer.append(".");
            }
            stringBuffer.append(column.getName());
        }
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = ColumnValidator.class.desiredAssertionStatus() ^ true;
    }

    protected void validateNameInUse(DBObject dBObject) throws NameInUseException {
        if (!$assertionsDisabled && dBObject == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(dBObject instanceof Column)) {
            throw new AssertionError();
        }
        Column column = (Column)dBObject;
        try {
            if (column.getRelation() != null) {
                ColumnValidator.validateUniqueNames(column.getRelation().getColumns());
            }
        }
        catch (ValidationException validationException) {
            throw new NameInUseException(validationException.getObject());
        }
    }
}

