/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

public class ConstraintValidator
extends AbstractValidator {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConstraintValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    static {
        $assertionsDisabled = ConstraintValidator.class.desiredAssertionStatus() ^ true;
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2) throws ValidationException {
        if (!$assertionsDisabled && dBObject2 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(dBObject2 instanceof Constraint)) {
            throw new AssertionError();
        }
        Constraint constraint = (Constraint)dBObject2;
        if (constraint.getParent() == null || !this.existsInParent(constraint)) {
            throw new ValidationException((DBObject)constraint, DBArb.getString(153));
        }
        if (dBObject == null || ModelUtil.areDifferent((Object)dBObject, (Object)constraint)) {
            super.validateObject(dBObject, constraint);
        }
        this.validateConstraintDefinition(constraint);
    }

    protected void validateNameInUse(DBObject dBObject) throws NameInUseException {
        block7: {
            if (!$assertionsDisabled && dBObject == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !(dBObject instanceof Constraint)) {
                throw new AssertionError();
            }
            Constraint constraint = (Constraint)dBObject;
            try {
                ConstraintValidator.validateUniqueNames(constraint.getRelation().getConstraints());
            }
            catch (ValidationException validationException) {
                throw new NameInUseException(constraint);
            }
            if (this.enforceConstraintsUniqueInSchema()) {
                try {
                    super.validateNameInUse(constraint);
                }
                catch (NameInUseException nameInUseException) {
                    Relation relation = constraint.getRelation();
                    if (!ModelUtil.areDifferent((Object)relation.getName(), (Object)nameInUseException.getUserName()) && !ModelUtil.areDifferent((Object)relation.getType(), (Object)nameInUseException.getUserType())) break block7;
                    throw nameInUseException;
                }
            }
        }
    }

    protected boolean enforceConstraintsUniqueInSchema() {
        return true;
    }

    protected void validateConstraintDefinition(Constraint constraint) throws ValidationException {
        block11: {
            String string;
            block12: {
                block10: {
                    string = constraint.getConstraintType();
                    if (!(constraint instanceof CheckConstraint)) break block10;
                    String string2 = ((CheckConstraint)constraint).getCheckCondition();
                    if (string2 == null || string2.length() == 0) {
                        throw new ValidationException((DBObject)constraint, DBArb.getString(168));
                    }
                    break block11;
                }
                if (!(constraint instanceof UniqueConstraint)) break block12;
                Column[] columnArray = ((UniqueConstraint)constraint).getColumns();
                if (columnArray.length == 0) {
                    throw new ValidationException((DBObject)constraint, DBArb.getString(158));
                }
                if (this.areDuplicateColumns(columnArray)) {
                    throw new ValidationException((DBObject)constraint, DBArb.getString(154));
                }
                if (constraint.getRelation() != null && this.missingColumns(columnArray, constraint.getRelation().getColumns())) {
                    throw new ValidationException((DBObject)constraint, DBArb.getString(155));
                }
                if (string.equals("PKConstraint")) {
                    this.checkColumnDataType(columnArray, 159);
                    this.markColumnsNotNull(columnArray);
                } else {
                    this.checkColumnDataType(columnArray, 161);
                }
                this.checkIsUniqueDefinition(constraint);
                break block11;
            }
            if (!"FKConstraint".equals(string)) break block11;
            FKConstraint fKConstraint = (FKConstraint)constraint;
            DBObjectID dBObjectID = fKConstraint.getReferenceID();
            if (dBObjectID == null) {
                throw new ValidationException((DBObject)constraint, DBArb.getString(164));
            }
            Column[] columnArray = fKConstraint.getColumns();
            if (columnArray.length == 0) {
                throw new ValidationException((DBObject)constraint, DBArb.getString(165));
            }
            if (this.areDuplicateColumns(columnArray)) {
                throw new ValidationException((DBObject)constraint, DBArb.getString(154));
            }
            if (constraint.getRelation() != null && this.missingColumns(columnArray, constraint.getRelation().getColumns())) {
                throw new ValidationException((DBObject)constraint, DBArb.getString(155));
            }
            this.checkColumnDataType(columnArray, 166);
            this.checkColumnsMatch(fKConstraint, 167);
        }
    }

    protected boolean incompatibleDataTypes(DataType dataType, DataType dataType2) {
        return ModelUtil.areDifferent((Object)dataType, (Object)dataType2);
    }

    protected boolean isValidConstraintDatatype(String string, DataTypeUsage dataTypeUsage) {
        return true;
    }

    private void checkColumnsMatch(FKConstraint fKConstraint, int n) throws ValidationException {
        Column[] columnArray = fKConstraint.getColumns();
        DBObjectID dBObjectID = fKConstraint.getReferenceID();
        UniqueConstraint uniqueConstraint = null;
        try {
            uniqueConstraint = (UniqueConstraint)dBObjectID.resolveID();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (uniqueConstraint != null && columnArray != null && columnArray.length == uniqueConstraint.getColumns().length) {
            Column[] columnArray2 = uniqueConstraint.getColumns();
            int n2 = 0;
            while (n2 < columnArray.length) {
                Column column = columnArray2[n2];
                if (column != null && columnArray[n2] != null) {
                    String string = column.getName();
                    DataType dataType = null;
                    DataType dataType2 = null;
                    try {
                        dataType = DataTypeHelper.getDataType(columnArray[n2].getDataTypeUsage());
                        dataType2 = DataTypeHelper.getDataType(column.getDataTypeUsage());
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    if (this.incompatibleDataTypes(dataType, dataType2)) {
                        Object[] objectArray = new Object[]{columnArray[n2].getName(), dataType.getName(), string, dataType2.getName()};
                        throw new ValidationException((DBObject)fKConstraint, DBArb.format(n, objectArray));
                    }
                }
                ++n2;
            }
        }
    }

    private void markColumnsNotNull(Column[] columnArray) throws ValidationException {
        int n = 0;
        while (n < columnArray.length) {
            Column column = columnArray[n];
            if (!column.isNotNull()) {
                column.setNotNull(true);
            }
            ++n;
        }
    }

    private void checkColumnDataType(Column[] columnArray, int n) throws ValidationException {
        int n2 = 0;
        while (n2 < columnArray.length) {
            Column column = columnArray[n2];
            if (column != null && !(column instanceof ViewColumn)) {
                DataType dataType = null;
                try {
                    dataType = DataTypeHelper.getDataType(column.getDataTypeUsage());
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (dataType == null) {
                    throw new ValidationException((DBObject)column, DBArb.format(147, column.getName()));
                }
                if (!this.isValidConstraintDatatype(dataType.getName(), column.getDataTypeUsage())) {
                    throw new ValidationException((DBObject)column, DBArb.format(n, column.getName()));
                }
            }
            ++n2;
        }
    }

    private void checkIsUniqueDefinition(Constraint constraint) throws ValidationException {
        Column[] columnArray = ((UniqueConstraint)constraint).getColumns();
        Constraint[] constraintArray = constraint.getRelation().getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            if (constraintArray[n] instanceof UniqueConstraint && !constraintArray[n].equals(constraint) && this.areIdenticalColumnLists(columnArray, ((UniqueConstraint)constraintArray[n]).getColumns())) {
                throw new ValidationException((DBObject)constraint, DBArb.format(162, new Object[]{this.getConstraintTypeDisplayName(constraint), constraint.getName(), this.getConstraintTypeDisplayName(constraintArray[n]), constraintArray[n].getName()}));
            }
            ++n;
        }
    }

    private boolean areIdenticalColumnLists(Column[] columnArray, Column[] columnArray2) {
        if (columnArray.length != columnArray2.length) {
            return false;
        }
        int n = 0;
        while (n < columnArray.length) {
            if (!columnArray[n].getName().equals(columnArray2[n].getName())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String getConstraintTypeDisplayName(Constraint constraint) {
        return DBArb.getString(constraint.getConstraintType().equals("PKConstraint") ? 157 : 160);
    }

    private boolean areDuplicateColumns(Column[] columnArray) {
        boolean bl = false;
        int n = 0;
        while (n < columnArray.length - 1 && !bl) {
            if (columnArray[n] != null) {
                int n2 = n + 1;
                while (n2 < columnArray.length) {
                    if (columnArray[n].equals(columnArray[n2])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return bl;
    }

    private boolean missingColumns(Column[] columnArray, Column[] columnArray2) {
        boolean bl = false;
        int n = 0;
        while (n < columnArray.length && !bl) {
            bl = true;
            int n2 = 0;
            while (n2 < columnArray2.length) {
                if (columnArray[n].equals(columnArray2[n2])) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return bl;
    }

    public static void validateOnePK(Constraint[] constraintArray) throws ValidationException {
        boolean bl = false;
        int n = 0;
        while (n < constraintArray.length) {
            String string = constraintArray[n].getConstraintType();
            if ("PKConstraint".equals(string)) {
                if (bl) {
                    throw new ValidationException((DBObject)constraintArray[n], DBArb.getString(156));
                }
                bl = true;
            }
            ++n;
        }
    }

    private boolean existsInParent(Constraint constraint) {
        Constraint[] constraintArray = constraint.getRelation().getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            if (constraint.equals(constraintArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

