/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.diff.IndexObjectComparator;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.SqlExpression;
import oracle.javatools.util.ModelUtil;

public class IndexValidator
extends AbstractValidator {
    static final /* synthetic */ boolean $assertionsDisabled;

    public IndexValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    static {
        $assertionsDisabled = IndexValidator.class.desiredAssertionStatus() ^ true;
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2) throws ValidationException {
        if (!$assertionsDisabled && dBObject2 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(dBObject2 instanceof Index)) {
            throw new AssertionError();
        }
        Index index = (Index)dBObject2;
        if (index.getParent() == null) {
            throw new ValidationException((DBObject)index, DBArb.getString(77));
        }
        if (dBObject == null || ModelUtil.areDifferent((Object)dBObject, (Object)index)) {
            super.validateObject(dBObject, index);
        }
        this.validateIndexDefinition(index);
    }

    protected void validateIndexDefinition(Index index) throws ValidationException {
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        if (indexObjectArray.length <= 0) {
            throw new ValidationException((DBObject)index, DBArb.getString(79));
        }
        this.checkColumnExpressions(index);
        this.checkDefinitionIsUnique(index);
    }

    public void validateNameInTable(Table table) throws ValidationException {
        Index[] indexArray = table.getIndexes();
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < indexArray.length) {
            String string = indexArray[n].getName();
            if (hashSet.contains(string)) {
                this.errorDuplicateName(indexArray[n]);
            }
            ++n;
        }
    }

    protected void validateNameInUse(DBObject dBObject) throws NameInUseException {
        block6: {
            if (!$assertionsDisabled && dBObject == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !(dBObject instanceof Index)) {
                throw new AssertionError();
            }
            Index index = (Index)dBObject;
            try {
                IndexValidator.validateUniqueNames(index.getTable().getIndexes());
            }
            catch (ValidationException validationException) {
                throw new NameInUseException(index);
            }
            try {
                super.validateNameInUse(index);
            }
            catch (NameInUseException nameInUseException) {
                Table table = index.getTable();
                if (!ModelUtil.areDifferent((Object)table.getName(), (Object)nameInUseException.getUserName()) && !ModelUtil.areDifferent((Object)table.getType(), (Object)nameInUseException.getUserType())) break block6;
                throw nameInUseException;
            }
        }
    }

    private void errorDuplicateName(Index index) throws ValidationException {
        String string = index.getName();
        throw new InvalidNameException((DBObject)index, DBArb.format(84, string));
    }

    protected void validateColumnExpression(Index index, SQLFragment sQLFragment) throws ValidationException {
        Table table = index.getTable();
        try {
            PlsqlRoot plsqlRoot = ParserUtils.parseQueryString(sQLFragment.getSQLText(), 2);
            ParserUtils.checkErrors(plsqlRoot, sQLFragment.getSQLText());
            PlsqlNode[] plsqlNodeArray = plsqlRoot.getUnits();
            if (!$assertionsDisabled && plsqlNodeArray.length != 1) {
                throw new AssertionError((Object)"Invalid expression parse");
            }
            Collection collection = ParserUtils.getColumnNames((SqlExpression)plsqlNodeArray[0]);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = this.getProvider().getInternalName((String)iterator.next());
                Column column = table.getColumn(string);
                if (column == null) {
                    throw new ValidationException((DBObject)index, DBArb.format(81, string, table.getName()));
                }
                this.validateColumnType(index, column);
            }
        }
        catch (SQLQueryException sQLQueryException) {
            throw new ValidationException((DBObject)index, DBArb.format(85, new Object[]{index.getName(), sQLFragment}));
        }
    }

    protected void validateColumnType(Index index, Column column) throws ValidationException {
    }

    protected void checkColumnExpressions(Index index) throws ValidationException {
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        Table table = index.getTable();
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < indexObjectArray.length) {
            String string = this.getProvider().getInternalName(indexObjectArray[n].getExpression().getSQLText());
            Column column = table.getColumn(string);
            if (column == null) {
                throw new ValidationException((DBObject)index, DBArb.format(80, table.getName()));
            }
            if (this.columnMustBeUnique()) {
                if (hashSet.contains(string)) {
                    throw new ValidationException((DBObject)index, DBArb.format(86, string, index.getName()));
                }
                hashSet.add(string);
            }
            this.validateColumnType(index, column);
            ++n;
        }
    }

    protected boolean columnMustBeUnique() {
        return true;
    }

    protected void checkDefinitionIsUnique(Index index) throws ValidationException {
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        Index[] indexArray = index.getTable().getIndexes();
        IndexObjectComparator indexObjectComparator = new IndexObjectComparator();
        int n = 0;
        while (n < indexArray.length) {
            if (!indexArray[n].equals(index)) {
                IndexObject[] indexObjectArray2 = indexArray[n].getColumnExpressions();
                if (indexObjectArray.length != indexObjectArray2.length) break;
                boolean bl = false;
                int n2 = 0;
                while (n2 < indexObjectArray.length) {
                    if (indexObjectComparator.compare(indexObjectArray[n2], indexObjectArray2[n2]) != 0) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    throw new ValidationException((DBObject)index, DBArb.format(78, index.getName(), indexArray[n].getName()));
                }
            }
            ++n;
        }
    }
}

