/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.util.ModelUtil;

public abstract class RelationValidator
extends AbstractValidator {
    protected static Map s_postfixes = new HashMap();

    public RelationValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public void validateConstraints(Relation relation, Relation relation2) throws ValidationException {
        Constraint[] constraintArray = relation == null ? null : relation.getConstraints();
        Constraint[] constraintArray2 = relation2.getConstraints();
        ConstraintValidator.validateOnePK(constraintArray2);
        int n = 0;
        while (n < constraintArray2.length) {
            Constraint constraint = constraintArray2[n];
            String string = constraint.getName();
            if (string == null) {
                if (this.createConstraintNameIfNone()) {
                    String string2 = this.makeConstraintName(constraint, relation2);
                    string2 = this.enforceConstraintsUniqueInSchema() ? this.getProvider().getUniqueName(constraint.getConstraintType(), DBUtil.getSchema(constraint), string2) : this.getProvider().getUniqueName(constraint.getConstraintType(), constraint.getRelation(), string2);
                    constraint.setName(string2);
                } else {
                    throw new NameInUseException(constraint);
                }
            }
            DBObjectID dBObjectID = constraintArray2[n].getID();
            while (dBObjectID != null && dBObjectID instanceof TemporaryObjectID) {
                try {
                    DBObject dBObject = ((TemporaryObjectID)dBObjectID).resolveOriginalID();
                    dBObjectID = dBObject == null ? null : dBObject.getID();
                }
                catch (Exception exception) {
                    DBUtil.logStackTrace(exception);
                }
            }
            Constraint constraint2 = null;
            if (dBObjectID != null && constraintArray != null) {
                int n2 = 0;
                while (n2 < constraintArray.length) {
                    if (ModelUtil.areEqual((Object)dBObjectID, (Object)constraintArray[n2].getID())) {
                        constraint2 = constraintArray[n2];
                        break;
                    }
                    ++n2;
                }
            }
            if (constraint2 == null) {
                this.getProvider().validateObject(constraint);
            } else {
                this.getProvider().validateObject(constraint2, constraint);
            }
            ++n;
        }
        if (relation != null) {
            this.validateReferences();
        }
    }

    protected void validateReferences() throws ValidationException {
    }

    protected String makeConstraintName(Constraint constraint, Relation relation) {
        String string = relation.getName();
        String string2 = constraint.getConstraintType();
        String string3 = (String)s_postfixes.get(string2);
        int n = 30 - string3.length() - 2;
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        return string + string3;
    }

    private void addConstraintNames(Set set, Relation relation) throws ValidationException {
        Constraint[] constraintArray = relation.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            this.addConstraintName(set, constraintArray[n]);
            ++n;
        }
    }

    private void addConstraintName(Set set, Constraint constraint) throws ValidationException {
        String string = constraint.getName();
        if (string != null) {
            if (set.contains(string)) {
                throw new InvalidNameException((DBObject)constraint, DBArb.format(56, string, "CONSTRAINT"));
            }
            set.add(string);
        }
    }

    protected boolean enforceConstraintsUniqueInSchema() {
        return false;
    }

    protected boolean createConstraintNameIfNone() {
        return true;
    }

    public void validateColumns(Relation relation, Relation relation2) throws ValidationException {
        Object[] objectArray = relation2.getColumns();
        if (this.enforceOneColumnExists(relation == null) && !ModelUtil.hasNonNullElement((Object[])objectArray)) {
            throw new ValidationException((DBObject)relation2, DBArb.format(149, relation2.getName()), DBArb.getString(150));
        }
        int n = 0;
        while (n < objectArray.length) {
            this.getProvider().validateObject((DBObject)objectArray[n]);
            ++n;
        }
        RelationValidator.validateUniqueNames((DBObject[])objectArray);
    }

    protected boolean enforceOneColumnExists(boolean bl) {
        return this.getProvider() instanceof Database;
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2, String string) throws ValidationException {
        if ("COLUMN".equals(string)) {
            this.validateColumns((Relation)dBObject, (Relation)dBObject2);
        } else if ("CONSTRAINT".equals(string)) {
            this.validateConstraints((Relation)dBObject, (Relation)dBObject2);
        } else {
            super.validateObject(dBObject, dBObject2, string);
        }
    }

    static {
        s_postfixes.put("PKConstraint", "_PK");
        s_postfixes.put("UniqueConstraint", "_UK");
        s_postfixes.put("FKConstraint", "_FK");
        s_postfixes.put("CheckConstraint", "_CHK");
    }
}

