/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.math.BigInteger;
import java.text.MessageFormat;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.validators.AbstractValidator;

public class SequenceValidator
extends AbstractValidator {
    public static final int OK = 1;
    public static final int ERROR_ZERO_INCREMENT = -2;
    public static final int ERROR_INCREMENT_TOO_MANY_DIGITS = -3;
    public static final int ERROR_INCREMENT_TOO_BIG = -4;
    public static final int ERROR_START_TOO_MANY_DIGITS = -5;
    public static final int ERROR_START_LESS_THAN_MIN = -6;
    public static final int ERROR_START_GREATER_THAN_MAX = -7;
    public static final int ERROR_MIN_TOO_MANY_DIGITS = -8;
    public static final int ERROR_MIN_GREATER_THAN_START = -9;
    public static final int ERROR_MIN_GREATER_THAN_MAX = -10;
    public static final int ERROR_MAX_TOO_MANY_DIGITS = -11;
    public static final int ERROR_MAX_LESS_THAN_START = -12;
    public static final int ERROR_MAX_LESS_THAN_MIN = -13;
    public static final int ERROR_CACHE_TOO_MANY_DIGITS = -14;
    public static final int ERROR_CACHE_TOO_SMALL = -15;
    public static final int ERROR_CACHE_TOO_BIG = -16;
    private static final BigInteger MAX27 = BigInteger.valueOf(10).pow(27);
    private static final BigInteger MIN26 = BigInteger.valueOf(10).pow(26).negate();
    private static final BigInteger DIGITS28 = BigInteger.valueOf(10).pow(28).subtract(BigInteger.ONE);

    public SequenceValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected void validateSequence(Sequence sequence) throws ValidationException {
        this.validateIncrement(sequence);
        this.validateStartWith(sequence);
        this.validateMinValue(sequence);
        this.validateMaxValue(sequence);
        this.validateCache(sequence);
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2) throws ValidationException {
        super.validateObject(dBObject, dBObject2);
        if (dBObject2 instanceof Sequence) {
            this.validateSequence((Sequence)dBObject2);
        }
    }

    private String formatBigInteger(BigInteger bigInteger, BigInteger bigInteger2) {
        String string = bigInteger2.toString();
        if (bigInteger == null) {
            string = MessageFormat.format(DBArb.getString(59), string);
        }
        return string;
    }

    private boolean tooBig(BigInteger bigInteger) {
        return bigInteger.abs().compareTo(DIGITS28) > 0;
    }

    private BigInteger getIncrement(BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.ONE;
        if (bigInteger != null) {
            bigInteger2 = bigInteger;
        }
        return bigInteger2;
    }

    private BigInteger getMaxValue(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = MAX27;
        if (bigInteger2 != null) {
            bigInteger3 = bigInteger2;
        } else if (bigInteger.signum() < 0) {
            bigInteger3 = BigInteger.ONE.negate();
        }
        return bigInteger3;
    }

    private BigInteger getMinValue(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = BigInteger.ONE;
        if (bigInteger2 != null) {
            bigInteger3 = bigInteger2;
        } else if (bigInteger.signum() < 0) {
            bigInteger3 = MIN26;
        }
        return bigInteger3;
    }

    public void validateIncrement(Sequence sequence) throws ValidationException {
        BigInteger bigInteger = sequence.getIncrementBy();
        BigInteger bigInteger2 = sequence.getMinValue();
        BigInteger bigInteger3 = sequence.getMaxValue();
        int n = this.validateIncrement(bigInteger, bigInteger2, bigInteger3);
        switch (n) {
            case -3: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(61), sequence.getName()));
            }
            case -2: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(60), sequence.getName()));
            }
            case -4: {
                BigInteger bigInteger4 = this.getIncrement(bigInteger);
                BigInteger bigInteger5 = this.getMinValue(bigInteger4, bigInteger2);
                BigInteger bigInteger6 = this.getMaxValue(bigInteger4, bigInteger3);
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(62), this.formatBigInteger(bigInteger, bigInteger4), this.formatBigInteger(bigInteger2, bigInteger5), this.formatBigInteger(bigInteger3, bigInteger6)));
            }
        }
        if (1 != n) {
            // empty if block
        }
    }

    public int validateIncrement(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n = 1;
        if (bigInteger != null) {
            if (bigInteger.equals(BigInteger.ZERO)) {
                n = -2;
            } else if (this.tooBig(bigInteger)) {
                n = -3;
            } else {
                BigInteger bigInteger4 = bigInteger;
                BigInteger bigInteger5 = this.getMaxValue(bigInteger4, bigInteger3);
                BigInteger bigInteger6 = this.getMinValue(bigInteger4, bigInteger2);
                if (bigInteger4.abs().compareTo(bigInteger5.subtract(bigInteger6).abs()) >= 0) {
                    n = -4;
                }
            }
        }
        return n;
    }

    public void validateStartWith(Sequence sequence) throws ValidationException {
        BigInteger bigInteger = sequence.getIncrementBy();
        BigInteger bigInteger2 = this.getIncrement(bigInteger);
        BigInteger bigInteger3 = sequence.getStartWith();
        BigInteger bigInteger4 = sequence.getMinValue();
        BigInteger bigInteger5 = sequence.getMaxValue();
        int n = this.validateStartWith(bigInteger3, bigInteger, bigInteger4, bigInteger5);
        switch (n) {
            case -5: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(63), sequence.getName()));
            }
            case -6: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(64), bigInteger3, this.formatBigInteger(bigInteger4, this.getMinValue(bigInteger2, bigInteger4))));
            }
            case -7: {
                String string = bigInteger3.toString();
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(65), string, this.formatBigInteger(bigInteger5, this.getMaxValue(bigInteger2, bigInteger5))));
            }
        }
        if (1 != n) {
            // empty if block
        }
    }

    public int validateStartWith(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws ValidationException {
        int n = 1;
        if (bigInteger != null) {
            if (this.tooBig(bigInteger)) {
                n = -5;
            } else {
                BigInteger bigInteger5 = this.getIncrement(bigInteger2);
                BigInteger bigInteger6 = bigInteger;
                if (bigInteger5.signum() > 0) {
                    BigInteger bigInteger7 = this.getMinValue(bigInteger5, bigInteger3);
                    if (bigInteger6.compareTo(bigInteger7) < 0) {
                        n = -6;
                    }
                } else {
                    BigInteger bigInteger8 = this.getMaxValue(bigInteger5, bigInteger4);
                    if (bigInteger6.compareTo(bigInteger8) > 0) {
                        n = -7;
                    }
                }
            }
        }
        return n;
    }

    public void validateMinValue(Sequence sequence) throws ValidationException {
        BigInteger bigInteger = sequence.getStartWith();
        BigInteger bigInteger2 = sequence.getMinValue();
        BigInteger bigInteger3 = sequence.getMaxValue();
        int n = this.validateMinValue(bigInteger2, bigInteger, bigInteger3);
        switch (n) {
            case -8: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(68), sequence.getName()));
            }
            case -9: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(69), sequence.getMinValue(), sequence.getStartWith()));
            }
            case -10: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(70), sequence.getMinValue(), sequence.getMaxValue()));
            }
        }
        if (1 != n) {
            // empty if block
        }
    }

    public int validateMinValue(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws ValidationException {
        int n = 1;
        if (bigInteger != null) {
            if (this.tooBig(bigInteger)) {
                n = -8;
            } else {
                if (bigInteger2 != null && bigInteger.compareTo(bigInteger2) > 0) {
                    n = -9;
                }
                if (bigInteger3 != null && bigInteger.compareTo(bigInteger3) > 0) {
                    n = -10;
                }
            }
        }
        return n;
    }

    public void validateMaxValue(Sequence sequence) throws ValidationException {
        BigInteger bigInteger = sequence.getStartWith();
        BigInteger bigInteger2 = sequence.getMinValue();
        BigInteger bigInteger3 = sequence.getMaxValue();
        int n = this.validateMaxValue(bigInteger3, bigInteger, bigInteger2);
        switch (n) {
            case -11: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(71), sequence.getName()));
            }
            case -12: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(72), sequence.getMaxValue(), sequence.getStartWith()));
            }
            case -13: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(73), sequence.getMaxValue(), sequence.getMinValue()));
            }
        }
        if (1 != n) {
            // empty if block
        }
    }

    public int validateMaxValue(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws ValidationException {
        int n = 1;
        if (bigInteger != null) {
            if (this.tooBig(bigInteger)) {
                n = -11;
            } else {
                if (bigInteger2 != null && bigInteger.compareTo(bigInteger2) < 0) {
                    n = -12;
                }
                if (bigInteger3 != null && bigInteger.compareTo(bigInteger3) <= 0) {
                    n = -13;
                }
            }
        }
        return n;
    }

    public void validateCache(Sequence sequence) throws ValidationException {
        boolean bl;
        BigInteger bigInteger = sequence.getIncrementBy();
        BigInteger bigInteger2 = sequence.getCacheSize();
        BigInteger bigInteger3 = sequence.getMinValue();
        BigInteger bigInteger4 = sequence.getMaxValue();
        Boolean bl2 = sequence.getCycleFlag();
        boolean bl3 = bl = sequence.getCacheFlag() != null && sequence.getCacheFlag() != false;
        if (bl && bigInteger2 == null) {
            throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(75), "", sequence.getName()));
        }
        int n = this.validateCache(bigInteger2, bigInteger, bigInteger3, bigInteger4, bl2);
        switch (n) {
            case -14: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(74), sequence.getName()));
            }
            case -15: {
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(75), bigInteger2.toString()));
            }
            case -16: {
                BigInteger bigInteger5 = this.maxCacheSize(bigInteger, bigInteger3, bigInteger4);
                throw new ValidationException((DBObject)sequence, MessageFormat.format(DBArb.getString(76), bigInteger2.toString(), bigInteger5.toString()));
            }
        }
        if (1 != n) {
            // empty if block
        }
    }

    public int validateCache(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, Boolean bl) throws ValidationException {
        int n = 1;
        if (bigInteger != null) {
            BigInteger bigInteger5;
            if (this.tooBig(bigInteger)) {
                n = -14;
            } else if (bigInteger.compareTo(BigInteger.valueOf(2)) < 0) {
                n = -15;
            } else if (bl.equals(Boolean.TRUE) && bigInteger.compareTo(bigInteger5 = this.maxCacheSize(bigInteger2, bigInteger3, bigInteger4)) > 0) {
                n = -16;
            }
        }
        return n;
    }

    public BigInteger maxCacheSize(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = this.getIncrement(bigInteger);
        BigInteger bigInteger5 = this.getMaxValue(bigInteger4, bigInteger3);
        BigInteger bigInteger6 = this.getMinValue(bigInteger4, bigInteger2);
        BigInteger[] bigIntegerArray = bigInteger5.subtract(bigInteger6).abs().divideAndRemainder(bigInteger4.abs());
        BigInteger bigInteger7 = bigIntegerArray[0];
        if (bigIntegerArray[1].signum() > 0) {
            bigInteger7 = bigInteger7.add(BigInteger.ONE);
        }
        return bigInteger7;
    }
}

