/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.validators.RelationValidator;
import oracle.javatools.util.ModelUtil;

public class TableValidator
extends RelationValidator {
    public TableValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2) throws ValidationException {
        super.validateObject(dBObject, dBObject2);
        this.validateTable((Table)dBObject, (Table)dBObject2);
    }

    protected void validateTable(Table table, Table table2) throws ValidationException {
        this.validateConstraints(table, table2);
        this.validateColumns(table, table2);
        this.validateIndexes(table, table2);
        this.validateProperties(table, table2);
    }

    public void validateProperties(Table table, Table table2) throws ValidationException {
    }

    public void validateIndexes(Table table, Table table2) throws ValidationException {
        Index[] indexArray = table == null ? null : table.getIndexes();
        Index[] indexArray2 = table2.getIndexes();
        int n = 0;
        while (n < indexArray2.length) {
            DBObjectID dBObjectID = indexArray2[n].getID();
            while (dBObjectID != null && dBObjectID instanceof TemporaryObjectID) {
                try {
                    DBObject dBObject = ((TemporaryObjectID)dBObjectID).resolveOriginalID();
                    dBObjectID = dBObject == null ? null : dBObject.getID();
                }
                catch (Exception exception) {
                    DBUtil.logStackTrace(exception);
                }
            }
            Index index = null;
            if (dBObjectID != null && indexArray != null) {
                int n2 = 0;
                while (n2 < indexArray.length) {
                    if (ModelUtil.areEqual((Object)dBObjectID, (Object)indexArray[n2].getID())) {
                        index = indexArray[n2];
                        break;
                    }
                    ++n2;
                }
            }
            if (index == null) {
                this.getProvider().validateObject(indexArray2[n]);
            } else {
                this.getProvider().validateObject(index, indexArray2[n]);
            }
            ++n;
        }
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2, String string) throws ValidationException {
        if ("INDEX".equals(string)) {
            this.validateIndexes((Table)dBObject, (Table)dBObject2);
        } else {
            super.validateObject(dBObject, dBObject2, string);
        }
    }
}

