/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.View;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.validators.RelationValidator;

public class ViewValidator
extends RelationValidator {
    public ViewValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2) throws ValidationException {
        super.validateObject(dBObject, dBObject2);
        this.validateView((View)dBObject2);
    }

    public void validateView(View view) throws ValidationException {
        SQLQuery sQLQuery = view.getSQLQuery();
        if (sQLQuery == null) {
            throw new ValidationException((DBObject)view, "View must have a query");
        }
        if (sQLQuery instanceof DeclarativeSQLQuery) {
            try {
                SQLQueryBuilderFactory.createBuilder(this.getProvider(), view.getSchema(), sQLQuery);
            }
            catch (SQLQueryException sQLQueryException) {
                throw new ValidationException((DBObject)view, sQLQueryException.getMessage());
            }
        }
        try {
            SQLQuery sQLQuery2 = SQLQueryBuilderFactory.createQuery(this.getProvider(), view.getSchema(), sQLQuery.getSQLText());
        }
        catch (SQLParseException sQLParseException) {
            throw new ValidationException((DBObject)view, sQLParseException.getMessage());
        }
    }

    public void validateColumns(Relation relation, Relation relation2) throws ValidationException {
        super.validateColumns(relation, relation2);
    }
}

