/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.ant.taskdefs;

import oracle.ojc.compiler.Compiler;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Storage;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;

public class OjcAdapter
extends DefaultCompilerAdapter {
    public boolean execute() {
        this.attributes.log("Using OJC", 3);
        Commandline commandline = this.setupModernJavacCommand();
        this.setupLegacyOJCProperties(commandline);
        try {
            AntLog antLog = new AntLog();
            Compiler.main(commandline.getArguments(), antLog);
            antLog.printResults();
            return antLog.nerrors() == 0;
        }
        catch (Exception exception) {
            throw new BuildException("Error executing OJC", (Throwable)exception, this.location);
        }
    }

    protected boolean assumeJava11() {
        return false;
    }

    protected boolean assumeJava12() {
        return false;
    }

    protected boolean assumeJava13() {
        return false;
    }

    protected boolean assumeJava14() {
        return false;
    }

    protected boolean assumeJava15() {
        return true;
    }

    private void setupLegacyOJCProperties(Commandline commandline) {
        String string;
        String string2;
        if (this.getBooleanProperty("ojc.unused.import.warnings")) {
            commandline.createArgument().setValue("-warn:486");
        }
        if (this.getBooleanProperty("ojc.partially.used.import.warnings")) {
            commandline.createArgument().setValue("-warn:487");
        }
        if ((string2 = this.project.getProperty("ojc.quiet")) != null && (string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("no") || string2.equalsIgnoreCase("off"))) {
            commandline.createArgument().setValue("-noquiet");
        }
        if ((string = this.project.getProperty("ojc.exclude.class")) != null) {
            commandline.createArgument().setValue("-exclude");
            commandline.createArgument().setValue(string);
        }
    }

    private boolean getBooleanProperty(String string) {
        String string2 = this.project.getProperty(string);
        if (string2 != null) {
            return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("on");
        }
        return false;
    }

    private class AntLog
    implements Log {
        int nerr = 0;
        int nwarn = 0;

        private AntLog() {
        }

        public void redirect(String string) {
        }

        public void print(String string) {
            OjcAdapter.this.attributes.log(string);
        }

        public void println(String string) {
            OjcAdapter.this.attributes.log(string);
        }

        public void printError(Storage storage, int n, ErrorInfo errorInfo) {
            OjcAdapter.this.attributes.log(this.getMessage(storage, n, errorInfo, true), 0);
            ++this.nerr;
        }

        public void printWarning(Storage storage, int n, ErrorInfo errorInfo) {
            OjcAdapter.this.attributes.log(this.getMessage(storage, n, errorInfo, false), 1);
            ++this.nwarn;
        }

        private String getMessage(Storage storage, int n, ErrorInfo errorInfo, boolean bl) {
            String string = (bl ? "error #" : "warning #") + errorInfo.getNumber() + ": " + errorInfo.getMessage();
            String string2 = storage != null ? storage.getPath() + ":" + Scanner.positionToLine(n) + ": " + string : string;
            return string2;
        }

        public int nerrors() {
            return this.nerr;
        }

        public int nwarnings() {
            return this.nwarn;
        }

        public void printResults() {
            if (this.nerr > 1) {
                OjcAdapter.this.attributes.log(this.nerr + " errors");
            } else if (this.nerr > 0) {
                OjcAdapter.this.attributes.log("1 error");
            }
        }
    }
}

