/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.AnnotationElementValue;
import oracle.ojc.compiler.ArrayElementValue;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ElementValue;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionElementValue;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeSymbol;

class Annotation {
    Annotation next;
    int pos;
    TypeSymbol annotationType;
    ArrayList elmentValuePairs;
    private short typeIndex;
    boolean defaultValue;
    static final /* synthetic */ boolean $assertionsDisabled;

    Annotation(TypeSymbol typeSymbol, int n, boolean bl) {
        this.annotationType = typeSymbol;
        this.pos = n;
        this.defaultValue = bl;
        this.elmentValuePairs = new ArrayList();
    }

    void addExpressionElementValuePair(Identifier identifier, Expression expression, int n) {
        this.elmentValuePairs.add(new ExpressionElementValue(identifier, expression, n, this.defaultValue, false));
    }

    void addAnnotationElementValuePair(Identifier identifier, Annotation annotation, int n) {
        this.elmentValuePairs.add(new AnnotationElementValue(identifier, annotation, n, this.defaultValue, false));
    }

    void addArrayElementValuePair(Identifier identifier, ArrayList arrayList, int n) {
        this.elmentValuePairs.add(new ArrayElementValue(identifier, arrayList, n, this.defaultValue, false));
    }

    static boolean isSuppressedWarning(Parser parser, Symbol symbol, int n) {
        Annotation annotation = symbol.getAnnotations();
        while (annotation != null) {
            if (annotation.annotationType == parser.javaLangSuppressWarningsSymbol) {
                // empty if block
            }
            annotation = annotation.next;
        }
        return false;
    }

    private byte stringToTarget(String string) {
        if (string.equals("TYPE")) {
            return 1;
        }
        if (string.equals("FIELD")) {
            return 2;
        }
        if (string.equals("METHOD")) {
            return 4;
        }
        if (string.equals("PARAMETER")) {
            return 8;
        }
        if (string.equals("CONSTRUCTOR")) {
            return 16;
        }
        if (string.equals("LOCAL_VARIABLE")) {
            return 32;
        }
        if (string.equals("ANNOTATION_TYPE")) {
            return 64;
        }
        return -128;
    }

    void resolveAnnotationType(Parser parser, Symbol symbol) {
        Annotation annotation = this;
        while (annotation != null) {
            annotation.annotationType = annotation.annotationType.resolveType(parser, this.pos, false, true);
            if (!annotation.annotationType.isAnnotation()) {
                parser.error(Message.errorAnnotationExpected, this.pos, annotation.annotationType.isErroneous());
                annotation.annotationType = TypeSymbol.errorSymbol;
            } else {
                String string;
                ExpressionElementValue expressionElementValue;
                RawClassSymbol.AnnotationClassData annotationClassData;
                RawClassSymbol rawClassSymbol;
                RawClassSymbol rawClassSymbol2 = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                annotation.annotationType = rawClassSymbol2;
                if ((rawClassSymbol2.flags & 0x2000) == 0) {
                    if (!rawClassSymbol2.isAccessible(parser.currentClassSymbol)) {
                        parser.error(Message.errorAccessError, annotation.pos, false, rawClassSymbol2.errorName(), (rawClassSymbol2.access & 2) != 0 ? "private" : "protected", "");
                    }
                } else if (rawClassSymbol2 == parser.javaLangDeprecatedSymbol) {
                    symbol.deprecate();
                } else if (rawClassSymbol2 == parser.javaLangSuppressWarningsSymbol) {
                    symbol.symbolFlags = (byte)(symbol.symbolFlags | 1);
                } else if (rawClassSymbol2 == parser.javaLangOverrideSymbol) {
                    if (symbol instanceof MethodSymbol) {
                        ((MethodSymbol)symbol).flags = (short)(((MethodSymbol)symbol).flags | 0x80);
                    }
                } else if (rawClassSymbol2 == parser.javaLangAnnotationTargetSymbol) {
                    if (symbol instanceof RawClassSymbol && (rawClassSymbol = (RawClassSymbol)symbol).isAnnotation()) {
                        annotationClassData = (RawClassSymbol.AnnotationClassData)rawClassSymbol.cd;
                        annotationClassData.target = 0;
                        int n = annotation.elmentValuePairs.size();
                        for (int i = 0; i < n; ++i) {
                            try {
                                Object e = annotation.elmentValuePairs.get(i);
                                if (e instanceof ExpressionElementValue) {
                                    expressionElementValue = (ExpressionElementValue)e;
                                    string = ((FieldExpression)expressionElementValue.expr).field.identifier.toString();
                                    annotationClassData.target = (byte)(annotationClassData.target | this.stringToTarget(string));
                                    continue;
                                }
                                ArrayElementValue arrayElementValue = (ArrayElementValue)e;
                                ArrayList arrayList = arrayElementValue.arrayElements;
                                int n2 = arrayList.size();
                                for (int j = 0; j < n2; ++j) {
                                    expressionElementValue = (ExpressionElementValue)arrayList.get(j);
                                    string = ((FieldExpression)expressionElementValue.expr).field.identifier.toString();
                                    annotationClassData.target = (byte)(annotationClassData.target | this.stringToTarget(string));
                                }
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                } else if (rawClassSymbol2 == parser.javaLangAnnotationRetentionSymbol && symbol instanceof RawClassSymbol && (rawClassSymbol = (RawClassSymbol)symbol).isAnnotation()) {
                    annotationClassData = (RawClassSymbol.AnnotationClassData)rawClassSymbol.cd;
                    try {
                        expressionElementValue = (ExpressionElementValue)annotation.elmentValuePairs.get(0);
                        string = ((FieldExpression)expressionElementValue.expr).field.identifier.toString();
                        if (string.equals("SOURCE")) {
                            annotationClassData.retention = 0;
                        }
                        if (string.equals("CLASS")) {
                            annotationClassData.retention = 1;
                        }
                        annotationClassData.retention = (byte)2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            annotation = annotation.next;
        }
    }

    void resolveAndCheck(Parser parser, Symbol symbol) {
        RawClassSymbol rawClassSymbol;
        Annotation annotation = this;
        while (annotation != null) {
            TypeSymbol typeSymbol;
            annotation.annotationType = typeSymbol = annotation.annotationType.resolveType(parser, annotation.pos, false, true);
            if (!typeSymbol.isErroneous()) {
                rawClassSymbol = null;
                if (!annotation.defaultValue) {
                    rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                    if ((rawClassSymbol.flags & 0x1000) != 0) {
                        parser.error(Message.errorDuplicateAnnotation, annotation.pos, rawClassSymbol.isErroneous(), rawClassSymbol.errorName());
                    } else {
                        rawClassSymbol.flags = (short)(rawClassSymbol.flags | 0x1000);
                    }
                }
            }
            annotation = annotation.next;
        }
        annotation = this;
        while (annotation != null) {
            if (!annotation.annotationType.isErroneous() && !annotation.defaultValue) {
                rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                rawClassSymbol.flags = (short)(rawClassSymbol.flags & 0xFFFFEFFF);
            }
            annotation = annotation.next;
        }
        annotation = this;
        while (annotation != null) {
            if (!annotation.annotationType.isErroneous()) {
                MethodSymbol methodSymbol;
                rawClassSymbol = null;
                if (!annotation.defaultValue) {
                    rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                }
                int n = annotation.elmentValuePairs.size();
                for (int i = 0; i < n; ++i) {
                    ElementValue elementValue = (ElementValue)annotation.elmentValuePairs.get(i);
                    elementValue = elementValue.resolveAndCheck(parser, annotation);
                    annotation.elmentValuePairs.set(i, elementValue);
                    if (rawClassSymbol == null || (methodSymbol = (MethodSymbol)rawClassSymbol.classScope.lookupSpecificSymbolInScope(elementValue.elementName, 8, true)) == null) continue;
                    methodSymbol.flags = (short)(methodSymbol.flags | 0x10);
                }
                if (rawClassSymbol != null && rawClassSymbol.isAnnotation()) {
                    if (rawClassSymbol.isDeprecated() && !rawClassSymbol.isErroneous()) {
                        parser.warning(rawClassSymbol, Message.warningIsDeprecated, annotation.pos, rawClassSymbol.errorName());
                    }
                    methodSymbol = rawClassSymbol.cd.methodList;
                    while (methodSymbol != null) {
                        if ((methodSymbol.flags & 0x71) == 0) {
                            parser.error(Message.errorMissingValue, annotation.pos, false, methodSymbol.identifier.toString());
                        }
                        methodSymbol.flags = (short)(methodSymbol.flags & 0xFFFFFFEF);
                        methodSymbol = methodSymbol.nextInClass;
                    }
                }
                if (!annotation.defaultValue && symbol != null) {
                    rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                    if ((symbol.getAnnotationTarget() & rawClassSymbol.cd.getAnnotationTarget()) == 0) {
                        parser.error(Message.errorAnnotationIllegalTarget, annotation.pos, rawClassSymbol.isErroneous(), rawClassSymbol.errorName(), symbol.kindName());
                    }
                }
            }
            annotation = annotation.next;
        }
    }

    void generateConstantPoolEntries(ClassFileWriter classFileWriter, ConstantPool constantPool) {
        Annotation annotation = this;
        while (annotation != null) {
            RawClassSymbol rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
            if (!($assertionsDisabled || rawClassSymbol != null && rawClassSymbol.cd instanceof RawClassSymbol.AnnotationClassData)) {
                throw new AssertionError();
            }
            byte by = rawClassSymbol.cd.getAnnotationRetention();
            if (by > 0) {
                if (annotation.defaultValue) {
                    if (classFileWriter.annotationDefaultAttrIndex == 0) {
                        classFileWriter.annotationDefaultAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.annotationDefaultAttribute.name);
                    }
                } else {
                    if (by == 1) {
                        if (classFileWriter.runtimeInvisibleAnnotationAttrIndex == 0) {
                            classFileWriter.runtimeInvisibleAnnotationAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.runtimeInvisibleAnnotationAttribute.name);
                        }
                    } else if (classFileWriter.runtimeVisibleAnnotationAttrIndex == 0) {
                        classFileWriter.runtimeVisibleAnnotationAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.runtimeVisibleAnnotationAttribute.name);
                    }
                    annotation.typeIndex = constantPool.enterConstantPoolUtf8(annotation.annotationType.getSignature());
                }
                int n = annotation.elmentValuePairs.size();
                for (int i = 0; i < n; ++i) {
                    ElementValue elementValue = (ElementValue)annotation.elmentValuePairs.get(i);
                    elementValue.generateConstantPoolEntries(classFileWriter, constantPool);
                }
            }
            annotation = annotation.next;
        }
    }

    static void generateConstantPoolEntries(MethodSymbol methodSymbol, ClassFileWriter classFileWriter, ConstantPool constantPool) {
        int n = methodSymbol.actualArgCount;
        for (int i = 0; i < n; ++i) {
            MethodVariableSymbol methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
            if (methodVariableSymbol == null) continue;
            Annotation annotation = methodVariableSymbol.annotation;
            while (annotation != null) {
                RawClassSymbol rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                byte by = rawClassSymbol.cd.getAnnotationRetention();
                if (by > 0) {
                    if (by == 1) {
                        if (classFileWriter.runtimeInvisibleParameterAnnotationAttrIndex == 0) {
                            classFileWriter.runtimeInvisibleParameterAnnotationAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.runtimeInvisibleParameterAnnotationAttribute.name);
                        }
                    } else if (classFileWriter.runtimeVisibleParameterAnnotationAttrIndex == 0) {
                        classFileWriter.runtimeVisibleParameterAnnotationAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.runtimeVisibleParameterAnnotationAttribute.name);
                    }
                    annotation.typeIndex = constantPool.enterConstantPoolUtf8(annotation.annotationType.getSignature());
                    int n2 = annotation.elmentValuePairs.size();
                    for (int j = 0; j < n2; ++j) {
                        ElementValue elementValue = (ElementValue)annotation.elmentValuePairs.get(j);
                        elementValue.generateConstantPoolEntries(classFileWriter, constantPool);
                    }
                }
                annotation = annotation.next;
            }
        }
    }

    int getAttibuteCount() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Annotation annotation = this;
        while (annotation != null) {
            RawClassSymbol rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
            byte by = rawClassSymbol.cd.getAnnotationRetention();
            if (by > 0) {
                if (annotation.defaultValue) {
                    bl = true;
                } else if (by == 1) {
                    bl3 = true;
                } else {
                    bl2 = true;
                }
            }
            annotation = annotation.next;
        }
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl3) {
            ++n;
        }
        if (bl2) {
            ++n;
        }
        return n;
    }

    static int getAttibuteCount(MethodSymbol methodSymbol) {
        boolean bl = false;
        boolean bl2 = false;
        int n = methodSymbol.actualArgCount;
        for (int i = 0; i < n; ++i) {
            MethodVariableSymbol methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
            if (methodVariableSymbol == null) continue;
            Annotation annotation = methodVariableSymbol.annotation;
            while (annotation != null) {
                RawClassSymbol rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                byte by = rawClassSymbol.cd.getAnnotationRetention();
                if (by > 0) {
                    if (by == 1) {
                        bl2 = true;
                    } else {
                        bl = true;
                    }
                }
                annotation = annotation.next;
            }
        }
        int n2 = 0;
        if (bl2) {
            ++n2;
        }
        if (bl) {
            ++n2;
        }
        return n2;
    }

    int getAttributeLength() {
        int n = this.elmentValuePairs.size();
        int n2 = 4;
        while (--n >= 0) {
            ElementValue elementValue = (ElementValue)this.elmentValuePairs.get(n);
            n2 += elementValue.getAttributeLength();
        }
        return n2;
    }

    void writeAnnotation(ClassFileWriter classFileWriter) throws IOException {
        int n = this.elmentValuePairs.size();
        int n2 = classFileWriter.ensureWriteBufferCapacity(4);
        byte[] byArray = classFileWriter.writeBuffer;
        byArray[n2 + 3] = (byte)n;
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 1] = (byte)this.typeIndex;
        byArray[n2] = (byte)(this.typeIndex >> 8);
        classFileWriter.writeBufferIndex = n2 + 4;
        for (int i = 0; i < n; ++i) {
            ElementValue elementValue = (ElementValue)this.elmentValuePairs.get(i);
            elementValue.write(classFileWriter);
        }
    }

    void write(ClassFileWriter classFileWriter) throws IOException {
        byte[] byArray;
        int n;
        short s;
        byte by;
        RawClassSymbol rawClassSymbol;
        ElementValue elementValue = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 2;
        int n5 = 2;
        Annotation annotation = this;
        while (annotation != null) {
            rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
            by = rawClassSymbol.cd.getAnnotationRetention();
            if (annotation.defaultValue) {
                if (!$assertionsDisabled && annotation.elmentValuePairs.size() != 1) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && by < 1) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && elementValue != null) {
                    throw new AssertionError();
                }
                elementValue = (ElementValue)annotation.elmentValuePairs.get(0);
            } else {
                switch (by) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        n4 += annotation.getAttributeLength();
                        n2 = (short)(n2 + 1);
                        break;
                    }
                    case 2: {
                        n5 += annotation.getAttributeLength();
                        n3 = (short)(n3 + 1);
                    }
                }
            }
            annotation = annotation.next;
        }
        if (n2 > 0) {
            s = classFileWriter.runtimeInvisibleAnnotationAttrIndex;
            n = classFileWriter.ensureWriteBufferCapacity(8);
            byArray = classFileWriter.writeBuffer;
            byArray[n + 7] = (byte)n2;
            byArray[n + 6] = (byte)(n2 >> 8);
            byArray[n + 5] = (byte)n4;
            byArray[n + 4] = (byte)(n4 >> 8);
            byArray[n + 3] = (byte)(n4 >> 16);
            byArray[n + 2] = (byte)(n4 >> 24);
            byArray[n + 1] = (byte)s;
            byArray[n] = (byte)(s >> 8);
            classFileWriter.writeBufferIndex = n + 8;
            annotation = this;
            while (annotation != null) {
                if (!annotation.defaultValue) {
                    rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                    by = rawClassSymbol.cd.getAnnotationRetention();
                    if (by == 1) {
                        annotation.writeAnnotation(classFileWriter);
                    }
                }
                annotation = annotation.next;
            }
        }
        if (n3 > 0) {
            s = classFileWriter.runtimeVisibleAnnotationAttrIndex;
            n = classFileWriter.ensureWriteBufferCapacity(8);
            byArray = classFileWriter.writeBuffer;
            byArray[n + 7] = (byte)n3;
            byArray[n + 6] = (byte)(n3 >> 8);
            byArray[n + 5] = (byte)n5;
            byArray[n + 4] = (byte)(n5 >> 8);
            byArray[n + 3] = (byte)(n5 >> 16);
            byArray[n + 2] = (byte)(n5 >> 24);
            byArray[n + 1] = (byte)s;
            byArray[n] = (byte)(s >> 8);
            classFileWriter.writeBufferIndex = n + 8;
            annotation = this;
            while (annotation != null) {
                if (!annotation.defaultValue) {
                    rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                    by = rawClassSymbol.cd.getAnnotationRetention();
                    if (by == 2) {
                        annotation.writeAnnotation(classFileWriter);
                    }
                }
                annotation = annotation.next;
            }
        }
        if (elementValue != null) {
            int n6 = elementValue.getAttributeLength();
            s = classFileWriter.annotationDefaultAttrIndex;
            n = classFileWriter.ensureWriteBufferCapacity(6);
            byArray = classFileWriter.writeBuffer;
            byArray[n + 5] = (byte)n6;
            byArray[n + 4] = (byte)(n6 >> 8);
            byArray[n + 3] = (byte)(n6 >> 16);
            byArray[n + 2] = (byte)(n6 >> 24);
            byArray[n + 1] = (byte)s;
            byArray[n] = (byte)(s >> 8);
            classFileWriter.writeBufferIndex = n + 6;
            elementValue.write(classFileWriter);
        }
    }

    static void write(MethodSymbol methodSymbol, ClassFileWriter classFileWriter) throws IOException {
        int n;
        byte[] byArray;
        int n2;
        short s;
        byte by;
        RawClassSymbol rawClassSymbol;
        Annotation annotation;
        MethodVariableSymbol methodVariableSymbol;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = methodSymbol.actualArgCount;
        for (n3 = 0; n3 < n6; ++n3) {
            methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(n3);
            if (methodVariableSymbol == null) continue;
            int n7 = 2;
            int n8 = 2;
            annotation = methodVariableSymbol.annotation;
            while (annotation != null) {
                rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                by = rawClassSymbol.cd.getAnnotationRetention();
                switch (by) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        n4 += annotation.getAttributeLength() + n7;
                        n7 = 0;
                        break;
                    }
                    case 2: {
                        n5 += annotation.getAttributeLength() + n8;
                        n8 = 0;
                    }
                }
                annotation = annotation.next;
            }
        }
        if (n4 > 0) {
            s = classFileWriter.runtimeInvisibleParameterAnnotationAttrIndex;
            n2 = classFileWriter.ensureWriteBufferCapacity(7);
            byArray = classFileWriter.writeBuffer;
            byArray[n2 + 6] = (byte)methodSymbol.argCount;
            byArray[n2 + 5] = (byte)(++n4);
            byArray[n2 + 4] = (byte)(n4 >> 8);
            byArray[n2 + 3] = (byte)(n4 >> 16);
            byArray[n2 + 2] = (byte)(n4 >> 24);
            byArray[n2 + 1] = (byte)s;
            byArray[n2] = (byte)(s >> 8);
            classFileWriter.writeBufferIndex = n2 + 7;
            for (n3 = 0; n3 < n6; ++n3) {
                methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(n3);
                if (methodVariableSymbol == null) continue;
                n = 0;
                annotation = methodVariableSymbol.annotation;
                while (annotation != null) {
                    if (!annotation.defaultValue) {
                        rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                        by = rawClassSymbol.cd.getAnnotationRetention();
                        if (by == 1) {
                            n = (short)(n + 1);
                        }
                    }
                    annotation = annotation.next;
                }
                n2 = classFileWriter.ensureWriteBufferCapacity(2);
                byArray = classFileWriter.writeBuffer;
                byArray[n2 + 1] = (byte)n;
                byArray[n2] = (byte)(n >> 8);
                classFileWriter.writeBufferIndex = n2 + 2;
                if (n <= 0) continue;
                annotation = methodVariableSymbol.annotation;
                while (annotation != null) {
                    if (!annotation.defaultValue) {
                        rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                        by = rawClassSymbol.cd.getAnnotationRetention();
                        if (by == 1) {
                            annotation.writeAnnotation(classFileWriter);
                        }
                    }
                    annotation = annotation.next;
                }
            }
        }
        if (n5 > 0) {
            s = classFileWriter.runtimeVisibleParameterAnnotationAttrIndex;
            n2 = classFileWriter.ensureWriteBufferCapacity(7);
            byArray = classFileWriter.writeBuffer;
            byArray[n2 + 6] = (byte)methodSymbol.argCount;
            byArray[n2 + 5] = (byte)(++n5);
            byArray[n2 + 4] = (byte)(n5 >> 8);
            byArray[n2 + 3] = (byte)(n5 >> 16);
            byArray[n2 + 2] = (byte)(n5 >> 24);
            byArray[n2 + 1] = (byte)s;
            byArray[n2] = (byte)(s >> 8);
            classFileWriter.writeBufferIndex = n2 + 7;
            for (n3 = 0; n3 < n6; ++n3) {
                methodVariableSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(n3);
                if (methodVariableSymbol == null) continue;
                n = 0;
                annotation = methodVariableSymbol.annotation;
                while (annotation != null) {
                    if (!annotation.defaultValue) {
                        rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                        by = rawClassSymbol.cd.getAnnotationRetention();
                        if (by == 2) {
                            n = (short)(n + 1);
                        }
                    }
                    annotation = annotation.next;
                }
                n2 = classFileWriter.ensureWriteBufferCapacity(2);
                byArray = classFileWriter.writeBuffer;
                byArray[n2 + 1] = (byte)n;
                byArray[n2] = (byte)(n >> 8);
                classFileWriter.writeBufferIndex = n2 + 2;
                if (n <= 0) continue;
                annotation = methodVariableSymbol.annotation;
                while (annotation != null) {
                    if (!annotation.defaultValue) {
                        rawClassSymbol = ((ClassSymbol)annotation.annotationType).getClassSymbol();
                        by = rawClassSymbol.cd.getAnnotationRetention();
                        if (by == 2) {
                            annotation.writeAnnotation(classFileWriter);
                        }
                    }
                    annotation = annotation.next;
                }
            }
        }
    }

    static {
        $assertionsDisabled = !Annotation.class.desiredAssertionStatus();
    }
}

