/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ArrayExpression;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionList;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class ArrayInitializerExpression
extends Expression {
    Expression arrayExpr;
    ExpressionList initializers;

    ArrayInitializerExpression(Expression expression, ExpressionList expressionList) {
        super((byte)50, 0);
        this.arrayExpr = expression;
        this.initializers = expressionList;
    }

    /*
     * Enabled aggressive block sorting
     */
    Expression resolveAndCheck(Parser parser) {
        this.arrayExpr = this.arrayExpr.resolveAndCheck(parser);
        TypeSymbol typeSymbol = this.arrayExpr.getType();
        if (typeSymbol.isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
        TypeSymbol typeSymbol2 = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
        ExpressionList expressionList = this.initializers;
        while (true) {
            block23: {
                if (expressionList == null) {
                    this.setType(this.arrayExpr.getType());
                    return this;
                }
                if (expressionList.expr.takeAssignmentContext()) {
                    parser.assignmentContext = typeSymbol2;
                }
                Expression expression = expressionList.expr.resolveAndCheck(parser);
                TypeSymbol typeSymbol3 = expression.getType();
                if (!typeSymbol2.isErroneous() && !typeSymbol3.isErroneous()) {
                    if ((typeSymbol2.typeClass & 0xFFFFFFC0) != 0) {
                        if ((typeSymbol3.typeClass & 0xFFFFFFC0) == 0) {
                            if (parser.options.sourceJDKVersion >= 150 && typeSymbol3.isPrimitiveType() && BoxingExpression.getPrimitiveType(parser, typeSymbol2) != null) {
                                expressionList.expr = expression.promoteType(parser, typeSymbol2);
                                break block23;
                            } else {
                                Error error = parser.error(Message.errorIncompatibleTypes, expression.pos, false, typeSymbol3.errorName(), typeSymbol2.errorName());
                                return new ErrorExpression(error);
                            }
                        }
                        ReferenceTypeSymbol referenceTypeSymbol = (ReferenceTypeSymbol)typeSymbol2;
                        ReferenceTypeSymbol referenceTypeSymbol2 = (ReferenceTypeSymbol)typeSymbol3;
                        if (referenceTypeSymbol.isTypeParameter()) {
                            if (referenceTypeSymbol2 != referenceTypeSymbol && referenceTypeSymbol2 != ReferenceTypeSymbol.nullTypeSymbol) {
                                Error error = parser.error(Message.errorIncompatibleTypes, expression.pos, false, typeSymbol3.errorName(), typeSymbol2.errorName());
                                return new ErrorExpression(error);
                            }
                        } else if (referenceTypeSymbol2.isTypeParameter()) {
                            referenceTypeSymbol2 = ((TypeParameterSymbol)referenceTypeSymbol2).bound;
                        }
                        if (!referenceTypeSymbol2.isAssignmentCompatible(parser, referenceTypeSymbol)) {
                            Error error = parser.error(Message.errorIncompatibleTypes, expression.pos, false, typeSymbol3.errorName(), typeSymbol2.errorName());
                            return new ErrorExpression(error);
                        }
                        typeSymbol2.checkUncheckConversion(parser, expression.pos, typeSymbol3, false);
                        expressionList.expr = expression.promoteType(parser, typeSymbol2);
                    } else if ((typeSymbol2.typeClass & 2) != 0) {
                        if ((typeSymbol3.typeClass & 2) == 0) {
                            if (parser.options.sourceJDKVersion >= 150 && typeSymbol3.isReferenceType() && BoxingExpression.getPrimitiveType(parser, typeSymbol3) != null) {
                                expressionList.expr = expression.promoteType(parser, typeSymbol2);
                            } else {
                                Error error = parser.error(Message.errorIncompatibleTypes, expression.pos, false, typeSymbol3.errorName(), typeSymbol2.errorName());
                                return new ErrorExpression(error);
                            }
                        }
                    } else {
                        if ((typeSymbol3.typeClass & 0xFFFFFFC2) != 0) {
                            if (parser.options.sourceJDKVersion >= 150 && typeSymbol3.isReferenceType() && BoxingExpression.getPrimitiveType(parser, typeSymbol3) != null) {
                                expressionList.expr = expression.promoteType(parser, typeSymbol2);
                            } else {
                                Error error = parser.error(Message.errorIncompatibleTypes, expression.pos, false, typeSymbol3.errorName(), typeSymbol2.errorName());
                                return new ErrorExpression(error);
                            }
                        }
                        expressionList.expr = expression.promoteType(parser, typeSymbol2);
                    }
                }
            }
            expressionList = expressionList.next;
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.arrayExpr.generateByteCode(byteCodeGenerator);
        TypeSymbol typeSymbol = this.arrayExpr.getType();
        ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
        TypeSymbol typeSymbol2 = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
        int n = 0;
        ExpressionList expressionList = this.initializers;
        while (expressionList != null) {
            byteCodeGenerator.generate_8((byte)89);
            byteCodeGenerator.incOpStackHeight(1);
            IntConstantExpression.generateByteCodeIntConstant(byteCodeGenerator, n);
            Expression expression = expressionList.expr;
            expression.generateByteCode(byteCodeGenerator);
            byteCodeGenerator.generate_8(ArrayExpression.astore_opcode[typeSymbol2.typeKind]);
            byteCodeGenerator.decOpStackHeight((typeSymbol2.typeClass & 0x28) != 0 ? 4 : 3);
            ++n;
            expressionList = expressionList.next;
        }
    }
}

