/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;

final class ArraySymbol
extends ReferenceTypeSymbol {
    TypeSymbol baseType;
    int dimension;
    char[] signature;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ArraySymbol(int n, TypeSymbol typeSymbol, int n2) {
        super(n, typeSymbol.identifier, (byte)11, typeSymbol.access, null);
        this.baseType = typeSymbol;
        this.dimension = n2;
    }

    boolean isErroneous() {
        return this.baseType.isErroneous();
    }

    String errorName() {
        if (this.isErroneous()) {
            return "";
        }
        return Message.arrayString + " " + this.toString();
    }

    char[] getSignature() {
        if (this.signature == null) {
            char[] cArray = this.baseType.getSignature();
            int n = this.dimension;
            int n2 = n + cArray.length;
            this.signature = new char[n2];
            System.arraycopy(cArray, 0, this.signature, n, cArray.length);
            while (--n >= 0) {
                this.signature[n] = 91;
            }
        }
        return this.signature;
    }

    protected void toString(StringBuffer stringBuffer) {
        this.baseType.toString(stringBuffer);
        int n = this.dimension;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("[]");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    boolean equalTo(TypeSymbol typeSymbol, TypeSymbol typeSymbol2) {
        if (typeSymbol instanceof ArraySymbol) {
            ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
            if (arraySymbol.dimension != this.dimension) {
                return false;
            }
            return this.baseType.equalTo(arraySymbol.baseType, typeSymbol2);
        }
        return false;
    }

    TypeSymbol resolveType(Parser parser, int n, boolean bl, boolean bl2) {
        return ArraySymbol.getArrayType(this.baseType.resolveType(parser, n, bl, bl2), this.dimension);
    }

    boolean isUnresolvedType() {
        return this.baseType.isUnresolvedType();
    }

    boolean isArrayType() {
        return true;
    }

    boolean isReifiable() {
        return this.baseType.isReifiable();
    }

    boolean involvesGenerics() {
        return this.baseType.involvesGenerics();
    }

    void checkDeprecated(Parser parser, int n) {
        this.baseType.checkDeprecated(parser, n);
    }

    boolean involvesTypeParameter() {
        return this.baseType.involvesTypeParameter();
    }

    boolean containsTypeParameterDefinedBy(Symbol symbol) {
        return this.baseType.containsTypeParameterDefinedBy(symbol);
    }

    boolean containsTypeParameter(TypeParameterSymbol typeParameterSymbol) {
        return this.baseType.containsTypeParameter(typeParameterSymbol);
    }

    void getTypeParameterSymbol(ArrayList arrayList) {
        this.baseType.getTypeParameterSymbol(arrayList);
    }

    void changeScope(Scope scope) {
        this.baseType.changeScope(scope);
    }

    TypeSymbol replaceUnresolvedTypeParameters(TypeParameterList typeParameterList) {
        this.baseType.replaceUnresolvedTypeParameters(typeParameterList);
        return this;
    }

    TypeSymbol replaceTypeParameters(TypeParameterList typeParameterList) {
        TypeSymbol typeSymbol = this.baseType.replaceTypeParameters(typeParameterList);
        if (typeSymbol != this.baseType) {
            return ArraySymbol.getArrayType(typeSymbol, this.dimension);
        }
        return this;
    }

    TypeSymbol applyTypeVariables(TypeParameterList typeParameterList, TypeVariableList typeVariableList, boolean bl) {
        TypeSymbol typeSymbol = this.baseType.applyTypeVariables(typeParameterList, typeVariableList, true);
        if (typeSymbol != this.baseType) {
            return ArraySymbol.getArrayType(typeSymbol, this.dimension);
        }
        return this;
    }

    TypeSymbol eraseType() {
        TypeSymbol typeSymbol = this.baseType.eraseType();
        if (typeSymbol != this.baseType) {
            return ArraySymbol.getArrayType(typeSymbol, this.dimension);
        }
        return this;
    }

    static TypeSymbol getArrayType(TypeSymbol typeSymbol, int n) {
        TypeSymbol typeSymbol2;
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (typeSymbol.isArrayType()) {
            ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
            n += arraySymbol.dimension;
            typeSymbol = arraySymbol.baseType;
        }
        TypeSymbol[] typeSymbolArray = typeSymbol.arrayTypes;
        if (typeSymbol.arrayTypes == null) {
            typeSymbolArray = new TypeSymbol[n < 10 ? 10 : n + 1];
            typeSymbolArray[0] = typeSymbol;
            if (n == 0) {
                typeSymbol2 = typeSymbol;
            } else {
                typeSymbolArray[n] = typeSymbol2 = new ArraySymbol(typeSymbol.pos, typeSymbol, n);
            }
            typeSymbol.arrayTypes = typeSymbolArray;
        } else if (typeSymbolArray.length <= n) {
            typeSymbolArray = new TypeSymbol[n + 5];
            System.arraycopy(typeSymbol.arrayTypes, 0, typeSymbolArray, 0, typeSymbol.arrayTypes.length);
            typeSymbolArray[n] = typeSymbol2 = new ArraySymbol(typeSymbol.pos, typeSymbol, n);
        } else if (typeSymbolArray[n] == null) {
            typeSymbolArray[n] = typeSymbol2 = new ArraySymbol(typeSymbol.pos, typeSymbol, n);
        } else {
            typeSymbol2 = typeSymbolArray[n];
        }
        return typeSymbol2;
    }

    static {
        $assertionsDisabled = !ArraySymbol.class.desiredAssertionStatus();
    }
}

