/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TypeSymbol;

final class AssertStatement
extends Statement {
    Expression assertion;
    Expression detail;
    StatementList bodyStatements;

    AssertStatement(StatementList statementList, int n, Parser parser, Expression expression, Expression expression2) {
        super(statementList, n, (byte)18);
        this.assertion = expression;
        this.detail = expression2;
        RawClassSymbol rawClassSymbol = parser.currentClassSymbol;
        if ((rawClassSymbol.flags & 1) == 0) {
            rawClassSymbol.flags = (short)(rawClassSymbol.flags | 1);
            if (parser.options.targetJDKVersion >= 150) {
                Identifier.assertionsDisabledInternal = Identifier.getIdentifier(Identifier.dollarString + "assertionsDisabled");
            }
            parser.addSyntheticField(rawClassSymbol, Identifier.assertionsDisabledInternal, TypeSymbol.booleanSymbol, (short)24);
            if (parser.options.targetJDKVersion < 150) {
                parser.addSyntheticField(rawClassSymbol, Identifier.classObjectInternal, parser.javaLangClassSymbol, (short)8);
                rawClassSymbol.flags = (short)(rawClassSymbol.flags | 8);
            }
            rawClassSymbol.getClassInitializer();
        }
    }

    void resolveAndCheck(Parser parser) {
        Expression expression = this.assertion;
        expression = expression.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        byte by = typeSymbol.typeKind;
        if (by != 2) {
            parser.error(Message.errorIncompatibleTypes, expression.pos, by == 0, typeSymbol.errorName(), "boolean");
        }
        this.assertion = expression;
        expression = this.detail;
        if (expression != null) {
            typeSymbol = (expression = expression.resolveAndCheck(parser)).getType();
            if (typeSymbol == TypeSymbol.voidSymbol) {
                parser.error(Message.errorTypeNotAllowed, expression.pos, false, typeSymbol.errorName());
            }
            this.detail = expression;
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        int n;
        BooleanConstantExpression booleanConstantExpression = null;
        Expression expression = this.assertion;
        if (expression.kind == 2) {
            booleanConstantExpression = (BooleanConstantExpression)expression;
            if (booleanConstantExpression.bval) {
                return;
            }
        }
        Label label = new Label();
        RawClassSymbol rawClassSymbol = byteCodeGenerator.methodSymbol.definingClass;
        short s = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(rawClassSymbol.getInternalName(), Identifier.assertionsDisabledInternal.name, Identifier.booleanSignature.name);
        byteCodeGenerator.generate_8_16((byte)-78, s);
        byteCodeGenerator.generateBranch_ifne(label);
        if (booleanConstantExpression == null) {
            expression.generateByteCodeBranch(byteCodeGenerator, label, false);
        }
        s = byteCodeGenerator.constantPool.enterConstantPoolClass(Identifier.javaLangAssertionErrorInternal.name);
        byteCodeGenerator.generate_8_16_8((byte)-69, s, (byte)89);
        byteCodeGenerator.incOpStackHeight(2);
        if (this.detail != null) {
            char[] cArray;
            this.detail.generateByteCode(byteCodeGenerator);
            switch (this.detail.getType().typeKind) {
                default: {
                    cArray = Identifier.voidMethodObjectSignature.name;
                    n = 3;
                    break;
                }
                case 2: {
                    cArray = Identifier.voidMethodBooleanSignature.name;
                    n = 3;
                    break;
                }
                case 4: {
                    cArray = Identifier.voidMethodCharSignature.name;
                    n = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    cArray = Identifier.voidMethodIntSignature.name;
                    n = 3;
                    break;
                }
                case 7: {
                    cArray = Identifier.voidMethodLongSignature.name;
                    n = 4;
                    break;
                }
                case 8: {
                    cArray = Identifier.voidMethodFloatSignature.name;
                    n = 3;
                    break;
                }
                case 9: {
                    cArray = Identifier.voidMethodDoubleSignature.name;
                    n = 4;
                }
            }
            s = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(Identifier.javaLangAssertionErrorInternal.name, Identifier.initializerIdentifier.name, cArray);
        } else {
            s = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(Identifier.javaLangAssertionErrorInternal.name, Identifier.initializerIdentifier.name, Identifier.voidMethodSignature.name);
            n = 2;
        }
        byteCodeGenerator.generate_8_16_8((byte)-73, s, (byte)-65);
        byteCodeGenerator.setLabel(label);
        byteCodeGenerator.decOpStackHeight(n);
    }
}

