/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class AssignmentBitOperationExpression
extends BinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    AssignmentBitOperationExpression(byte by, int n, Expression expression, Expression expression2) {
        super(by, n, expression, expression2);
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        Expression expression = this.leftOperand;
        byte by = expression.kind;
        if (by != 1 && by != 3) {
            parser.error(Message.errorDifferentKindRequired, expression.pos, by == 0, Message.variableString, Message.valueString);
        }
        expression = expression.resolveAndCheckReadBeforeWrite(parser);
        by = expression.kind;
        if (by != 1 && by != 3) {
            parser.error(Message.errorDifferentKindRequired, this.leftOperand.pos, by == 0, Message.variableString, Message.valueString);
        }
        Expression expression2 = this.rightOperand;
        expression2 = expression2.resolveAndCheck(parser);
        TypeSymbol typeSymbol2 = expression.getType();
        TypeSymbol typeSymbol3 = expression2.getType();
        if ((typeSymbol2.typeKind != 2 || typeSymbol3.typeKind != 2) && (typeSymbol = TypeSymbol.binaryNumericPromotion(parser, typeSymbol2, typeSymbol3)).isErroneous() && (parser.options.sourceJDKVersion < 150 || typeSymbol2 != TypeSymbol.booleanSymbol && !typeSymbol2.equalTo(parser.javaLangBooleanSymbol) || typeSymbol3 != TypeSymbol.booleanSymbol && !typeSymbol3.equalTo(parser.javaLangBooleanSymbol))) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol3.isErroneous() | typeSymbol2.isErroneous(), this.toString(), typeSymbol2.errorName() + " " + Message.andString + " " + typeSymbol3.errorName());
            return new ErrorExpression(error);
        }
        this.setType(typeSymbol2);
        this.leftOperand = expression;
        this.rightOperand = expression2;
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator, byte by, byte by2) {
        TypeSymbol typeSymbol;
        Expression expression = this.leftOperand;
        expression.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
        TypeSymbol typeSymbol2 = expression.getType();
        TypeSymbol typeSymbol3 = null;
        if (typeSymbol2.isReferenceType()) {
            typeSymbol3 = BoxingExpression.getPrimitiveType(byteCodeGenerator.parser, typeSymbol2);
            AutoUnboxingExpression.generateByteCode(byteCodeGenerator, typeSymbol2, typeSymbol3);
            typeSymbol2 = typeSymbol3;
        }
        Expression expression2 = this.rightOperand;
        TypeSymbol typeSymbol4 = expression2.getType();
        if ((typeSymbol2.typeClass & 2) != 0) {
            expression2.generateByteCode(byteCodeGenerator);
            if (typeSymbol4.isReferenceType()) {
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, typeSymbol4, TypeSymbol.booleanSymbol);
            }
            byteCodeGenerator.generate_8(by);
            byteCodeGenerator.decOpStackHeight(1);
            typeSymbol = TypeSymbol.booleanSymbol;
            int n = 2;
        } else {
            typeSymbol = TypeSymbol.binaryNumericPromotion(byteCodeGenerator.parser, typeSymbol2, typeSymbol4);
            byte by3 = typeSymbol.typeClass;
            byteCodeGenerator.generateWideningPrimitiveConversion(typeSymbol2.typeClass, by3);
            expression2.generateByteCode(byteCodeGenerator);
            if (typeSymbol4.isReferenceType()) {
                TypeSymbol typeSymbol5 = BoxingExpression.getPrimitiveType(byteCodeGenerator.parser, typeSymbol4);
                AutoUnboxingExpression.generateByteCode(byteCodeGenerator, typeSymbol4, typeSymbol5);
                typeSymbol4 = typeSymbol5;
            }
            byteCodeGenerator.generateWideningPrimitiveConversion(typeSymbol4.typeClass, by3);
            switch (by3) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 4: {
                    byteCodeGenerator.generate_8(by);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 8: {
                    byteCodeGenerator.generate_8(by2);
                    byteCodeGenerator.decOpStackHeight(2);
                }
            }
            byteCodeGenerator.generateNarrowingPrimitiveConversion(by3, typeSymbol2.typeKind);
        }
        if (typeSymbol3 != null) {
            AutoBoxingExpression.generateByteCode(byteCodeGenerator, typeSymbol, expression.getType());
        }
        if (this.getType().typeKind != 1) {
            if ((expression.getType().typeClass & 0x28) != 0) {
                if (expression.kind == 3) {
                    byteCodeGenerator.generate_8((byte)94);
                } else if (expression instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)92);
                } else {
                    FieldSymbol fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                    if ((fieldSymbol.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)92);
                    } else {
                        byteCodeGenerator.generate_8((byte)93);
                    }
                }
                byteCodeGenerator.incOpStackHeight(2);
            } else {
                if (expression.kind == 3) {
                    byteCodeGenerator.generate_8((byte)91);
                } else if (expression instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)89);
                } else {
                    FieldSymbol fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                    if ((fieldSymbol.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        byteCodeGenerator.generate_8((byte)90);
                    }
                }
                byteCodeGenerator.incOpStackHeight(1);
            }
        }
        expression.generateByteCodeWrite(byteCodeGenerator);
    }

    static {
        $assertionsDisabled = !AssignmentBitOperationExpression.class.desiredAssertionStatus();
    }
}

