/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ArrayExpression;
import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.LocalVariableSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class AssignmentExpression
extends BinaryExpression {
    AssignmentExpression(int n, Expression expression, Expression expression2) {
        super((byte)5, n, expression, expression2);
    }

    /*
     * Enabled aggressive block sorting
     */
    Expression resolveAndCheck(Parser parser) {
        Expression expression;
        TypeSymbol typeSymbol;
        Expression expression2;
        block32: {
            expression2 = this.leftOperand;
            byte by = expression2.kind;
            if (by != 1 && by != 3) {
                parser.error(Message.errorDifferentKindRequired, expression2.pos, by == 0, Message.variableString, Message.valueString);
                by = 0;
            }
            expression2 = expression2.resolveAndCheckWrite(parser);
            by = expression2.kind;
            if (by != 1 && by != 3) {
                parser.error(Message.errorDifferentKindRequired, this.leftOperand.pos, by == 0 | expression2.kind == 0, Message.variableString, Message.valueString);
            }
            typeSymbol = expression2.getType();
            expression = this.rightOperand;
            if (expression.takeAssignmentContext()) {
                parser.assignmentContext = typeSymbol;
            }
            expression = expression.resolveAndCheck(parser);
            expression2.markDefined(parser);
            TypeSymbol typeSymbol2 = expression.getType();
            if (typeSymbol.isErroneous()) return ErrorExpression.errorExpression;
            if (typeSymbol2.isErroneous()) {
                return ErrorExpression.errorExpression;
            }
            if (typeSymbol.isReferenceType()) {
                if (!typeSymbol2.isReferenceType()) {
                    if (parser.options.sourceJDKVersion >= 150 && typeSymbol2.isPrimitiveType() && BoxingExpression.getPrimitiveType(parser, typeSymbol) != null) {
                        this.rightOperand = expression.promoteType(parser, typeSymbol);
                        break block32;
                    } else {
                        Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol2.isErroneous() | typeSymbol.isErroneous(), this.toString(), typeSymbol.errorName() + " " + Message.andString + " " + typeSymbol2.errorName());
                        return new ErrorExpression(error);
                    }
                }
                typeSymbol2.resolveType(parser, this.pos, false, true);
                ReferenceTypeSymbol referenceTypeSymbol = (ReferenceTypeSymbol)typeSymbol;
                ReferenceTypeSymbol referenceTypeSymbol2 = (ReferenceTypeSymbol)typeSymbol2;
                if (referenceTypeSymbol.isTypeParameter()) {
                    if (referenceTypeSymbol != referenceTypeSymbol2 && referenceTypeSymbol2 != ReferenceTypeSymbol.nullTypeSymbol) {
                        Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                        return new ErrorExpression(error);
                    }
                } else if (referenceTypeSymbol2.isTypeParameter()) {
                    referenceTypeSymbol2 = ((TypeParameterSymbol)referenceTypeSymbol2).bound;
                }
                if (!referenceTypeSymbol2.isAssignmentCompatible(parser, referenceTypeSymbol)) {
                    Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                typeSymbol.checkUncheckConversion(parser, this.pos, typeSymbol2, false);
                this.rightOperand = expression.promoteType(parser, typeSymbol);
                if (referenceTypeSymbol2 == ReferenceTypeSymbol.nullTypeSymbol && expression2 instanceof MethodVariableExpression) {
                    int n = parser.currentClassSymbol.cd.fieldCount + ((MethodVariableExpression)expression2).variable.varStackIndex;
                    parser.useSet.set(n);
                }
            } else if ((typeSymbol.typeClass & 2) != 0) {
                if ((typeSymbol2.typeClass & 2) == 0) {
                    if (parser.options.sourceJDKVersion >= 150 && typeSymbol2.equalTo(parser.javaLangBooleanSymbol)) {
                        expression = expression.promoteType(parser, typeSymbol);
                    } else {
                        Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), typeSymbol.errorName() + " " + Message.andString + " " + typeSymbol2.errorName());
                        return new ErrorExpression(error);
                    }
                }
                this.rightOperand = expression;
            } else {
                if ((typeSymbol2.typeClass & 0xFFFFFFC2) != 0) {
                    if (parser.options.sourceJDKVersion < 150 || !typeSymbol2.isReferenceType() || BoxingExpression.getPrimitiveType(parser, typeSymbol2) == null) {
                        Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), typeSymbol.errorName() + " " + Message.andString + " " + typeSymbol2.errorName());
                        return new ErrorExpression(error);
                    }
                } else if (expression.kind == 2 && this.rightOperand instanceof FieldExpression && ((FieldExpression)this.rightOperand).thisArgument != null && (typeSymbol.typeClass & typeSymbol2.typeClass & 4) != 0 && !typeSymbol.equalTo(typeSymbol2)) {
                    Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                    return new ErrorExpression(error);
                }
                this.rightOperand = expression.promoteType(parser, typeSymbol);
            }
        }
        this.leftOperand = expression2;
        this.setType(typeSymbol);
        if (expression2 instanceof MethodVariableExpression) {
            MethodVariableExpression methodVariableExpression = (MethodVariableExpression)expression2;
            if ((methodVariableExpression.getAccess() & 0x10) != 0 && methodVariableExpression.variable instanceof LocalVariableSymbol) {
                LocalVariableSymbol localVariableSymbol = (LocalVariableSymbol)methodVariableExpression.variable;
                if ((localVariableSymbol.flags & 2) == 0) {
                    localVariableSymbol.initializer = expression;
                    localVariableSymbol.flags = (byte)(localVariableSymbol.flags | 2);
                } else {
                    localVariableSymbol.initializer = null;
                }
            }
        } else if (expression2 instanceof FieldExpression) {
            FieldSymbol fieldSymbol = (FieldSymbol)((FieldExpression)expression2).field;
            if ((fieldSymbol.access & 0x10) != 0 && parser.currentFieldSymbol != null) {
                fieldSymbol.initializer = expression;
                fieldSymbol.flags = (short)(fieldSymbol.flags | 0xFFFF8004);
            }
        }
        if (expression2.kind != expression.kind) return this;
        if (expression2 instanceof MethodVariableExpression && expression instanceof MethodVariableExpression) {
            MethodVariableExpression methodVariableExpression = (MethodVariableExpression)expression2;
            MethodVariableExpression methodVariableExpression2 = (MethodVariableExpression)expression;
            if (methodVariableExpression.variable != methodVariableExpression2.variable) return this;
            parser.warning(methodVariableExpression.variable, Message.warningSelfAssignment, this.pos, methodVariableExpression.variable.errorName());
            return this;
        }
        if (!(expression2 instanceof FieldExpression)) return this;
        if (!(expression instanceof FieldExpression)) return this;
        FieldExpression fieldExpression = (FieldExpression)expression2;
        FieldExpression fieldExpression2 = (FieldExpression)expression;
        if (fieldExpression.field != fieldExpression2.field) return this;
        if (!(fieldExpression.thisArgument instanceof ThisExpression)) return this;
        if (!(fieldExpression2.thisArgument instanceof ThisExpression)) return this;
        ThisExpression thisExpression = (ThisExpression)fieldExpression2.thisArgument;
        ThisExpression thisExpression2 = (ThisExpression)fieldExpression.thisArgument;
        if (thisExpression2.outerClassSymbol != thisExpression.outerClassSymbol) return this;
        parser.warning(fieldExpression.field, Message.warningSelfAssignment, this.pos, fieldExpression.field.errorName());
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        FieldSymbol fieldSymbol;
        Expression expression = this.leftOperand;
        if (expression instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)expression;
            fieldSymbol = (FieldSymbol)fieldExpression.field;
            RawClassSymbol rawClassSymbol = fieldSymbol.definingClass;
            Expression expression2 = fieldExpression.thisArgument;
            if (expression2 != null) {
                rawClassSymbol = ((ClassSymbol)expression2.getType()).getClassSymbol();
                if (!byteCodeGenerator.methodSymbol.isConstructor() || !rawClassSymbol.isInnerClass() || fieldSymbol.definingClass.equalTo(rawClassSymbol) || fieldSymbol.definingClass.isSuperclass(rawClassSymbol)) {
                    expression2.generateByteCode(byteCodeGenerator);
                }
            } else if (fieldExpression.qualification != null) {
                rawClassSymbol = fieldExpression.qualification.getClassSymbol();
            }
            if (rawClassSymbol.isInnerClass() && !fieldSymbol.definingClass.equalTo(rawClassSymbol) && !fieldSymbol.definingClass.isSuperclass(rawClassSymbol)) {
                byteCodeGenerator.generateOuterClassFieldAccessor(fieldSymbol.definingClass, rawClassSymbol, false);
            }
        } else if (expression.kind == 3) {
            ArrayExpression arrayExpression = (ArrayExpression)expression;
            arrayExpression.arrayExpr.generateByteCode(byteCodeGenerator);
            arrayExpression.indexExpr.generateByteCode(byteCodeGenerator);
        }
        this.rightOperand.generateByteCode(byteCodeGenerator);
        if (this.getType().typeKind != 1) {
            if ((expression.getType().typeClass & 0x28) != 0) {
                if (expression.kind == 3) {
                    byteCodeGenerator.generate_8((byte)94);
                } else if (expression instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)92);
                } else {
                    fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                    if ((fieldSymbol.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)92);
                    } else {
                        byteCodeGenerator.generate_8((byte)93);
                    }
                }
                byteCodeGenerator.incOpStackHeight(2);
            } else {
                if (expression.kind == 3) {
                    byteCodeGenerator.generate_8((byte)91);
                } else if (expression instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)89);
                } else {
                    fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                    if ((fieldSymbol.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        byteCodeGenerator.generate_8((byte)90);
                    }
                }
                byteCodeGenerator.incOpStackHeight(1);
            }
        }
        expression.generateByteCodeWrite(byteCodeGenerator);
    }

    public String toString() {
        return "=";
    }
}

