/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class AssignmentOperationExpression
extends BinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    AssignmentOperationExpression(byte by, int n, Expression expression, Expression expression2) {
        super(by, n, expression, expression2);
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        Expression expression = this.leftOperand;
        byte by = expression.kind;
        if (by != 1 && by != 3) {
            parser.error(Message.errorDifferentKindRequired, expression.pos, by == 0, Message.variableString, Message.valueString);
        }
        expression = expression.resolveAndCheckReadBeforeWrite(parser);
        by = expression.kind;
        if (by != 1 && by != 3) {
            parser.error(Message.errorDifferentKindRequired, this.leftOperand.pos, by == 0, Message.variableString, Message.valueString);
        }
        Expression expression2 = this.rightOperand;
        expression2 = expression2.resolveAndCheck(parser);
        TypeSymbol typeSymbol2 = expression.getType();
        TypeSymbol typeSymbol3 = TypeSymbol.binaryNumericPromotion(parser, typeSymbol2, typeSymbol = expression2.getType());
        if (typeSymbol3.isErroneous()) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol.isErroneous() | typeSymbol2.isErroneous(), this.toString(), typeSymbol2.errorName() + " " + Message.andString + " " + typeSymbol.errorName());
            return new ErrorExpression(error);
        }
        this.setType(typeSymbol2);
        this.leftOperand = expression;
        this.rightOperand = expression2;
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator, byte by, byte by2, byte by3, byte by4) {
        Expression expression = this.leftOperand;
        expression.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
        TypeSymbol typeSymbol = expression.getType();
        Parser parser = byteCodeGenerator.parser;
        TypeSymbol typeSymbol2 = null;
        if (typeSymbol.isReferenceType()) {
            typeSymbol2 = BoxingExpression.getPrimitiveType(parser, typeSymbol);
            AutoUnboxingExpression.generateByteCode(byteCodeGenerator, typeSymbol, typeSymbol2);
            typeSymbol = typeSymbol2;
        }
        Expression expression2 = this.rightOperand;
        TypeSymbol typeSymbol3 = expression2.getType();
        TypeSymbol typeSymbol4 = TypeSymbol.binaryNumericPromotion(parser, typeSymbol, typeSymbol3);
        byte by5 = typeSymbol4.typeClass;
        byteCodeGenerator.generateWideningPrimitiveConversion(typeSymbol.typeClass, by5);
        expression2.generateByteCode(byteCodeGenerator);
        if (typeSymbol3.isReferenceType()) {
            AutoUnboxingExpression.generateByteCode(byteCodeGenerator, typeSymbol3, typeSymbol);
        }
        byteCodeGenerator.generateWideningPrimitiveConversion(typeSymbol3.typeClass, by5);
        switch (by5) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                byteCodeGenerator.generate_8(by);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8(by2);
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8(by3);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8(by4);
                byteCodeGenerator.decOpStackHeight(2);
            }
        }
        byteCodeGenerator.generateNarrowingPrimitiveConversion(by5, typeSymbol.typeKind);
        if (typeSymbol2 != null) {
            AutoBoxingExpression.generateByteCode(byteCodeGenerator, typeSymbol2, expression.getType());
        }
        if (this.getType().typeKind != 1) {
            if ((expression.getType().typeClass & 0x28) != 0) {
                if (expression.kind == 3) {
                    byteCodeGenerator.generate_8((byte)94);
                } else if (expression instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)92);
                } else {
                    FieldSymbol fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                    if ((fieldSymbol.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)92);
                    } else {
                        byteCodeGenerator.generate_8((byte)93);
                    }
                }
                byteCodeGenerator.incOpStackHeight(2);
            } else {
                if (expression.kind == 3) {
                    byteCodeGenerator.generate_8((byte)91);
                } else if (expression instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)89);
                } else {
                    FieldSymbol fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                    if ((fieldSymbol.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        byteCodeGenerator.generate_8((byte)90);
                    }
                }
                byteCodeGenerator.incOpStackHeight(1);
            }
        }
        expression.generateByteCodeWrite(byteCodeGenerator);
    }

    static {
        $assertionsDisabled = !AssignmentOperationExpression.class.desiredAssertionStatus();
    }
}

