/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class AssignmentShiftOperationExpression
extends BinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    AssignmentShiftOperationExpression(byte by, int n, Expression expression, Expression expression2) {
        super(by, n, expression, expression2);
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        Expression expression = this.leftOperand;
        byte by = expression.kind;
        if (by != 1 && by != 3) {
            parser.error(Message.errorDifferentKindRequired, expression.pos, by == 0, Message.variableString, Message.valueString);
        }
        expression = expression.resolveAndCheckReadBeforeWrite(parser);
        by = expression.kind;
        if (by != 1 && by != 3) {
            parser.error(Message.errorDifferentKindRequired, this.leftOperand.pos, by == 0, Message.variableString, Message.valueString);
        }
        Expression expression2 = this.rightOperand;
        expression2 = expression2.resolveAndCheck(parser);
        TypeSymbol typeSymbol2 = expression.getType();
        if (!((typeSymbol2.typeClass & 0xC) != 0 || parser.options.sourceJDKVersion >= 150 && typeSymbol2.isReferenceType() && (typeSymbol = BoxingExpression.getPrimitiveType(parser, typeSymbol2)) != null && (typeSymbol.typeClass & 0xC) != 0)) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol2.isErroneous(), this.toString(), typeSymbol2.errorName());
            return new ErrorExpression(error);
        }
        this.setType(typeSymbol2);
        TypeSymbol typeSymbol3 = expression2.getType();
        if ((typeSymbol3.typeClass & 0xC) == 0) {
            if (parser.options.sourceJDKVersion < 150 || !typeSymbol3.isReferenceType() || (typeSymbol = BoxingExpression.getPrimitiveType(parser, typeSymbol3)) == null || (typeSymbol.typeClass & 0xC) == 0) {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol3.isErroneous(), this.toString(), typeSymbol3.errorName());
                return new ErrorExpression(error);
            }
        } else if (typeSymbol3 != TypeSymbol.intSymbol) {
            CastExpression castExpression = new CastExpression(this.pos, expression2, TypeSymbol.intSymbol);
            if (expression2.kind == 2) {
                this.rightOperand = ((Expression)castExpression).resolveAndCheck(parser);
            } else {
                castExpression.setType(TypeSymbol.intSymbol);
                this.rightOperand = castExpression;
            }
        } else {
            this.rightOperand = expression2;
        }
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator, byte by, byte by2) {
        Expression expression = this.leftOperand;
        expression.generateByteCodeReadBeforeWrite(byteCodeGenerator, false);
        TypeSymbol typeSymbol = expression.getType();
        TypeSymbol typeSymbol2 = null;
        if (typeSymbol.isReferenceType()) {
            typeSymbol2 = BoxingExpression.getPrimitiveType(byteCodeGenerator.parser, typeSymbol);
            AutoUnboxingExpression.generateByteCode(byteCodeGenerator, typeSymbol, typeSymbol2);
            typeSymbol = typeSymbol2;
        }
        Expression expression2 = this.rightOperand;
        expression2.generateByteCode(byteCodeGenerator);
        TypeSymbol typeSymbol3 = expression2.getType();
        if (typeSymbol3.isReferenceType()) {
            AutoUnboxingExpression.generateByteCode(byteCodeGenerator, typeSymbol3, typeSymbol);
            TypeSymbol typeSymbol4 = BoxingExpression.getPrimitiveType(byteCodeGenerator.parser, typeSymbol3);
            byteCodeGenerator.generateNarrowingPrimitiveConversion(typeSymbol4.typeClass, (byte)6);
        }
        switch (typeSymbol.typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                byteCodeGenerator.generate_8(by);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8(by2);
            }
        }
        byteCodeGenerator.generateNarrowingPrimitiveConversion(typeSymbol.typeClass, typeSymbol.typeKind);
        byteCodeGenerator.decOpStackHeight(1);
        if (typeSymbol2 != null) {
            AutoBoxingExpression.generateByteCode(byteCodeGenerator, typeSymbol2, expression.getType());
        }
        if (this.getType().typeKind != 1) {
            if ((expression.getType().typeClass & 0x28) != 0) {
                if (expression.kind == 3) {
                    byteCodeGenerator.generate_8((byte)94);
                } else if (expression instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)92);
                } else {
                    FieldSymbol fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                    if ((fieldSymbol.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)92);
                    } else {
                        byteCodeGenerator.generate_8((byte)93);
                    }
                }
                byteCodeGenerator.incOpStackHeight(2);
            } else {
                if (expression.kind == 3) {
                    byteCodeGenerator.generate_8((byte)91);
                } else if (expression instanceof MethodVariableExpression) {
                    byteCodeGenerator.generate_8((byte)89);
                } else {
                    FieldSymbol fieldSymbol = (FieldSymbol)((FieldExpression)expression).field;
                    if ((fieldSymbol.access & 8) != 0) {
                        byteCodeGenerator.generate_8((byte)89);
                    } else {
                        byteCodeGenerator.generate_8((byte)90);
                    }
                }
                byteCodeGenerator.incOpStackHeight(1);
            }
        }
        expression.generateByteCodeWrite(byteCodeGenerator);
    }

    static {
        $assertionsDisabled = !AssignmentShiftOperationExpression.class.desiredAssertionStatus();
    }
}

