/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnaryExpression;

final class BinaryComplementExpression
extends UnaryExpression {
    BinaryComplementExpression(int n, Expression expression) {
        super((byte)40, n, expression);
    }

    Expression foldExpression() {
        Expression expression = this.operand;
        if (expression.kind == 2) {
            TypeSymbol typeSymbol = this.getType();
            if (typeSymbol.typeClass == 4) {
                return new IntConstantExpression(this.pos, typeSymbol, ~((ConstantExpression)expression).getIntConstValue());
            }
            return new LongConstantExpression(this.pos, ((LongConstantExpression)expression).lval ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return this;
    }

    Expression resolveAndCheck(Parser parser) {
        Expression expression = this.operand.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        if ((typeSymbol.typeClass & 0xC) == 0) {
            TypeSymbol typeSymbol2;
            if (parser.options.sourceJDKVersion >= 150 && (typeSymbol2 = BoxingExpression.getPrimitiveType(parser, typeSymbol)) != null && (typeSymbol2.typeClass & 0xC) != 0) {
                expression = expression.promoteType(parser, typeSymbol2);
                typeSymbol = typeSymbol2;
            } else {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol.isErroneous(), this.toString(), typeSymbol.errorName());
                return new ErrorExpression(error);
            }
        }
        typeSymbol = TypeSymbol.unaryNumericPromotion(parser, typeSymbol);
        this.setType(typeSymbol);
        this.operand = expression.promoteType(parser, typeSymbol);
        return this.foldExpression();
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.operand.generateByteCode(byteCodeGenerator);
        if ((this.operand.getType().typeClass & 4) != 0) {
            byteCodeGenerator.generate_8_8((byte)2, (byte)-126);
            byteCodeGenerator.incOpStackHeight(1);
            byteCodeGenerator.decOpStackHeight(1);
        } else {
            byteCodeGenerator.generate_8_8_8((byte)2, (byte)-123, (byte)-125);
            byteCodeGenerator.incOpStackHeight(2);
            byteCodeGenerator.decOpStackHeight(2);
        }
    }

    public String toString() {
        return "~";
    }
}

